/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class RestoreAccessBackupVaultListCopier {
    static List<RestoreAccessBackupVaultListMember> copy(
            Collection<? extends RestoreAccessBackupVaultListMember> restoreAccessBackupVaultListParam) {
        List<RestoreAccessBackupVaultListMember> list;
        if (restoreAccessBackupVaultListParam == null || restoreAccessBackupVaultListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RestoreAccessBackupVaultListMember> modifiableList = new ArrayList<>(restoreAccessBackupVaultListParam.size());
            restoreAccessBackupVaultListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<RestoreAccessBackupVaultListMember> copyFromBuilder(
            Collection<? extends RestoreAccessBackupVaultListMember.Builder> restoreAccessBackupVaultListParam) {
        List<RestoreAccessBackupVaultListMember> list;
        if (restoreAccessBackupVaultListParam == null || restoreAccessBackupVaultListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RestoreAccessBackupVaultListMember> modifiableList = new ArrayList<>(restoreAccessBackupVaultListParam.size());
            restoreAccessBackupVaultListParam.forEach(entry -> {
                RestoreAccessBackupVaultListMember member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<RestoreAccessBackupVaultListMember.Builder> copyToBuilder(
            Collection<? extends RestoreAccessBackupVaultListMember> restoreAccessBackupVaultListParam) {
        List<RestoreAccessBackupVaultListMember.Builder> list;
        if (restoreAccessBackupVaultListParam == null || restoreAccessBackupVaultListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RestoreAccessBackupVaultListMember.Builder> modifiableList = new ArrayList<>(
                    restoreAccessBackupVaultListParam.size());
            restoreAccessBackupVaultListParam.forEach(entry -> {
                RestoreAccessBackupVaultListMember.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
