/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSupportedResourceTypesResponse extends BackupResponse implements
        ToCopyableBuilder<GetSupportedResourceTypesResponse.Builder, GetSupportedResourceTypesResponse> {
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(GetSupportedResourceTypesResponse::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> resourceTypes;

    private GetSupportedResourceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTypes = builder.resourceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a string with the supported Amazon Web Services resource types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Aurora</code> for Amazon Aurora
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CloudFormation</code> for CloudFormation
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DynamoDB</code> for Amazon DynamoDB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EBS</code> for Amazon Elastic Block Store
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EC2</code> for Amazon Elastic Compute Cloud
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EFS</code> for Amazon Elastic File System
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FSx</code> for Amazon FSx
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Neptune</code> for Amazon Neptune
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RDS</code> for Amazon Relational Database Service
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Redshift</code> for Amazon Redshift
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAP HANA on Amazon EC2</code> for SAP HANA databases on Amazon Elastic Compute Cloud instances
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Storage Gateway</code> for Storage Gateway
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Timestream</code> for Amazon Timestream
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VirtualMachine</code> for VMware virtual machines
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return Contains a string with the supported Amazon Web Services resource types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Aurora</code> for Amazon Aurora
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CloudFormation</code> for CloudFormation
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DynamoDB</code> for Amazon DynamoDB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EBS</code> for Amazon Elastic Block Store
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EC2</code> for Amazon Elastic Compute Cloud
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EFS</code> for Amazon Elastic File System
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FSx</code> for Amazon FSx
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Neptune</code> for Amazon Neptune
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RDS</code> for Amazon Relational Database Service
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Redshift</code> for Amazon Redshift
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAP HANA on Amazon EC2</code> for SAP HANA databases on Amazon Elastic Compute Cloud instances
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Storage Gateway</code> for Storage Gateway
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Timestream</code> for Amazon Timestream
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VirtualMachine</code> for VMware virtual machines
     *         </p>
     *         </li>
     */
    public final List<String> resourceTypes() {
        return resourceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSupportedResourceTypesResponse)) {
            return false;
        }
        GetSupportedResourceTypesResponse other = (GetSupportedResourceTypesResponse) obj;
        return hasResourceTypes() == other.hasResourceTypes() && Objects.equals(resourceTypes(), other.resourceTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSupportedResourceTypesResponse")
                .add("ResourceTypes", hasResourceTypes() ? resourceTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceTypes", RESOURCE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSupportedResourceTypesResponse, T> g) {
        return obj -> g.apply((GetSupportedResourceTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSupportedResourceTypesResponse> {
        /**
         * <p>
         * Contains a string with the supported Amazon Web Services resource types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Aurora</code> for Amazon Aurora
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CloudFormation</code> for CloudFormation
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DynamoDB</code> for Amazon DynamoDB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EBS</code> for Amazon Elastic Block Store
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EC2</code> for Amazon Elastic Compute Cloud
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EFS</code> for Amazon Elastic File System
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FSx</code> for Amazon FSx
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Neptune</code> for Amazon Neptune
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RDS</code> for Amazon Relational Database Service
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Redshift</code> for Amazon Redshift
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAP HANA on Amazon EC2</code> for SAP HANA databases on Amazon Elastic Compute Cloud instances
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Storage Gateway</code> for Storage Gateway
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Timestream</code> for Amazon Timestream
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VirtualMachine</code> for VMware virtual machines
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceTypes
         *        Contains a string with the supported Amazon Web Services resource types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Aurora</code> for Amazon Aurora
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CloudFormation</code> for CloudFormation
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DynamoDB</code> for Amazon DynamoDB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EBS</code> for Amazon Elastic Block Store
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EC2</code> for Amazon Elastic Compute Cloud
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EFS</code> for Amazon Elastic File System
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FSx</code> for Amazon FSx
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Neptune</code> for Amazon Neptune
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RDS</code> for Amazon Relational Database Service
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Redshift</code> for Amazon Redshift
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAP HANA on Amazon EC2</code> for SAP HANA databases on Amazon Elastic Compute Cloud instances
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Storage Gateway</code> for Storage Gateway
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Timestream</code> for Amazon Timestream
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VirtualMachine</code> for VMware virtual machines
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * Contains a string with the supported Amazon Web Services resource types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Aurora</code> for Amazon Aurora
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CloudFormation</code> for CloudFormation
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DynamoDB</code> for Amazon DynamoDB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EBS</code> for Amazon Elastic Block Store
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EC2</code> for Amazon Elastic Compute Cloud
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EFS</code> for Amazon Elastic File System
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FSx</code> for Amazon FSx
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Neptune</code> for Amazon Neptune
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RDS</code> for Amazon Relational Database Service
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Redshift</code> for Amazon Redshift
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAP HANA on Amazon EC2</code> for SAP HANA databases on Amazon Elastic Compute Cloud instances
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Storage Gateway</code> for Storage Gateway
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Timestream</code> for Amazon Timestream
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VirtualMachine</code> for VMware virtual machines
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceTypes
         *        Contains a string with the supported Amazon Web Services resource types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Aurora</code> for Amazon Aurora
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CloudFormation</code> for CloudFormation
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DynamoDB</code> for Amazon DynamoDB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EBS</code> for Amazon Elastic Block Store
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EC2</code> for Amazon Elastic Compute Cloud
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EFS</code> for Amazon Elastic File System
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FSx</code> for Amazon FSx
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Neptune</code> for Amazon Neptune
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RDS</code> for Amazon Relational Database Service
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Redshift</code> for Amazon Redshift
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAP HANA on Amazon EC2</code> for SAP HANA databases on Amazon Elastic Compute Cloud instances
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Storage Gateway</code> for Storage Gateway
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Timestream</code> for Amazon Timestream
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VirtualMachine</code> for VMware virtual machines
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSupportedResourceTypesResponse model) {
            super(model);
            resourceTypes(model.resourceTypes);
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public GetSupportedResourceTypesResponse build() {
            return new GetSupportedResourceTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
