/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScanJobResponse extends BackupResponse implements
        ToCopyableBuilder<DescribeScanJobResponse.Builder, DescribeScanJobResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(DescribeScanJobResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultArn").getter(getter(DescribeScanJobResponse::backupVaultArn))
            .setter(setter(Builder::backupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()).build();

    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(DescribeScanJobResponse::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()).build();

    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionDate").getter(getter(DescribeScanJobResponse::completionDate))
            .setter(setter(Builder::completionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()).build();

    private static final SdkField<ScanJobCreator> CREATED_BY_FIELD = SdkField.<ScanJobCreator> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(DescribeScanJobResponse::createdBy)).setter(setter(Builder::createdBy))
            .constructor(ScanJobCreator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(DescribeScanJobResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(DescribeScanJobResponse::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> MALWARE_SCANNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MalwareScanner").getter(getter(DescribeScanJobResponse::malwareScannerAsString))
            .setter(setter(Builder::malwareScanner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MalwareScanner").build()).build();

    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryPointArn").getter(getter(DescribeScanJobResponse::recoveryPointArn))
            .setter(setter(Builder::recoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(DescribeScanJobResponse::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(DescribeScanJobResponse::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(DescribeScanJobResponse::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> SCAN_BASE_RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanBaseRecoveryPointArn").getter(getter(DescribeScanJobResponse::scanBaseRecoveryPointArn))
            .setter(setter(Builder::scanBaseRecoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanBaseRecoveryPointArn").build())
            .build();

    private static final SdkField<String> SCAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ScanId")
            .getter(getter(DescribeScanJobResponse::scanId)).setter(setter(Builder::scanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanId").build()).build();

    private static final SdkField<String> SCAN_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanJobId").getter(getter(DescribeScanJobResponse::scanJobId)).setter(setter(Builder::scanJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanJobId").build()).build();

    private static final SdkField<String> SCAN_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanMode").getter(getter(DescribeScanJobResponse::scanModeAsString)).setter(setter(Builder::scanMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanMode").build()).build();

    private static final SdkField<ScanResultInfo> SCAN_RESULT_FIELD = SdkField.<ScanResultInfo> builder(MarshallingType.SDK_POJO)
            .memberName("ScanResult").getter(getter(DescribeScanJobResponse::scanResult)).setter(setter(Builder::scanResult))
            .constructor(ScanResultInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanResult").build()).build();

    private static final SdkField<String> SCANNER_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScannerRoleArn").getter(getter(DescribeScanJobResponse::scannerRoleArn))
            .setter(setter(Builder::scannerRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScannerRoleArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DescribeScanJobResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(DescribeScanJobResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            BACKUP_VAULT_ARN_FIELD, BACKUP_VAULT_NAME_FIELD, COMPLETION_DATE_FIELD, CREATED_BY_FIELD, CREATION_DATE_FIELD,
            IAM_ROLE_ARN_FIELD, MALWARE_SCANNER_FIELD, RECOVERY_POINT_ARN_FIELD, RESOURCE_ARN_FIELD, RESOURCE_NAME_FIELD,
            RESOURCE_TYPE_FIELD, SCAN_BASE_RECOVERY_POINT_ARN_FIELD, SCAN_ID_FIELD, SCAN_JOB_ID_FIELD, SCAN_MODE_FIELD,
            SCAN_RESULT_FIELD, SCANNER_ROLE_ARN_FIELD, STATE_FIELD, STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String backupVaultArn;

    private final String backupVaultName;

    private final Instant completionDate;

    private final ScanJobCreator createdBy;

    private final Instant creationDate;

    private final String iamRoleArn;

    private final String malwareScanner;

    private final String recoveryPointArn;

    private final String resourceArn;

    private final String resourceName;

    private final String resourceType;

    private final String scanBaseRecoveryPointArn;

    private final String scanId;

    private final String scanJobId;

    private final String scanMode;

    private final ScanResultInfo scanResult;

    private final String scannerRoleArn;

    private final String state;

    private final String statusMessage;

    private DescribeScanJobResponse(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.backupVaultArn = builder.backupVaultArn;
        this.backupVaultName = builder.backupVaultName;
        this.completionDate = builder.completionDate;
        this.createdBy = builder.createdBy;
        this.creationDate = builder.creationDate;
        this.iamRoleArn = builder.iamRoleArn;
        this.malwareScanner = builder.malwareScanner;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.resourceArn = builder.resourceArn;
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
        this.scanBaseRecoveryPointArn = builder.scanBaseRecoveryPointArn;
        this.scanId = builder.scanId;
        this.scanJobId = builder.scanJobId;
        this.scanMode = builder.scanMode;
        this.scanResult = builder.scanResult;
        this.scannerRoleArn = builder.scannerRoleArn;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * Returns the account ID that owns the scan job.
     * </p>
     * <p>
     * Pattern: <code>^[0-9]{12}$</code>
     * </p>
     * 
     * @return Returns the account ID that owns the scan job.</p>
     *         <p>
     *         Pattern: <code>^[0-9]{12}$</code>
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>
     */
    public final String backupVaultArn() {
        return backupVaultArn;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the Amazon Web Services Region where they are created.
     * </p>
     * <p>
     * Pattern: <code>^[a-zA-Z0-9\-\_\.]{2,50}$</code>
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the account used to create them and the Amazon Web Services Region where they are created.</p>
     *         <p>
     *         Pattern: <code>^[a-zA-Z0-9\-\_\.]{2,50}$</code>
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * The date and time that a backup index finished creation, in Unix format and Coordinated Universal Time (UTC). The
     * value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     * represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a backup index finished creation, in Unix format and Coordinated Universal Time
     *         (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value
     *         1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant completionDate() {
        return completionDate;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final ScanJobCreator createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time that a backup index finished creation, in Unix format and Coordinated Universal Time (UTC). The
     * value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a backup index finished creation, in Unix format and Coordinated Universal Time
     *         (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value
     *         1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
     * <code>arn:aws:iam::123456789012:role/S3Access</code>.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
     *         <code>arn:aws:iam::123456789012:role/S3Access</code>.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The scanning engine used for the corresponding scan job. Currently only <code>GUARDUTY</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #malwareScanner}
     * will return {@link MalwareScanner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #malwareScannerAsString}.
     * </p>
     * 
     * @return The scanning engine used for the corresponding scan job. Currently only <code>GUARDUTY</code> is
     *         supported.
     * @see MalwareScanner
     */
    public final MalwareScanner malwareScanner() {
        return MalwareScanner.fromValue(malwareScanner);
    }

    /**
     * <p>
     * The scanning engine used for the corresponding scan job. Currently only <code>GUARDUTY</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #malwareScanner}
     * will return {@link MalwareScanner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #malwareScannerAsString}.
     * </p>
     * 
     * @return The scanning engine used for the corresponding scan job. Currently only <code>GUARDUTY</code> is
     *         supported.
     * @see MalwareScanner
     */
    public final String malwareScannerAsString() {
        return malwareScanner;
    }

    /**
     * <p>
     * An ARN that uniquely identifies the target recovery point for scanning.; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies the target recovery point for scanning.; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */
    public final String recoveryPointArn() {
        return recoveryPointArn;
    }

    /**
     * <p>
     * An ARN that uniquely identifies the source resource of the corresponding recovery point ARN.
     * </p>
     * 
     * @return An ARN that uniquely identifies the source resource of the corresponding recovery point ARN.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The non-unique name of the resource that belongs to the specified backup.
     * </p>
     * 
     * @return The non-unique name of the resource that belongs to the specified backup.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The type of Amazon Web Services Resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS)
     * volume.
     * </p>
     * <p>
     * Pattern: <code>^[a-zA-Z0-9\-\_\.]{1,50}$</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ScanResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of Amazon Web Services Resource to be backed up; for example, an Amazon Elastic Block Store
     *         (Amazon EBS) volume.</p>
     *         <p>
     *         Pattern: <code>^[a-zA-Z0-9\-\_\.]{1,50}$</code>
     * @see ScanResourceType
     */
    public final ScanResourceType resourceType() {
        return ScanResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of Amazon Web Services Resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS)
     * volume.
     * </p>
     * <p>
     * Pattern: <code>^[a-zA-Z0-9\-\_\.]{1,50}$</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ScanResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of Amazon Web Services Resource to be backed up; for example, an Amazon Elastic Block Store
     *         (Amazon EBS) volume.</p>
     *         <p>
     *         Pattern: <code>^[a-zA-Z0-9\-\_\.]{1,50}$</code>
     * @see ScanResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * An ARN that uniquely identifies the base recovery point for scanning. This field will only be populated when an
     * incremental scan job has taken place.
     * </p>
     * 
     * @return An ARN that uniquely identifies the base recovery point for scanning. This field will only be populated
     *         when an incremental scan job has taken place.
     */
    public final String scanBaseRecoveryPointArn() {
        return scanBaseRecoveryPointArn;
    }

    /**
     * <p>
     * The scan ID generated by Amazon GuardDuty for the corresponding Scan Job ID request from Backup.
     * </p>
     * 
     * @return The scan ID generated by Amazon GuardDuty for the corresponding Scan Job ID request from Backup.
     */
    public final String scanId() {
        return scanId;
    }

    /**
     * <p>
     * The scan job ID that uniquely identified the request to Backup.
     * </p>
     * 
     * @return The scan job ID that uniquely identified the request to Backup.
     */
    public final String scanJobId() {
        return scanJobId;
    }

    /**
     * <p>
     * Specifies the scan type used for the scan job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanMode} will
     * return {@link ScanMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanModeAsString}.
     * </p>
     * 
     * @return Specifies the scan type used for the scan job.
     * @see ScanMode
     */
    public final ScanMode scanMode() {
        return ScanMode.fromValue(scanMode);
    }

    /**
     * <p>
     * Specifies the scan type used for the scan job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanMode} will
     * return {@link ScanMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanModeAsString}.
     * </p>
     * 
     * @return Specifies the scan type used for the scan job.
     * @see ScanMode
     */
    public final String scanModeAsString() {
        return scanMode;
    }

    /**
     * <p>
     * Contains the <code>ScanResultsStatus</code> for the scanning job and returns <code>THREATS_FOUND</code> or
     * <code>NO_THREATS_FOUND</code> for completed jobs.
     * </p>
     * 
     * @return Contains the <code>ScanResultsStatus</code> for the scanning job and returns <code>THREATS_FOUND</code>
     *         or <code>NO_THREATS_FOUND</code> for completed jobs.
     */
    public final ScanResultInfo scanResult() {
        return scanResult;
    }

    /**
     * <p>
     * Specifies the scanner IAM role ARN used to for the scan job.
     * </p>
     * 
     * @return Specifies the scanner IAM role ARN used to for the scan job.
     */
    public final String scannerRoleArn() {
        return scannerRoleArn;
    }

    /**
     * <p>
     * The current state of a scan job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScanState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of a scan job.
     * @see ScanState
     */
    public final ScanState state() {
        return ScanState.fromValue(state);
    }

    /**
     * <p>
     * The current state of a scan job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScanState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of a scan job.
     * @see ScanState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * A detailed message explaining the status of the job to back up a resource.
     * </p>
     * 
     * @return A detailed message explaining the status of the job to back up a resource.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(malwareScannerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanBaseRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(scanId());
        hashCode = 31 * hashCode + Objects.hashCode(scanJobId());
        hashCode = 31 * hashCode + Objects.hashCode(scanModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanResult());
        hashCode = 31 * hashCode + Objects.hashCode(scannerRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScanJobResponse)) {
            return false;
        }
        DescribeScanJobResponse other = (DescribeScanJobResponse) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(backupVaultArn(), other.backupVaultArn())
                && Objects.equals(backupVaultName(), other.backupVaultName())
                && Objects.equals(completionDate(), other.completionDate()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(malwareScannerAsString(), other.malwareScannerAsString())
                && Objects.equals(recoveryPointArn(), other.recoveryPointArn())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(scanBaseRecoveryPointArn(), other.scanBaseRecoveryPointArn())
                && Objects.equals(scanId(), other.scanId()) && Objects.equals(scanJobId(), other.scanJobId())
                && Objects.equals(scanModeAsString(), other.scanModeAsString())
                && Objects.equals(scanResult(), other.scanResult()) && Objects.equals(scannerRoleArn(), other.scannerRoleArn())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeScanJobResponse").add("AccountId", accountId()).add("BackupVaultArn", backupVaultArn())
                .add("BackupVaultName", backupVaultName()).add("CompletionDate", completionDate()).add("CreatedBy", createdBy())
                .add("CreationDate", creationDate()).add("IamRoleArn", iamRoleArn())
                .add("MalwareScanner", malwareScannerAsString()).add("RecoveryPointArn", recoveryPointArn())
                .add("ResourceArn", resourceArn()).add("ResourceName", resourceName())
                .add("ResourceType", resourceTypeAsString()).add("ScanBaseRecoveryPointArn", scanBaseRecoveryPointArn())
                .add("ScanId", scanId()).add("ScanJobId", scanJobId()).add("ScanMode", scanModeAsString())
                .add("ScanResult", scanResult()).add("ScannerRoleArn", scannerRoleArn()).add("State", stateAsString())
                .add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "BackupVaultArn":
            return Optional.ofNullable(clazz.cast(backupVaultArn()));
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "CompletionDate":
            return Optional.ofNullable(clazz.cast(completionDate()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "MalwareScanner":
            return Optional.ofNullable(clazz.cast(malwareScannerAsString()));
        case "RecoveryPointArn":
            return Optional.ofNullable(clazz.cast(recoveryPointArn()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ScanBaseRecoveryPointArn":
            return Optional.ofNullable(clazz.cast(scanBaseRecoveryPointArn()));
        case "ScanId":
            return Optional.ofNullable(clazz.cast(scanId()));
        case "ScanJobId":
            return Optional.ofNullable(clazz.cast(scanJobId()));
        case "ScanMode":
            return Optional.ofNullable(clazz.cast(scanModeAsString()));
        case "ScanResult":
            return Optional.ofNullable(clazz.cast(scanResult()));
        case "ScannerRoleArn":
            return Optional.ofNullable(clazz.cast(scannerRoleArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("BackupVaultArn", BACKUP_VAULT_ARN_FIELD);
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("CompletionDate", COMPLETION_DATE_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("MalwareScanner", MALWARE_SCANNER_FIELD);
        map.put("RecoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ScanBaseRecoveryPointArn", SCAN_BASE_RECOVERY_POINT_ARN_FIELD);
        map.put("ScanId", SCAN_ID_FIELD);
        map.put("ScanJobId", SCAN_JOB_ID_FIELD);
        map.put("ScanMode", SCAN_MODE_FIELD);
        map.put("ScanResult", SCAN_RESULT_FIELD);
        map.put("ScannerRoleArn", SCANNER_ROLE_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeScanJobResponse, T> g) {
        return obj -> g.apply((DescribeScanJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeScanJobResponse> {
        /**
         * <p>
         * Returns the account ID that owns the scan job.
         * </p>
         * <p>
         * Pattern: <code>^[0-9]{12}$</code>
         * </p>
         * 
         * @param accountId
         *        Returns the account ID that owns the scan job.</p>
         *        <p>
         *        Pattern: <code>^[0-9]{12}$</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>
         * </p>
         * 
         * @param backupVaultArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultArn(String backupVaultArn);

        /**
         * <p>
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are
         * unique to the account used to create them and the Amazon Web Services Region where they are created.
         * </p>
         * <p>
         * Pattern: <code>^[a-zA-Z0-9\-\_\.]{2,50}$</code>
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Backup vaults are identified by names that
         *        are unique to the account used to create them and the Amazon Web Services Region where they are
         *        created.</p>
         *        <p>
         *        Pattern: <code>^[a-zA-Z0-9\-\_\.]{2,50}$</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * The date and time that a backup index finished creation, in Unix format and Coordinated Universal Time (UTC).
         * The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param completionDate
         *        The date and time that a backup index finished creation, in Unix format and Coordinated Universal Time
         *        (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionDate(Instant completionDate);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(ScanJobCreator createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ScanJobCreator.Builder} avoiding the need
         * to create one manually via {@link ScanJobCreator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScanJobCreator.Builder#build()} is called immediately and its
         * result is passed to {@link #createdBy(ScanJobCreator)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link ScanJobCreator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(ScanJobCreator)
         */
        default Builder createdBy(Consumer<ScanJobCreator.Builder> createdBy) {
            return createdBy(ScanJobCreator.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * The date and time that a backup index finished creation, in Unix format and Coordinated Universal Time (UTC).
         * The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationDate
         *        The date and time that a backup index finished creation, in Unix format and Coordinated Universal Time
         *        (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
         * <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * </p>
         * 
         * @param iamRoleArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
         *        <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The scanning engine used for the corresponding scan job. Currently only <code>GUARDUTY</code> is supported.
         * </p>
         * 
         * @param malwareScanner
         *        The scanning engine used for the corresponding scan job. Currently only <code>GUARDUTY</code> is
         *        supported.
         * @see MalwareScanner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareScanner
         */
        Builder malwareScanner(String malwareScanner);

        /**
         * <p>
         * The scanning engine used for the corresponding scan job. Currently only <code>GUARDUTY</code> is supported.
         * </p>
         * 
         * @param malwareScanner
         *        The scanning engine used for the corresponding scan job. Currently only <code>GUARDUTY</code> is
         *        supported.
         * @see MalwareScanner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareScanner
         */
        Builder malwareScanner(MalwareScanner malwareScanner);

        /**
         * <p>
         * An ARN that uniquely identifies the target recovery point for scanning.; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
         * </p>
         * 
         * @param recoveryPointArn
         *        An ARN that uniquely identifies the target recovery point for scanning.; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointArn(String recoveryPointArn);

        /**
         * <p>
         * An ARN that uniquely identifies the source resource of the corresponding recovery point ARN.
         * </p>
         * 
         * @param resourceArn
         *        An ARN that uniquely identifies the source resource of the corresponding recovery point ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The non-unique name of the resource that belongs to the specified backup.
         * </p>
         * 
         * @param resourceName
         *        The non-unique name of the resource that belongs to the specified backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The type of Amazon Web Services Resource to be backed up; for example, an Amazon Elastic Block Store (Amazon
         * EBS) volume.
         * </p>
         * <p>
         * Pattern: <code>^[a-zA-Z0-9\-\_\.]{1,50}$</code>
         * </p>
         * 
         * @param resourceType
         *        The type of Amazon Web Services Resource to be backed up; for example, an Amazon Elastic Block Store
         *        (Amazon EBS) volume.</p>
         *        <p>
         *        Pattern: <code>^[a-zA-Z0-9\-\_\.]{1,50}$</code>
         * @see ScanResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of Amazon Web Services Resource to be backed up; for example, an Amazon Elastic Block Store (Amazon
         * EBS) volume.
         * </p>
         * <p>
         * Pattern: <code>^[a-zA-Z0-9\-\_\.]{1,50}$</code>
         * </p>
         * 
         * @param resourceType
         *        The type of Amazon Web Services Resource to be backed up; for example, an Amazon Elastic Block Store
         *        (Amazon EBS) volume.</p>
         *        <p>
         *        Pattern: <code>^[a-zA-Z0-9\-\_\.]{1,50}$</code>
         * @see ScanResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanResourceType
         */
        Builder resourceType(ScanResourceType resourceType);

        /**
         * <p>
         * An ARN that uniquely identifies the base recovery point for scanning. This field will only be populated when
         * an incremental scan job has taken place.
         * </p>
         * 
         * @param scanBaseRecoveryPointArn
         *        An ARN that uniquely identifies the base recovery point for scanning. This field will only be
         *        populated when an incremental scan job has taken place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanBaseRecoveryPointArn(String scanBaseRecoveryPointArn);

        /**
         * <p>
         * The scan ID generated by Amazon GuardDuty for the corresponding Scan Job ID request from Backup.
         * </p>
         * 
         * @param scanId
         *        The scan ID generated by Amazon GuardDuty for the corresponding Scan Job ID request from Backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanId(String scanId);

        /**
         * <p>
         * The scan job ID that uniquely identified the request to Backup.
         * </p>
         * 
         * @param scanJobId
         *        The scan job ID that uniquely identified the request to Backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanJobId(String scanJobId);

        /**
         * <p>
         * Specifies the scan type used for the scan job.
         * </p>
         * 
         * @param scanMode
         *        Specifies the scan type used for the scan job.
         * @see ScanMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanMode
         */
        Builder scanMode(String scanMode);

        /**
         * <p>
         * Specifies the scan type used for the scan job.
         * </p>
         * 
         * @param scanMode
         *        Specifies the scan type used for the scan job.
         * @see ScanMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanMode
         */
        Builder scanMode(ScanMode scanMode);

        /**
         * <p>
         * Contains the <code>ScanResultsStatus</code> for the scanning job and returns <code>THREATS_FOUND</code> or
         * <code>NO_THREATS_FOUND</code> for completed jobs.
         * </p>
         * 
         * @param scanResult
         *        Contains the <code>ScanResultsStatus</code> for the scanning job and returns
         *        <code>THREATS_FOUND</code> or <code>NO_THREATS_FOUND</code> for completed jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanResult(ScanResultInfo scanResult);

        /**
         * <p>
         * Contains the <code>ScanResultsStatus</code> for the scanning job and returns <code>THREATS_FOUND</code> or
         * <code>NO_THREATS_FOUND</code> for completed jobs.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScanResultInfo.Builder} avoiding the need
         * to create one manually via {@link ScanResultInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScanResultInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #scanResult(ScanResultInfo)}.
         * 
         * @param scanResult
         *        a consumer that will call methods on {@link ScanResultInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanResult(ScanResultInfo)
         */
        default Builder scanResult(Consumer<ScanResultInfo.Builder> scanResult) {
            return scanResult(ScanResultInfo.builder().applyMutation(scanResult).build());
        }

        /**
         * <p>
         * Specifies the scanner IAM role ARN used to for the scan job.
         * </p>
         * 
         * @param scannerRoleArn
         *        Specifies the scanner IAM role ARN used to for the scan job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scannerRoleArn(String scannerRoleArn);

        /**
         * <p>
         * The current state of a scan job.
         * </p>
         * 
         * @param state
         *        The current state of a scan job.
         * @see ScanState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of a scan job.
         * </p>
         * 
         * @param state
         *        The current state of a scan job.
         * @see ScanState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanState
         */
        Builder state(ScanState state);

        /**
         * <p>
         * A detailed message explaining the status of the job to back up a resource.
         * </p>
         * 
         * @param statusMessage
         *        A detailed message explaining the status of the job to back up a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String accountId;

        private String backupVaultArn;

        private String backupVaultName;

        private Instant completionDate;

        private ScanJobCreator createdBy;

        private Instant creationDate;

        private String iamRoleArn;

        private String malwareScanner;

        private String recoveryPointArn;

        private String resourceArn;

        private String resourceName;

        private String resourceType;

        private String scanBaseRecoveryPointArn;

        private String scanId;

        private String scanJobId;

        private String scanMode;

        private ScanResultInfo scanResult;

        private String scannerRoleArn;

        private String state;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScanJobResponse model) {
            super(model);
            accountId(model.accountId);
            backupVaultArn(model.backupVaultArn);
            backupVaultName(model.backupVaultName);
            completionDate(model.completionDate);
            createdBy(model.createdBy);
            creationDate(model.creationDate);
            iamRoleArn(model.iamRoleArn);
            malwareScanner(model.malwareScanner);
            recoveryPointArn(model.recoveryPointArn);
            resourceArn(model.resourceArn);
            resourceName(model.resourceName);
            resourceType(model.resourceType);
            scanBaseRecoveryPointArn(model.scanBaseRecoveryPointArn);
            scanId(model.scanId);
            scanJobId(model.scanJobId);
            scanMode(model.scanMode);
            scanResult(model.scanResult);
            scannerRoleArn(model.scannerRoleArn);
            state(model.state);
            statusMessage(model.statusMessage);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBackupVaultArn() {
            return backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final Instant getCompletionDate() {
            return completionDate;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final ScanJobCreator.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(ScanJobCreator.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(ScanJobCreator createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getMalwareScanner() {
            return malwareScanner;
        }

        public final void setMalwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
        }

        @Override
        public final Builder malwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
            return this;
        }

        @Override
        public final Builder malwareScanner(MalwareScanner malwareScanner) {
            this.malwareScanner(malwareScanner == null ? null : malwareScanner.toString());
            return this;
        }

        public final String getRecoveryPointArn() {
            return recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ScanResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getScanBaseRecoveryPointArn() {
            return scanBaseRecoveryPointArn;
        }

        public final void setScanBaseRecoveryPointArn(String scanBaseRecoveryPointArn) {
            this.scanBaseRecoveryPointArn = scanBaseRecoveryPointArn;
        }

        @Override
        public final Builder scanBaseRecoveryPointArn(String scanBaseRecoveryPointArn) {
            this.scanBaseRecoveryPointArn = scanBaseRecoveryPointArn;
            return this;
        }

        public final String getScanId() {
            return scanId;
        }

        public final void setScanId(String scanId) {
            this.scanId = scanId;
        }

        @Override
        public final Builder scanId(String scanId) {
            this.scanId = scanId;
            return this;
        }

        public final String getScanJobId() {
            return scanJobId;
        }

        public final void setScanJobId(String scanJobId) {
            this.scanJobId = scanJobId;
        }

        @Override
        public final Builder scanJobId(String scanJobId) {
            this.scanJobId = scanJobId;
            return this;
        }

        public final String getScanMode() {
            return scanMode;
        }

        public final void setScanMode(String scanMode) {
            this.scanMode = scanMode;
        }

        @Override
        public final Builder scanMode(String scanMode) {
            this.scanMode = scanMode;
            return this;
        }

        @Override
        public final Builder scanMode(ScanMode scanMode) {
            this.scanMode(scanMode == null ? null : scanMode.toString());
            return this;
        }

        public final ScanResultInfo.Builder getScanResult() {
            return scanResult != null ? scanResult.toBuilder() : null;
        }

        public final void setScanResult(ScanResultInfo.BuilderImpl scanResult) {
            this.scanResult = scanResult != null ? scanResult.build() : null;
        }

        @Override
        public final Builder scanResult(ScanResultInfo scanResult) {
            this.scanResult = scanResult;
            return this;
        }

        public final String getScannerRoleArn() {
            return scannerRoleArn;
        }

        public final void setScannerRoleArn(String scannerRoleArn) {
            this.scannerRoleArn = scannerRoleArn;
        }

        @Override
        public final Builder scannerRoleArn(String scannerRoleArn) {
            this.scannerRoleArn = scannerRoleArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScanState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public DescribeScanJobResponse build() {
            return new DescribeScanJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
