/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata about a backup plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackupPlansListMember implements SdkPojo, Serializable,
        ToCopyableBuilder<BackupPlansListMember.Builder, BackupPlansListMember> {
    private static final SdkField<String> BACKUP_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanArn").getter(getter(BackupPlansListMember::backupPlanArn))
            .setter(setter(Builder::backupPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanArn").build()).build();

    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanId").getter(getter(BackupPlansListMember::backupPlanId)).setter(setter(Builder::backupPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(BackupPlansListMember::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> DELETION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeletionDate").getter(getter(BackupPlansListMember::deletionDate)).setter(setter(Builder::deletionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionDate").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(BackupPlansListMember::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final SdkField<String> BACKUP_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanName").getter(getter(BackupPlansListMember::backupPlanName))
            .setter(setter(Builder::backupPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanName").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(BackupPlansListMember::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<Instant> LAST_EXECUTION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastExecutionDate").getter(getter(BackupPlansListMember::lastExecutionDate))
            .setter(setter(Builder::lastExecutionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutionDate").build()).build();

    private static final SdkField<List<AdvancedBackupSetting>> ADVANCED_BACKUP_SETTINGS_FIELD = SdkField
            .<List<AdvancedBackupSetting>> builder(MarshallingType.LIST)
            .memberName("AdvancedBackupSettings")
            .getter(getter(BackupPlansListMember::advancedBackupSettings))
            .setter(setter(Builder::advancedBackupSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedBackupSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdvancedBackupSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdvancedBackupSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_ARN_FIELD,
            BACKUP_PLAN_ID_FIELD, CREATION_DATE_FIELD, DELETION_DATE_FIELD, VERSION_ID_FIELD, BACKUP_PLAN_NAME_FIELD,
            CREATOR_REQUEST_ID_FIELD, LAST_EXECUTION_DATE_FIELD, ADVANCED_BACKUP_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String backupPlanArn;

    private final String backupPlanId;

    private final Instant creationDate;

    private final Instant deletionDate;

    private final String versionId;

    private final String backupPlanName;

    private final String creatorRequestId;

    private final Instant lastExecutionDate;

    private final List<AdvancedBackupSetting> advancedBackupSettings;

    private BackupPlansListMember(BuilderImpl builder) {
        this.backupPlanArn = builder.backupPlanArn;
        this.backupPlanId = builder.backupPlanId;
        this.creationDate = builder.creationDate;
        this.deletionDate = builder.deletionDate;
        this.versionId = builder.versionId;
        this.backupPlanName = builder.backupPlanName;
        this.creatorRequestId = builder.creatorRequestId;
        this.lastExecutionDate = builder.lastExecutionDate;
        this.advancedBackupSettings = builder.advancedBackupSettings;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.
     */
    public final String backupPlanArn() {
        return backupPlanArn;
    }

    /**
     * <p>
     * Uniquely identifies a backup plan.
     * </p>
     * 
     * @return Uniquely identifies a backup plan.
     */
    public final String backupPlanId() {
        return backupPlanId;
    }

    /**
     * <p>
     * The date and time a resource backup plan is created, in Unix format and Coordinated Universal Time (UTC). The
     * value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time a resource backup plan is created, in Unix format and Coordinated Universal Time (UTC).
     *         The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date and time a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of
     * <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     * January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant deletionDate() {
        return deletionDate;
    }

    /**
     * <p>
     * Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot
     * be edited.
     * </p>
     * 
     * @return Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs
     *         cannot be edited.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * <p>
     * The display name of a saved backup plan.
     * </p>
     * 
     * @return The display name of a saved backup plan.
     */
    public final String backupPlanName() {
        return backupPlanName;
    }

    /**
     * <p>
     * A unique string that identifies the request and allows failed requests to be retried without the risk of running
     * the operation twice. This parameter is optional.
     * </p>
     * <p>
     * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     * </p>
     * 
     * @return A unique string that identifies the request and allows failed requests to be retried without the risk of
     *         running the operation twice. This parameter is optional.</p>
     *         <p>
     *         If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * The last time this backup plan was run. A date and time, in Unix format and Coordinated Universal Time (UTC). The
     * value of <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     * represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The last time this backup plan was run. A date and time, in Unix format and Coordinated Universal Time
     *         (UTC). The value of <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value
     *         1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant lastExecutionDate() {
        return lastExecutionDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdvancedBackupSettings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdvancedBackupSettings() {
        return advancedBackupSettings != null && !(advancedBackupSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of <code>BackupOptions</code> for a resource type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdvancedBackupSettings} method.
     * </p>
     * 
     * @return Contains a list of <code>BackupOptions</code> for a resource type.
     */
    public final List<AdvancedBackupSetting> advancedBackupSettings() {
        return advancedBackupSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(deletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(lastExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdvancedBackupSettings() ? advancedBackupSettings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupPlansListMember)) {
            return false;
        }
        BackupPlansListMember other = (BackupPlansListMember) obj;
        return Objects.equals(backupPlanArn(), other.backupPlanArn()) && Objects.equals(backupPlanId(), other.backupPlanId())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(deletionDate(), other.deletionDate())
                && Objects.equals(versionId(), other.versionId()) && Objects.equals(backupPlanName(), other.backupPlanName())
                && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(lastExecutionDate(), other.lastExecutionDate())
                && hasAdvancedBackupSettings() == other.hasAdvancedBackupSettings()
                && Objects.equals(advancedBackupSettings(), other.advancedBackupSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BackupPlansListMember").add("BackupPlanArn", backupPlanArn())
                .add("BackupPlanId", backupPlanId()).add("CreationDate", creationDate()).add("DeletionDate", deletionDate())
                .add("VersionId", versionId()).add("BackupPlanName", backupPlanName())
                .add("CreatorRequestId", creatorRequestId()).add("LastExecutionDate", lastExecutionDate())
                .add("AdvancedBackupSettings", hasAdvancedBackupSettings() ? advancedBackupSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlanArn":
            return Optional.ofNullable(clazz.cast(backupPlanArn()));
        case "BackupPlanId":
            return Optional.ofNullable(clazz.cast(backupPlanId()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "DeletionDate":
            return Optional.ofNullable(clazz.cast(deletionDate()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "BackupPlanName":
            return Optional.ofNullable(clazz.cast(backupPlanName()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "LastExecutionDate":
            return Optional.ofNullable(clazz.cast(lastExecutionDate()));
        case "AdvancedBackupSettings":
            return Optional.ofNullable(clazz.cast(advancedBackupSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackupPlanArn", BACKUP_PLAN_ARN_FIELD);
        map.put("BackupPlanId", BACKUP_PLAN_ID_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("DeletionDate", DELETION_DATE_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        map.put("BackupPlanName", BACKUP_PLAN_NAME_FIELD);
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        map.put("LastExecutionDate", LAST_EXECUTION_DATE_FIELD);
        map.put("AdvancedBackupSettings", ADVANCED_BACKUP_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BackupPlansListMember, T> g) {
        return obj -> g.apply((BackupPlansListMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackupPlansListMember> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.
         * </p>
         * 
         * @param backupPlanArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanArn(String backupPlanArn);

        /**
         * <p>
         * Uniquely identifies a backup plan.
         * </p>
         * 
         * @param backupPlanId
         *        Uniquely identifies a backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanId(String backupPlanId);

        /**
         * <p>
         * The date and time a resource backup plan is created, in Unix format and Coordinated Universal Time (UTC). The
         * value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationDate
         *        The date and time a resource backup plan is created, in Unix format and Coordinated Universal Time
         *        (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date and time a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of
         * <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
         * Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param deletionDate
         *        The date and time a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The
         *        value of <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087
         *        represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionDate(Instant deletionDate);

        /**
         * <p>
         * Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs
         * cannot be edited.
         * </p>
         * 
         * @param versionId
         *        Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version
         *        IDs cannot be edited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * The display name of a saved backup plan.
         * </p>
         * 
         * @param backupPlanName
         *        The display name of a saved backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanName(String backupPlanName);

        /**
         * <p>
         * A unique string that identifies the request and allows failed requests to be retried without the risk of
         * running the operation twice. This parameter is optional.
         * </p>
         * <p>
         * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string that identifies the request and allows failed requests to be retried without the risk
         *        of running the operation twice. This parameter is optional.</p>
         *        <p>
         *        If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * The last time this backup plan was run. A date and time, in Unix format and Coordinated Universal Time (UTC).
         * The value of <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value
         * 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param lastExecutionDate
         *        The last time this backup plan was run. A date and time, in Unix format and Coordinated Universal Time
         *        (UTC). The value of <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastExecutionDate(Instant lastExecutionDate);

        /**
         * <p>
         * Contains a list of <code>BackupOptions</code> for a resource type.
         * </p>
         * 
         * @param advancedBackupSettings
         *        Contains a list of <code>BackupOptions</code> for a resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedBackupSettings(Collection<AdvancedBackupSetting> advancedBackupSettings);

        /**
         * <p>
         * Contains a list of <code>BackupOptions</code> for a resource type.
         * </p>
         * 
         * @param advancedBackupSettings
         *        Contains a list of <code>BackupOptions</code> for a resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedBackupSettings(AdvancedBackupSetting... advancedBackupSettings);

        /**
         * <p>
         * Contains a list of <code>BackupOptions</code> for a resource type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.AdvancedBackupSetting.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.backup.model.AdvancedBackupSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.AdvancedBackupSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #advancedBackupSettings(List<AdvancedBackupSetting>)}.
         * 
         * @param advancedBackupSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.AdvancedBackupSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedBackupSettings(java.util.Collection<AdvancedBackupSetting>)
         */
        Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder>... advancedBackupSettings);
    }

    static final class BuilderImpl implements Builder {
        private String backupPlanArn;

        private String backupPlanId;

        private Instant creationDate;

        private Instant deletionDate;

        private String versionId;

        private String backupPlanName;

        private String creatorRequestId;

        private Instant lastExecutionDate;

        private List<AdvancedBackupSetting> advancedBackupSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BackupPlansListMember model) {
            backupPlanArn(model.backupPlanArn);
            backupPlanId(model.backupPlanId);
            creationDate(model.creationDate);
            deletionDate(model.deletionDate);
            versionId(model.versionId);
            backupPlanName(model.backupPlanName);
            creatorRequestId(model.creatorRequestId);
            lastExecutionDate(model.lastExecutionDate);
            advancedBackupSettings(model.advancedBackupSettings);
        }

        public final String getBackupPlanArn() {
            return backupPlanArn;
        }

        public final void setBackupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
        }

        @Override
        public final Builder backupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
            return this;
        }

        public final String getBackupPlanId() {
            return backupPlanId;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getDeletionDate() {
            return deletionDate;
        }

        public final void setDeletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
        }

        @Override
        public final Builder deletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final String getBackupPlanName() {
            return backupPlanName;
        }

        public final void setBackupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
        }

        @Override
        public final Builder backupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
            return this;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final Instant getLastExecutionDate() {
            return lastExecutionDate;
        }

        public final void setLastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
        }

        @Override
        public final Builder lastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
            return this;
        }

        public final List<AdvancedBackupSetting.Builder> getAdvancedBackupSettings() {
            List<AdvancedBackupSetting.Builder> result = AdvancedBackupSettingsCopier.copyToBuilder(this.advancedBackupSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdvancedBackupSettings(Collection<AdvancedBackupSetting.BuilderImpl> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copyFromBuilder(advancedBackupSettings);
        }

        @Override
        public final Builder advancedBackupSettings(Collection<AdvancedBackupSetting> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copy(advancedBackupSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(AdvancedBackupSetting... advancedBackupSettings) {
            advancedBackupSettings(Arrays.asList(advancedBackupSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder>... advancedBackupSettings) {
            advancedBackupSettings(Stream.of(advancedBackupSettings)
                    .map(c -> AdvancedBackupSetting.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BackupPlansListMember build() {
            return new BackupPlansListMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
