/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.MalwareScanner;
import software.amazon.awssdk.services.backup.model.ScanJobStatus;
import software.amazon.awssdk.services.backup.model.ScanResultStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScanJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScanJobSummary> {
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(ScanJobSummary.getter(ScanJobSummary::region)).setter(ScanJobSummary.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ScanJobSummary.getter(ScanJobSummary::accountId)).setter(ScanJobSummary.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ScanJobSummary.getter(ScanJobSummary::stateAsString)).setter(ScanJobSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ScanJobSummary.getter(ScanJobSummary::resourceType)).setter(ScanJobSummary.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Count").getter(ScanJobSummary.getter(ScanJobSummary::count)).setter(ScanJobSummary.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ScanJobSummary.getter(ScanJobSummary::startTime)).setter(ScanJobSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ScanJobSummary.getter(ScanJobSummary::endTime)).setter(ScanJobSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> MALWARE_SCANNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MalwareScanner").getter(ScanJobSummary.getter(ScanJobSummary::malwareScannerAsString)).setter(ScanJobSummary.setter(Builder::malwareScanner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MalwareScanner").build()}).build();
    private static final SdkField<String> SCAN_RESULT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanResultStatus").getter(ScanJobSummary.getter(ScanJobSummary::scanResultStatusAsString)).setter(ScanJobSummary.setter(Builder::scanResultStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanResultStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, ACCOUNT_ID_FIELD, STATE_FIELD, RESOURCE_TYPE_FIELD, COUNT_FIELD, START_TIME_FIELD, END_TIME_FIELD, MALWARE_SCANNER_FIELD, SCAN_RESULT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScanJobSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String region;
    private final String accountId;
    private final String state;
    private final String resourceType;
    private final Integer count;
    private final Instant startTime;
    private final Instant endTime;
    private final String malwareScanner;
    private final String scanResultStatus;

    private ScanJobSummary(BuilderImpl builder) {
        this.region = builder.region;
        this.accountId = builder.accountId;
        this.state = builder.state;
        this.resourceType = builder.resourceType;
        this.count = builder.count;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.malwareScanner = builder.malwareScanner;
        this.scanResultStatus = builder.scanResultStatus;
    }

    public final String region() {
        return this.region;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final ScanJobStatus state() {
        return ScanJobStatus.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final Integer count() {
        return this.count;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final MalwareScanner malwareScanner() {
        return MalwareScanner.fromValue(this.malwareScanner);
    }

    public final String malwareScannerAsString() {
        return this.malwareScanner;
    }

    public final ScanResultStatus scanResultStatus() {
        return ScanResultStatus.fromValue(this.scanResultStatus);
    }

    public final String scanResultStatusAsString() {
        return this.scanResultStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.malwareScannerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanResultStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanJobSummary)) {
            return false;
        }
        ScanJobSummary other = (ScanJobSummary)obj;
        return Objects.equals(this.region(), other.region()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.malwareScannerAsString(), other.malwareScannerAsString()) && Objects.equals(this.scanResultStatusAsString(), other.scanResultStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ScanJobSummary").add("Region", (Object)this.region()).add("AccountId", (Object)this.accountId()).add("State", (Object)this.stateAsString()).add("ResourceType", (Object)this.resourceType()).add("Count", (Object)this.count()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("MalwareScanner", (Object)this.malwareScannerAsString()).add("ScanResultStatus", (Object)this.scanResultStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "MalwareScanner": {
                return Optional.ofNullable(clazz.cast(this.malwareScannerAsString()));
            }
            case "ScanResultStatus": {
                return Optional.ofNullable(clazz.cast(this.scanResultStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Region", REGION_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("Count", COUNT_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("MalwareScanner", MALWARE_SCANNER_FIELD);
        map.put("ScanResultStatus", SCAN_RESULT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScanJobSummary, T> g) {
        return obj -> g.apply((ScanJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private String accountId;
        private String state;
        private String resourceType;
        private Integer count;
        private Instant startTime;
        private Instant endTime;
        private String malwareScanner;
        private String scanResultStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanJobSummary model) {
            this.region(model.region);
            this.accountId(model.accountId);
            this.state(model.state);
            this.resourceType(model.resourceType);
            this.count(model.count);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.malwareScanner(model.malwareScanner);
            this.scanResultStatus(model.scanResultStatus);
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScanJobStatus state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getMalwareScanner() {
            return this.malwareScanner;
        }

        public final void setMalwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
        }

        @Override
        public final Builder malwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
            return this;
        }

        @Override
        public final Builder malwareScanner(MalwareScanner malwareScanner) {
            this.malwareScanner(malwareScanner == null ? null : malwareScanner.toString());
            return this;
        }

        public final String getScanResultStatus() {
            return this.scanResultStatus;
        }

        public final void setScanResultStatus(String scanResultStatus) {
            this.scanResultStatus = scanResultStatus;
        }

        @Override
        public final Builder scanResultStatus(String scanResultStatus) {
            this.scanResultStatus = scanResultStatus;
            return this;
        }

        @Override
        public final Builder scanResultStatus(ScanResultStatus scanResultStatus) {
            this.scanResultStatus(scanResultStatus == null ? null : scanResultStatus.toString());
            return this;
        }

        public ScanJobSummary build() {
            return new ScanJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScanJobSummary> {
        public Builder region(String var1);

        public Builder accountId(String var1);

        public Builder state(String var1);

        public Builder state(ScanJobStatus var1);

        public Builder resourceType(String var1);

        public Builder count(Integer var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder malwareScanner(String var1);

        public Builder malwareScanner(MalwareScanner var1);

        public Builder scanResultStatus(String var1);

        public Builder scanResultStatus(ScanResultStatus var1);
    }
}

