/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.ReportDeliveryChannel;
import software.amazon.awssdk.services.backup.model.ReportSetting;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportPlan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportPlan> {
    private static final SdkField<String> REPORT_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportPlanArn").getter(ReportPlan.getter(ReportPlan::reportPlanArn)).setter(ReportPlan.setter(Builder::reportPlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanArn").build()}).build();
    private static final SdkField<String> REPORT_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportPlanName").getter(ReportPlan.getter(ReportPlan::reportPlanName)).setter(ReportPlan.setter(Builder::reportPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanName").build()}).build();
    private static final SdkField<String> REPORT_PLAN_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportPlanDescription").getter(ReportPlan.getter(ReportPlan::reportPlanDescription)).setter(ReportPlan.setter(Builder::reportPlanDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanDescription").build()}).build();
    private static final SdkField<ReportSetting> REPORT_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReportSetting").getter(ReportPlan.getter(ReportPlan::reportSetting)).setter(ReportPlan.setter(Builder::reportSetting)).constructor(ReportSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportSetting").build()}).build();
    private static final SdkField<ReportDeliveryChannel> REPORT_DELIVERY_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReportDeliveryChannel").getter(ReportPlan.getter(ReportPlan::reportDeliveryChannel)).setter(ReportPlan.setter(Builder::reportDeliveryChannel)).constructor(ReportDeliveryChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportDeliveryChannel").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentStatus").getter(ReportPlan.getter(ReportPlan::deploymentStatus)).setter(ReportPlan.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ReportPlan.getter(ReportPlan::creationTime)).setter(ReportPlan.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_ATTEMPTED_EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastAttemptedExecutionTime").getter(ReportPlan.getter(ReportPlan::lastAttemptedExecutionTime)).setter(ReportPlan.setter(Builder::lastAttemptedExecutionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAttemptedExecutionTime").build()}).build();
    private static final SdkField<Instant> LAST_SUCCESSFUL_EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSuccessfulExecutionTime").getter(ReportPlan.getter(ReportPlan::lastSuccessfulExecutionTime)).setter(ReportPlan.setter(Builder::lastSuccessfulExecutionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulExecutionTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_PLAN_ARN_FIELD, REPORT_PLAN_NAME_FIELD, REPORT_PLAN_DESCRIPTION_FIELD, REPORT_SETTING_FIELD, REPORT_DELIVERY_CHANNEL_FIELD, DEPLOYMENT_STATUS_FIELD, CREATION_TIME_FIELD, LAST_ATTEMPTED_EXECUTION_TIME_FIELD, LAST_SUCCESSFUL_EXECUTION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReportPlan.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String reportPlanArn;
    private final String reportPlanName;
    private final String reportPlanDescription;
    private final ReportSetting reportSetting;
    private final ReportDeliveryChannel reportDeliveryChannel;
    private final String deploymentStatus;
    private final Instant creationTime;
    private final Instant lastAttemptedExecutionTime;
    private final Instant lastSuccessfulExecutionTime;

    private ReportPlan(BuilderImpl builder) {
        this.reportPlanArn = builder.reportPlanArn;
        this.reportPlanName = builder.reportPlanName;
        this.reportPlanDescription = builder.reportPlanDescription;
        this.reportSetting = builder.reportSetting;
        this.reportDeliveryChannel = builder.reportDeliveryChannel;
        this.deploymentStatus = builder.deploymentStatus;
        this.creationTime = builder.creationTime;
        this.lastAttemptedExecutionTime = builder.lastAttemptedExecutionTime;
        this.lastSuccessfulExecutionTime = builder.lastSuccessfulExecutionTime;
    }

    public final String reportPlanArn() {
        return this.reportPlanArn;
    }

    public final String reportPlanName() {
        return this.reportPlanName;
    }

    public final String reportPlanDescription() {
        return this.reportPlanDescription;
    }

    public final ReportSetting reportSetting() {
        return this.reportSetting;
    }

    public final ReportDeliveryChannel reportDeliveryChannel() {
        return this.reportDeliveryChannel;
    }

    public final String deploymentStatus() {
        return this.deploymentStatus;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastAttemptedExecutionTime() {
        return this.lastAttemptedExecutionTime;
    }

    public final Instant lastSuccessfulExecutionTime() {
        return this.lastSuccessfulExecutionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reportPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportPlanDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportDeliveryChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAttemptedExecutionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulExecutionTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportPlan)) {
            return false;
        }
        ReportPlan other = (ReportPlan)obj;
        return Objects.equals(this.reportPlanArn(), other.reportPlanArn()) && Objects.equals(this.reportPlanName(), other.reportPlanName()) && Objects.equals(this.reportPlanDescription(), other.reportPlanDescription()) && Objects.equals(this.reportSetting(), other.reportSetting()) && Objects.equals(this.reportDeliveryChannel(), other.reportDeliveryChannel()) && Objects.equals(this.deploymentStatus(), other.deploymentStatus()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastAttemptedExecutionTime(), other.lastAttemptedExecutionTime()) && Objects.equals(this.lastSuccessfulExecutionTime(), other.lastSuccessfulExecutionTime());
    }

    public final String toString() {
        return ToString.builder((String)"ReportPlan").add("ReportPlanArn", (Object)this.reportPlanArn()).add("ReportPlanName", (Object)this.reportPlanName()).add("ReportPlanDescription", (Object)this.reportPlanDescription()).add("ReportSetting", (Object)this.reportSetting()).add("ReportDeliveryChannel", (Object)this.reportDeliveryChannel()).add("DeploymentStatus", (Object)this.deploymentStatus()).add("CreationTime", (Object)this.creationTime()).add("LastAttemptedExecutionTime", (Object)this.lastAttemptedExecutionTime()).add("LastSuccessfulExecutionTime", (Object)this.lastSuccessfulExecutionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportPlanArn": {
                return Optional.ofNullable(clazz.cast(this.reportPlanArn()));
            }
            case "ReportPlanName": {
                return Optional.ofNullable(clazz.cast(this.reportPlanName()));
            }
            case "ReportPlanDescription": {
                return Optional.ofNullable(clazz.cast(this.reportPlanDescription()));
            }
            case "ReportSetting": {
                return Optional.ofNullable(clazz.cast(this.reportSetting()));
            }
            case "ReportDeliveryChannel": {
                return Optional.ofNullable(clazz.cast(this.reportDeliveryChannel()));
            }
            case "DeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatus()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastAttemptedExecutionTime": {
                return Optional.ofNullable(clazz.cast(this.lastAttemptedExecutionTime()));
            }
            case "LastSuccessfulExecutionTime": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulExecutionTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReportPlanArn", REPORT_PLAN_ARN_FIELD);
        map.put("ReportPlanName", REPORT_PLAN_NAME_FIELD);
        map.put("ReportPlanDescription", REPORT_PLAN_DESCRIPTION_FIELD);
        map.put("ReportSetting", REPORT_SETTING_FIELD);
        map.put("ReportDeliveryChannel", REPORT_DELIVERY_CHANNEL_FIELD);
        map.put("DeploymentStatus", DEPLOYMENT_STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastAttemptedExecutionTime", LAST_ATTEMPTED_EXECUTION_TIME_FIELD);
        map.put("LastSuccessfulExecutionTime", LAST_SUCCESSFUL_EXECUTION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReportPlan, T> g) {
        return obj -> g.apply((ReportPlan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reportPlanArn;
        private String reportPlanName;
        private String reportPlanDescription;
        private ReportSetting reportSetting;
        private ReportDeliveryChannel reportDeliveryChannel;
        private String deploymentStatus;
        private Instant creationTime;
        private Instant lastAttemptedExecutionTime;
        private Instant lastSuccessfulExecutionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportPlan model) {
            this.reportPlanArn(model.reportPlanArn);
            this.reportPlanName(model.reportPlanName);
            this.reportPlanDescription(model.reportPlanDescription);
            this.reportSetting(model.reportSetting);
            this.reportDeliveryChannel(model.reportDeliveryChannel);
            this.deploymentStatus(model.deploymentStatus);
            this.creationTime(model.creationTime);
            this.lastAttemptedExecutionTime(model.lastAttemptedExecutionTime);
            this.lastSuccessfulExecutionTime(model.lastSuccessfulExecutionTime);
        }

        public final String getReportPlanArn() {
            return this.reportPlanArn;
        }

        public final void setReportPlanArn(String reportPlanArn) {
            this.reportPlanArn = reportPlanArn;
        }

        @Override
        public final Builder reportPlanArn(String reportPlanArn) {
            this.reportPlanArn = reportPlanArn;
            return this;
        }

        public final String getReportPlanName() {
            return this.reportPlanName;
        }

        public final void setReportPlanName(String reportPlanName) {
            this.reportPlanName = reportPlanName;
        }

        @Override
        public final Builder reportPlanName(String reportPlanName) {
            this.reportPlanName = reportPlanName;
            return this;
        }

        public final String getReportPlanDescription() {
            return this.reportPlanDescription;
        }

        public final void setReportPlanDescription(String reportPlanDescription) {
            this.reportPlanDescription = reportPlanDescription;
        }

        @Override
        public final Builder reportPlanDescription(String reportPlanDescription) {
            this.reportPlanDescription = reportPlanDescription;
            return this;
        }

        public final ReportSetting.Builder getReportSetting() {
            return this.reportSetting != null ? this.reportSetting.toBuilder() : null;
        }

        public final void setReportSetting(ReportSetting.BuilderImpl reportSetting) {
            this.reportSetting = reportSetting != null ? reportSetting.build() : null;
        }

        @Override
        public final Builder reportSetting(ReportSetting reportSetting) {
            this.reportSetting = reportSetting;
            return this;
        }

        public final ReportDeliveryChannel.Builder getReportDeliveryChannel() {
            return this.reportDeliveryChannel != null ? this.reportDeliveryChannel.toBuilder() : null;
        }

        public final void setReportDeliveryChannel(ReportDeliveryChannel.BuilderImpl reportDeliveryChannel) {
            this.reportDeliveryChannel = reportDeliveryChannel != null ? reportDeliveryChannel.build() : null;
        }

        @Override
        public final Builder reportDeliveryChannel(ReportDeliveryChannel reportDeliveryChannel) {
            this.reportDeliveryChannel = reportDeliveryChannel;
            return this;
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastAttemptedExecutionTime() {
            return this.lastAttemptedExecutionTime;
        }

        public final void setLastAttemptedExecutionTime(Instant lastAttemptedExecutionTime) {
            this.lastAttemptedExecutionTime = lastAttemptedExecutionTime;
        }

        @Override
        public final Builder lastAttemptedExecutionTime(Instant lastAttemptedExecutionTime) {
            this.lastAttemptedExecutionTime = lastAttemptedExecutionTime;
            return this;
        }

        public final Instant getLastSuccessfulExecutionTime() {
            return this.lastSuccessfulExecutionTime;
        }

        public final void setLastSuccessfulExecutionTime(Instant lastSuccessfulExecutionTime) {
            this.lastSuccessfulExecutionTime = lastSuccessfulExecutionTime;
        }

        @Override
        public final Builder lastSuccessfulExecutionTime(Instant lastSuccessfulExecutionTime) {
            this.lastSuccessfulExecutionTime = lastSuccessfulExecutionTime;
            return this;
        }

        public ReportPlan build() {
            return new ReportPlan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportPlan> {
        public Builder reportPlanArn(String var1);

        public Builder reportPlanName(String var1);

        public Builder reportPlanDescription(String var1);

        public Builder reportSetting(ReportSetting var1);

        default public Builder reportSetting(Consumer<ReportSetting.Builder> reportSetting) {
            return this.reportSetting((ReportSetting)((ReportSetting.Builder)ReportSetting.builder().applyMutation(reportSetting)).build());
        }

        public Builder reportDeliveryChannel(ReportDeliveryChannel var1);

        default public Builder reportDeliveryChannel(Consumer<ReportDeliveryChannel.Builder> reportDeliveryChannel) {
            return this.reportDeliveryChannel((ReportDeliveryChannel)((ReportDeliveryChannel.Builder)ReportDeliveryChannel.builder().applyMutation(reportDeliveryChannel)).build());
        }

        public Builder deploymentStatus(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastAttemptedExecutionTime(Instant var1);

        public Builder lastSuccessfulExecutionTime(Instant var1);
    }
}

