/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AggregationPeriod {
    ONE_DAY("ONE_DAY"),
    SEVEN_DAYS("SEVEN_DAYS"),
    FOURTEEN_DAYS("FOURTEEN_DAYS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AggregationPeriod> VALUE_MAP;
    private final String value;

    private AggregationPeriod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AggregationPeriod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AggregationPeriod> knownValues() {
        EnumSet<AggregationPeriod> knownValues = EnumSet.allOf(AggregationPeriod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AggregationPeriod.class, AggregationPeriod::toString);
    }
}

