/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.RecoveryPointByBackupVault;

public class ListRecoveryPointsByBackupVaultPublisher
implements SdkPublisher<ListRecoveryPointsByBackupVaultResponse> {
    private final BackupAsyncClient client;
    private final ListRecoveryPointsByBackupVaultRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecoveryPointsByBackupVaultPublisher(BackupAsyncClient client, ListRecoveryPointsByBackupVaultRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecoveryPointsByBackupVaultPublisher(BackupAsyncClient client, ListRecoveryPointsByBackupVaultRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecoveryPointsByBackupVaultResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecoveryPointsByBackupVaultResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecoveryPointByBackupVault> recoveryPoints() {
        return this.flatMapIterable(response -> response.recoveryPoints());
    }

    private class ListRecoveryPointsByBackupVaultResponseFetcher
    implements AsyncPageFetcher<ListRecoveryPointsByBackupVaultResponse> {
        private ListRecoveryPointsByBackupVaultResponseFetcher() {
        }

        public boolean hasNextPage(ListRecoveryPointsByBackupVaultResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecoveryPointsByBackupVaultResponse> nextPage(ListRecoveryPointsByBackupVaultResponse previousPage) {
            if (previousPage == null) {
                return ListRecoveryPointsByBackupVaultPublisher.this.client.listRecoveryPointsByBackupVault(ListRecoveryPointsByBackupVaultPublisher.this.firstRequest);
            }
            return ListRecoveryPointsByBackupVaultPublisher.this.client.listRecoveryPointsByBackupVault((ListRecoveryPointsByBackupVaultRequest)((Object)ListRecoveryPointsByBackupVaultPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

