/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRestoreTestingPlanRequest extends BackupRequest implements
        ToCopyableBuilder<UpdateRestoreTestingPlanRequest.Builder, UpdateRestoreTestingPlanRequest> {
    private static final SdkField<RestoreTestingPlanForUpdate> RESTORE_TESTING_PLAN_FIELD = SdkField
            .<RestoreTestingPlanForUpdate> builder(MarshallingType.SDK_POJO).memberName("RestoreTestingPlan")
            .getter(getter(UpdateRestoreTestingPlanRequest::restoreTestingPlan)).setter(setter(Builder::restoreTestingPlan))
            .constructor(RestoreTestingPlanForUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlan").build())
            .build();

    private static final SdkField<String> RESTORE_TESTING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanName").getter(getter(UpdateRestoreTestingPlanRequest::restoreTestingPlanName))
            .setter(setter(Builder::restoreTestingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("RestoreTestingPlanName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTORE_TESTING_PLAN_FIELD,
            RESTORE_TESTING_PLAN_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RestoreTestingPlanForUpdate restoreTestingPlan;

    private final String restoreTestingPlanName;

    private UpdateRestoreTestingPlanRequest(BuilderImpl builder) {
        super(builder);
        this.restoreTestingPlan = builder.restoreTestingPlan;
        this.restoreTestingPlanName = builder.restoreTestingPlanName;
    }

    /**
     * <p>
     * Specifies the body of a restore testing plan.
     * </p>
     * 
     * @return Specifies the body of a restore testing plan.
     */
    public final RestoreTestingPlanForUpdate restoreTestingPlan() {
        return restoreTestingPlan;
    }

    /**
     * <p>
     * The name of the restore testing plan name.
     * </p>
     * 
     * @return The name of the restore testing plan name.
     */
    public final String restoreTestingPlanName() {
        return restoreTestingPlanName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlan());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRestoreTestingPlanRequest)) {
            return false;
        }
        UpdateRestoreTestingPlanRequest other = (UpdateRestoreTestingPlanRequest) obj;
        return Objects.equals(restoreTestingPlan(), other.restoreTestingPlan())
                && Objects.equals(restoreTestingPlanName(), other.restoreTestingPlanName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRestoreTestingPlanRequest").add("RestoreTestingPlan", restoreTestingPlan())
                .add("RestoreTestingPlanName", restoreTestingPlanName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RestoreTestingPlan":
            return Optional.ofNullable(clazz.cast(restoreTestingPlan()));
        case "RestoreTestingPlanName":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RestoreTestingPlan", RESTORE_TESTING_PLAN_FIELD);
        map.put("RestoreTestingPlanName", RESTORE_TESTING_PLAN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRestoreTestingPlanRequest, T> g) {
        return obj -> g.apply((UpdateRestoreTestingPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRestoreTestingPlanRequest> {
        /**
         * <p>
         * Specifies the body of a restore testing plan.
         * </p>
         * 
         * @param restoreTestingPlan
         *        Specifies the body of a restore testing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlan(RestoreTestingPlanForUpdate restoreTestingPlan);

        /**
         * <p>
         * Specifies the body of a restore testing plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link RestoreTestingPlanForUpdate.Builder}
         * avoiding the need to create one manually via {@link RestoreTestingPlanForUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RestoreTestingPlanForUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #restoreTestingPlan(RestoreTestingPlanForUpdate)}.
         * 
         * @param restoreTestingPlan
         *        a consumer that will call methods on {@link RestoreTestingPlanForUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreTestingPlan(RestoreTestingPlanForUpdate)
         */
        default Builder restoreTestingPlan(Consumer<RestoreTestingPlanForUpdate.Builder> restoreTestingPlan) {
            return restoreTestingPlan(RestoreTestingPlanForUpdate.builder().applyMutation(restoreTestingPlan).build());
        }

        /**
         * <p>
         * The name of the restore testing plan name.
         * </p>
         * 
         * @param restoreTestingPlanName
         *        The name of the restore testing plan name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanName(String restoreTestingPlanName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private RestoreTestingPlanForUpdate restoreTestingPlan;

        private String restoreTestingPlanName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRestoreTestingPlanRequest model) {
            super(model);
            restoreTestingPlan(model.restoreTestingPlan);
            restoreTestingPlanName(model.restoreTestingPlanName);
        }

        public final RestoreTestingPlanForUpdate.Builder getRestoreTestingPlan() {
            return restoreTestingPlan != null ? restoreTestingPlan.toBuilder() : null;
        }

        public final void setRestoreTestingPlan(RestoreTestingPlanForUpdate.BuilderImpl restoreTestingPlan) {
            this.restoreTestingPlan = restoreTestingPlan != null ? restoreTestingPlan.build() : null;
        }

        @Override
        public final Builder restoreTestingPlan(RestoreTestingPlanForUpdate restoreTestingPlan) {
            this.restoreTestingPlan = restoreTestingPlan;
            return this;
        }

        public final String getRestoreTestingPlanName() {
            return restoreTestingPlanName;
        }

        public final void setRestoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
        }

        @Override
        public final Builder restoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRestoreTestingPlanRequest build() {
            return new UpdateRestoreTestingPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
