/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTieringConfigurationResponse extends BackupResponse implements
        ToCopyableBuilder<GetTieringConfigurationResponse.Builder, GetTieringConfigurationResponse> {
    private static final SdkField<TieringConfiguration> TIERING_CONFIGURATION_FIELD = SdkField
            .<TieringConfiguration> builder(MarshallingType.SDK_POJO).memberName("TieringConfiguration")
            .getter(getter(GetTieringConfigurationResponse::tieringConfiguration)).setter(setter(Builder::tieringConfiguration))
            .constructor(TieringConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIERING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TieringConfiguration tieringConfiguration;

    private GetTieringConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.tieringConfiguration = builder.tieringConfiguration;
    }

    /**
     * <p>
     * Specifies the body of a tiering configuration. Includes <code>TieringConfigurationName</code>.
     * </p>
     * 
     * @return Specifies the body of a tiering configuration. Includes <code>TieringConfigurationName</code>.
     */
    public final TieringConfiguration tieringConfiguration() {
        return tieringConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tieringConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTieringConfigurationResponse)) {
            return false;
        }
        GetTieringConfigurationResponse other = (GetTieringConfigurationResponse) obj;
        return Objects.equals(tieringConfiguration(), other.tieringConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTieringConfigurationResponse").add("TieringConfiguration", tieringConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TieringConfiguration":
            return Optional.ofNullable(clazz.cast(tieringConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TieringConfiguration", TIERING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTieringConfigurationResponse, T> g) {
        return obj -> g.apply((GetTieringConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTieringConfigurationResponse> {
        /**
         * <p>
         * Specifies the body of a tiering configuration. Includes <code>TieringConfigurationName</code>.
         * </p>
         * 
         * @param tieringConfiguration
         *        Specifies the body of a tiering configuration. Includes <code>TieringConfigurationName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieringConfiguration(TieringConfiguration tieringConfiguration);

        /**
         * <p>
         * Specifies the body of a tiering configuration. Includes <code>TieringConfigurationName</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TieringConfiguration.Builder} avoiding
         * the need to create one manually via {@link TieringConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TieringConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #tieringConfiguration(TieringConfiguration)}.
         * 
         * @param tieringConfiguration
         *        a consumer that will call methods on {@link TieringConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tieringConfiguration(TieringConfiguration)
         */
        default Builder tieringConfiguration(Consumer<TieringConfiguration.Builder> tieringConfiguration) {
            return tieringConfiguration(TieringConfiguration.builder().applyMutation(tieringConfiguration).build());
        }
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private TieringConfiguration tieringConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTieringConfigurationResponse model) {
            super(model);
            tieringConfiguration(model.tieringConfiguration);
        }

        public final TieringConfiguration.Builder getTieringConfiguration() {
            return tieringConfiguration != null ? tieringConfiguration.toBuilder() : null;
        }

        public final void setTieringConfiguration(TieringConfiguration.BuilderImpl tieringConfiguration) {
            this.tieringConfiguration = tieringConfiguration != null ? tieringConfiguration.build() : null;
        }

        @Override
        public final Builder tieringConfiguration(TieringConfiguration tieringConfiguration) {
            this.tieringConfiguration = tieringConfiguration;
            return this;
        }

        @Override
        public GetTieringConfigurationResponse build() {
            return new GetTieringConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
