/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListScanJobsRequest;
import software.amazon.awssdk.services.backup.model.ListScanJobsResponse;
import software.amazon.awssdk.services.backup.model.ScanJob;

public class ListScanJobsPublisher
implements SdkPublisher<ListScanJobsResponse> {
    private final BackupAsyncClient client;
    private final ListScanJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListScanJobsPublisher(BackupAsyncClient client, ListScanJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListScanJobsPublisher(BackupAsyncClient client, ListScanJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListScanJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListScanJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScanJob> scanJobs() {
        Function<ListScanJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scanJobs() != null) {
                return response.scanJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListScanJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListScanJobsResponseFetcher
    implements AsyncPageFetcher<ListScanJobsResponse> {
        private ListScanJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListScanJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListScanJobsResponse> nextPage(ListScanJobsResponse previousPage) {
            if (previousPage == null) {
                return ListScanJobsPublisher.this.client.listScanJobs(ListScanJobsPublisher.this.firstRequest);
            }
            return ListScanJobsPublisher.this.client.listScanJobs((ListScanJobsRequest)((Object)ListScanJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

