/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.ScanJobSummary;
import software.amazon.awssdk.services.backup.model.ScanJobSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListScanJobSummariesResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListScanJobSummariesResponse> {
    private static final SdkField<List<ScanJobSummary>> SCAN_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScanJobSummaries").getter(ListScanJobSummariesResponse.getter(ListScanJobSummariesResponse::scanJobSummaries)).setter(ListScanJobSummariesResponse.setter(Builder::scanJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScanJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AGGREGATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggregationPeriod").getter(ListScanJobSummariesResponse.getter(ListScanJobSummariesResponse::aggregationPeriod)).setter(ListScanJobSummariesResponse.setter(Builder::aggregationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationPeriod").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListScanJobSummariesResponse.getter(ListScanJobSummariesResponse::nextToken)).setter(ListScanJobSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_JOB_SUMMARIES_FIELD, AGGREGATION_PERIOD_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListScanJobSummariesResponse.memberNameToFieldInitializer();
    private final List<ScanJobSummary> scanJobSummaries;
    private final String aggregationPeriod;
    private final String nextToken;

    private ListScanJobSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.scanJobSummaries = builder.scanJobSummaries;
        this.aggregationPeriod = builder.aggregationPeriod;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScanJobSummaries() {
        return this.scanJobSummaries != null && !(this.scanJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<ScanJobSummary> scanJobSummaries() {
        return this.scanJobSummaries;
    }

    public final String aggregationPeriod() {
        return this.aggregationPeriod;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScanJobSummaries() ? this.scanJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScanJobSummariesResponse)) {
            return false;
        }
        ListScanJobSummariesResponse other = (ListScanJobSummariesResponse)((Object)obj);
        return this.hasScanJobSummaries() == other.hasScanJobSummaries() && Objects.equals(this.scanJobSummaries(), other.scanJobSummaries()) && Objects.equals(this.aggregationPeriod(), other.aggregationPeriod()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListScanJobSummariesResponse").add("ScanJobSummaries", this.hasScanJobSummaries() ? this.scanJobSummaries() : null).add("AggregationPeriod", (Object)this.aggregationPeriod()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScanJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.scanJobSummaries()));
            }
            case "AggregationPeriod": {
                return Optional.ofNullable(clazz.cast(this.aggregationPeriod()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScanJobSummaries", SCAN_JOB_SUMMARIES_FIELD);
        map.put("AggregationPeriod", AGGREGATION_PERIOD_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListScanJobSummariesResponse, T> g) {
        return obj -> g.apply((ListScanJobSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private List<ScanJobSummary> scanJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String aggregationPeriod;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScanJobSummariesResponse model) {
            super(model);
            this.scanJobSummaries(model.scanJobSummaries);
            this.aggregationPeriod(model.aggregationPeriod);
            this.nextToken(model.nextToken);
        }

        public final List<ScanJobSummary.Builder> getScanJobSummaries() {
            List<ScanJobSummary.Builder> result = ScanJobSummaryListCopier.copyToBuilder(this.scanJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanJobSummaries(Collection<ScanJobSummary.BuilderImpl> scanJobSummaries) {
            this.scanJobSummaries = ScanJobSummaryListCopier.copyFromBuilder(scanJobSummaries);
        }

        @Override
        public final Builder scanJobSummaries(Collection<ScanJobSummary> scanJobSummaries) {
            this.scanJobSummaries = ScanJobSummaryListCopier.copy(scanJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanJobSummaries(ScanJobSummary ... scanJobSummaries) {
            this.scanJobSummaries(Arrays.asList(scanJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanJobSummaries(Consumer<ScanJobSummary.Builder> ... scanJobSummaries) {
            this.scanJobSummaries(Stream.of(scanJobSummaries).map(c -> (ScanJobSummary)((ScanJobSummary.Builder)ScanJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAggregationPeriod() {
            return this.aggregationPeriod;
        }

        public final void setAggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
        }

        @Override
        public final Builder aggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListScanJobSummariesResponse build() {
            return new ListScanJobSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListScanJobSummariesResponse> {
        public Builder scanJobSummaries(Collection<ScanJobSummary> var1);

        public Builder scanJobSummaries(ScanJobSummary ... var1);

        public Builder scanJobSummaries(Consumer<ScanJobSummary.Builder> ... var1);

        public Builder aggregationPeriod(String var1);

        public Builder nextToken(String var1);
    }
}

