/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.EncryptionKeyType;
import software.amazon.awssdk.services.backup.model.VaultState;
import software.amazon.awssdk.services.backup.model.VaultType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackupVaultListMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackupVaultListMember> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(BackupVaultListMember.getter(BackupVaultListMember::backupVaultName)).setter(BackupVaultListMember.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultArn").getter(BackupVaultListMember.getter(BackupVaultListMember::backupVaultArn)).setter(BackupVaultListMember.setter(Builder::backupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()}).build();
    private static final SdkField<String> VAULT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VaultType").getter(BackupVaultListMember.getter(BackupVaultListMember::vaultTypeAsString)).setter(BackupVaultListMember.setter(Builder::vaultType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultType").build()}).build();
    private static final SdkField<String> VAULT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VaultState").getter(BackupVaultListMember.getter(BackupVaultListMember::vaultStateAsString)).setter(BackupVaultListMember.setter(Builder::vaultState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultState").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(BackupVaultListMember.getter(BackupVaultListMember::creationDate)).setter(BackupVaultListMember.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyArn").getter(BackupVaultListMember.getter(BackupVaultListMember::encryptionKeyArn)).setter(BackupVaultListMember.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(BackupVaultListMember.getter(BackupVaultListMember::creatorRequestId)).setter(BackupVaultListMember.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<Long> NUMBER_OF_RECOVERY_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfRecoveryPoints").getter(BackupVaultListMember.getter(BackupVaultListMember::numberOfRecoveryPoints)).setter(BackupVaultListMember.setter(Builder::numberOfRecoveryPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfRecoveryPoints").build()}).build();
    private static final SdkField<Boolean> LOCKED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Locked").getter(BackupVaultListMember.getter(BackupVaultListMember::locked)).setter(BackupVaultListMember.setter(Builder::locked)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locked").build()}).build();
    private static final SdkField<Long> MIN_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MinRetentionDays").getter(BackupVaultListMember.getter(BackupVaultListMember::minRetentionDays)).setter(BackupVaultListMember.setter(Builder::minRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinRetentionDays").build()}).build();
    private static final SdkField<Long> MAX_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxRetentionDays").getter(BackupVaultListMember.getter(BackupVaultListMember::maxRetentionDays)).setter(BackupVaultListMember.setter(Builder::maxRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetentionDays").build()}).build();
    private static final SdkField<Instant> LOCK_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LockDate").getter(BackupVaultListMember.getter(BackupVaultListMember::lockDate)).setter(BackupVaultListMember.setter(Builder::lockDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockDate").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyType").getter(BackupVaultListMember.getter(BackupVaultListMember::encryptionKeyTypeAsString)).setter(BackupVaultListMember.setter(Builder::encryptionKeyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD, BACKUP_VAULT_ARN_FIELD, VAULT_TYPE_FIELD, VAULT_STATE_FIELD, CREATION_DATE_FIELD, ENCRYPTION_KEY_ARN_FIELD, CREATOR_REQUEST_ID_FIELD, NUMBER_OF_RECOVERY_POINTS_FIELD, LOCKED_FIELD, MIN_RETENTION_DAYS_FIELD, MAX_RETENTION_DAYS_FIELD, LOCK_DATE_FIELD, ENCRYPTION_KEY_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BackupVaultListMember.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String backupVaultName;
    private final String backupVaultArn;
    private final String vaultType;
    private final String vaultState;
    private final Instant creationDate;
    private final String encryptionKeyArn;
    private final String creatorRequestId;
    private final Long numberOfRecoveryPoints;
    private final Boolean locked;
    private final Long minRetentionDays;
    private final Long maxRetentionDays;
    private final Instant lockDate;
    private final String encryptionKeyType;

    private BackupVaultListMember(BuilderImpl builder) {
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultArn = builder.backupVaultArn;
        this.vaultType = builder.vaultType;
        this.vaultState = builder.vaultState;
        this.creationDate = builder.creationDate;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.creatorRequestId = builder.creatorRequestId;
        this.numberOfRecoveryPoints = builder.numberOfRecoveryPoints;
        this.locked = builder.locked;
        this.minRetentionDays = builder.minRetentionDays;
        this.maxRetentionDays = builder.maxRetentionDays;
        this.lockDate = builder.lockDate;
        this.encryptionKeyType = builder.encryptionKeyType;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public final String backupVaultArn() {
        return this.backupVaultArn;
    }

    public final VaultType vaultType() {
        return VaultType.fromValue(this.vaultType);
    }

    public final String vaultTypeAsString() {
        return this.vaultType;
    }

    public final VaultState vaultState() {
        return VaultState.fromValue(this.vaultState);
    }

    public final String vaultStateAsString() {
        return this.vaultState;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final Long numberOfRecoveryPoints() {
        return this.numberOfRecoveryPoints;
    }

    public final Boolean locked() {
        return this.locked;
    }

    public final Long minRetentionDays() {
        return this.minRetentionDays;
    }

    public final Long maxRetentionDays() {
        return this.maxRetentionDays;
    }

    public final Instant lockDate() {
        return this.lockDate;
    }

    public final EncryptionKeyType encryptionKeyType() {
        return EncryptionKeyType.fromValue(this.encryptionKeyType);
    }

    public final String encryptionKeyTypeAsString() {
        return this.encryptionKeyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRecoveryPoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.locked());
        hashCode = 31 * hashCode + Objects.hashCode(this.minRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupVaultListMember)) {
            return false;
        }
        BackupVaultListMember other = (BackupVaultListMember)obj;
        return Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.backupVaultArn(), other.backupVaultArn()) && Objects.equals(this.vaultTypeAsString(), other.vaultTypeAsString()) && Objects.equals(this.vaultStateAsString(), other.vaultStateAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.numberOfRecoveryPoints(), other.numberOfRecoveryPoints()) && Objects.equals(this.locked(), other.locked()) && Objects.equals(this.minRetentionDays(), other.minRetentionDays()) && Objects.equals(this.maxRetentionDays(), other.maxRetentionDays()) && Objects.equals(this.lockDate(), other.lockDate()) && Objects.equals(this.encryptionKeyTypeAsString(), other.encryptionKeyTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BackupVaultListMember").add("BackupVaultName", (Object)this.backupVaultName()).add("BackupVaultArn", (Object)this.backupVaultArn()).add("VaultType", (Object)this.vaultTypeAsString()).add("VaultState", (Object)this.vaultStateAsString()).add("CreationDate", (Object)this.creationDate()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("NumberOfRecoveryPoints", (Object)this.numberOfRecoveryPoints()).add("Locked", (Object)this.locked()).add("MinRetentionDays", (Object)this.minRetentionDays()).add("MaxRetentionDays", (Object)this.maxRetentionDays()).add("LockDate", (Object)this.lockDate()).add("EncryptionKeyType", (Object)this.encryptionKeyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "BackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.backupVaultArn()));
            }
            case "VaultType": {
                return Optional.ofNullable(clazz.cast(this.vaultTypeAsString()));
            }
            case "VaultState": {
                return Optional.ofNullable(clazz.cast(this.vaultStateAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "NumberOfRecoveryPoints": {
                return Optional.ofNullable(clazz.cast(this.numberOfRecoveryPoints()));
            }
            case "Locked": {
                return Optional.ofNullable(clazz.cast(this.locked()));
            }
            case "MinRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.minRetentionDays()));
            }
            case "MaxRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.maxRetentionDays()));
            }
            case "LockDate": {
                return Optional.ofNullable(clazz.cast(this.lockDate()));
            }
            case "EncryptionKeyType": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("BackupVaultArn", BACKUP_VAULT_ARN_FIELD);
        map.put("VaultType", VAULT_TYPE_FIELD);
        map.put("VaultState", VAULT_STATE_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        map.put("NumberOfRecoveryPoints", NUMBER_OF_RECOVERY_POINTS_FIELD);
        map.put("Locked", LOCKED_FIELD);
        map.put("MinRetentionDays", MIN_RETENTION_DAYS_FIELD);
        map.put("MaxRetentionDays", MAX_RETENTION_DAYS_FIELD);
        map.put("LockDate", LOCK_DATE_FIELD);
        map.put("EncryptionKeyType", ENCRYPTION_KEY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BackupVaultListMember, T> g) {
        return obj -> g.apply((BackupVaultListMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupVaultName;
        private String backupVaultArn;
        private String vaultType;
        private String vaultState;
        private Instant creationDate;
        private String encryptionKeyArn;
        private String creatorRequestId;
        private Long numberOfRecoveryPoints;
        private Boolean locked;
        private Long minRetentionDays;
        private Long maxRetentionDays;
        private Instant lockDate;
        private String encryptionKeyType;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupVaultListMember model) {
            this.backupVaultName(model.backupVaultName);
            this.backupVaultArn(model.backupVaultArn);
            this.vaultType(model.vaultType);
            this.vaultState(model.vaultState);
            this.creationDate(model.creationDate);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.creatorRequestId(model.creatorRequestId);
            this.numberOfRecoveryPoints(model.numberOfRecoveryPoints);
            this.locked(model.locked);
            this.minRetentionDays(model.minRetentionDays);
            this.maxRetentionDays(model.maxRetentionDays);
            this.lockDate(model.lockDate);
            this.encryptionKeyType(model.encryptionKeyType);
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getBackupVaultArn() {
            return this.backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final String getVaultType() {
            return this.vaultType;
        }

        public final void setVaultType(String vaultType) {
            this.vaultType = vaultType;
        }

        @Override
        public final Builder vaultType(String vaultType) {
            this.vaultType = vaultType;
            return this;
        }

        @Override
        public final Builder vaultType(VaultType vaultType) {
            this.vaultType(vaultType == null ? null : vaultType.toString());
            return this;
        }

        public final String getVaultState() {
            return this.vaultState;
        }

        public final void setVaultState(String vaultState) {
            this.vaultState = vaultState;
        }

        @Override
        public final Builder vaultState(String vaultState) {
            this.vaultState = vaultState;
            return this;
        }

        @Override
        public final Builder vaultState(VaultState vaultState) {
            this.vaultState(vaultState == null ? null : vaultState.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final Long getNumberOfRecoveryPoints() {
            return this.numberOfRecoveryPoints;
        }

        public final void setNumberOfRecoveryPoints(Long numberOfRecoveryPoints) {
            this.numberOfRecoveryPoints = numberOfRecoveryPoints;
        }

        @Override
        public final Builder numberOfRecoveryPoints(Long numberOfRecoveryPoints) {
            this.numberOfRecoveryPoints = numberOfRecoveryPoints;
            return this;
        }

        public final Boolean getLocked() {
            return this.locked;
        }

        public final void setLocked(Boolean locked) {
            this.locked = locked;
        }

        @Override
        public final Builder locked(Boolean locked) {
            this.locked = locked;
            return this;
        }

        public final Long getMinRetentionDays() {
            return this.minRetentionDays;
        }

        public final void setMinRetentionDays(Long minRetentionDays) {
            this.minRetentionDays = minRetentionDays;
        }

        @Override
        public final Builder minRetentionDays(Long minRetentionDays) {
            this.minRetentionDays = minRetentionDays;
            return this;
        }

        public final Long getMaxRetentionDays() {
            return this.maxRetentionDays;
        }

        public final void setMaxRetentionDays(Long maxRetentionDays) {
            this.maxRetentionDays = maxRetentionDays;
        }

        @Override
        public final Builder maxRetentionDays(Long maxRetentionDays) {
            this.maxRetentionDays = maxRetentionDays;
            return this;
        }

        public final Instant getLockDate() {
            return this.lockDate;
        }

        public final void setLockDate(Instant lockDate) {
            this.lockDate = lockDate;
        }

        @Override
        public final Builder lockDate(Instant lockDate) {
            this.lockDate = lockDate;
            return this;
        }

        public final String getEncryptionKeyType() {
            return this.encryptionKeyType;
        }

        public final void setEncryptionKeyType(String encryptionKeyType) {
            this.encryptionKeyType = encryptionKeyType;
        }

        @Override
        public final Builder encryptionKeyType(String encryptionKeyType) {
            this.encryptionKeyType = encryptionKeyType;
            return this;
        }

        @Override
        public final Builder encryptionKeyType(EncryptionKeyType encryptionKeyType) {
            this.encryptionKeyType(encryptionKeyType == null ? null : encryptionKeyType.toString());
            return this;
        }

        public BackupVaultListMember build() {
            return new BackupVaultListMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackupVaultListMember> {
        public Builder backupVaultName(String var1);

        public Builder backupVaultArn(String var1);

        public Builder vaultType(String var1);

        public Builder vaultType(VaultType var1);

        public Builder vaultState(String var1);

        public Builder vaultState(VaultState var1);

        public Builder creationDate(Instant var1);

        public Builder encryptionKeyArn(String var1);

        public Builder creatorRequestId(String var1);

        public Builder numberOfRecoveryPoints(Long var1);

        public Builder locked(Boolean var1);

        public Builder minRetentionDays(Long var1);

        public Builder maxRetentionDays(Long var1);

        public Builder lockDate(Instant var1);

        public Builder encryptionKeyType(String var1);

        public Builder encryptionKeyType(EncryptionKeyType var1);
    }
}

