/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTieringConfigurationRequest extends BackupRequest implements
        ToCopyableBuilder<UpdateTieringConfigurationRequest.Builder, UpdateTieringConfigurationRequest> {
    private static final SdkField<String> TIERING_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TieringConfigurationName").getter(getter(UpdateTieringConfigurationRequest::tieringConfigurationName))
            .setter(setter(Builder::tieringConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("tieringConfigurationName").build())
            .build();

    private static final SdkField<TieringConfigurationInputForUpdate> TIERING_CONFIGURATION_FIELD = SdkField
            .<TieringConfigurationInputForUpdate> builder(MarshallingType.SDK_POJO).memberName("TieringConfiguration")
            .getter(getter(UpdateTieringConfigurationRequest::tieringConfiguration))
            .setter(setter(Builder::tieringConfiguration)).constructor(TieringConfigurationInputForUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TIERING_CONFIGURATION_NAME_FIELD, TIERING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String tieringConfigurationName;

    private final TieringConfigurationInputForUpdate tieringConfiguration;

    private UpdateTieringConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.tieringConfigurationName = builder.tieringConfigurationName;
        this.tieringConfiguration = builder.tieringConfiguration;
    }

    /**
     * <p>
     * The name of a tiering configuration to update.
     * </p>
     * 
     * @return The name of a tiering configuration to update.
     */
    public final String tieringConfigurationName() {
        return tieringConfigurationName;
    }

    /**
     * <p>
     * Specifies the body of a tiering configuration.
     * </p>
     * 
     * @return Specifies the body of a tiering configuration.
     */
    public final TieringConfigurationInputForUpdate tieringConfiguration() {
        return tieringConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tieringConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(tieringConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTieringConfigurationRequest)) {
            return false;
        }
        UpdateTieringConfigurationRequest other = (UpdateTieringConfigurationRequest) obj;
        return Objects.equals(tieringConfigurationName(), other.tieringConfigurationName())
                && Objects.equals(tieringConfiguration(), other.tieringConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTieringConfigurationRequest").add("TieringConfigurationName", tieringConfigurationName())
                .add("TieringConfiguration", tieringConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TieringConfigurationName":
            return Optional.ofNullable(clazz.cast(tieringConfigurationName()));
        case "TieringConfiguration":
            return Optional.ofNullable(clazz.cast(tieringConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tieringConfigurationName", TIERING_CONFIGURATION_NAME_FIELD);
        map.put("TieringConfiguration", TIERING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTieringConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateTieringConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTieringConfigurationRequest> {
        /**
         * <p>
         * The name of a tiering configuration to update.
         * </p>
         * 
         * @param tieringConfigurationName
         *        The name of a tiering configuration to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieringConfigurationName(String tieringConfigurationName);

        /**
         * <p>
         * Specifies the body of a tiering configuration.
         * </p>
         * 
         * @param tieringConfiguration
         *        Specifies the body of a tiering configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieringConfiguration(TieringConfigurationInputForUpdate tieringConfiguration);

        /**
         * <p>
         * Specifies the body of a tiering configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TieringConfigurationInputForUpdate.Builder} avoiding the need to create one manually via
         * {@link TieringConfigurationInputForUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TieringConfigurationInputForUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #tieringConfiguration(TieringConfigurationInputForUpdate)}.
         * 
         * @param tieringConfiguration
         *        a consumer that will call methods on {@link TieringConfigurationInputForUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tieringConfiguration(TieringConfigurationInputForUpdate)
         */
        default Builder tieringConfiguration(Consumer<TieringConfigurationInputForUpdate.Builder> tieringConfiguration) {
            return tieringConfiguration(TieringConfigurationInputForUpdate.builder().applyMutation(tieringConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String tieringConfigurationName;

        private TieringConfigurationInputForUpdate tieringConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTieringConfigurationRequest model) {
            super(model);
            tieringConfigurationName(model.tieringConfigurationName);
            tieringConfiguration(model.tieringConfiguration);
        }

        public final String getTieringConfigurationName() {
            return tieringConfigurationName;
        }

        public final void setTieringConfigurationName(String tieringConfigurationName) {
            this.tieringConfigurationName = tieringConfigurationName;
        }

        @Override
        public final Builder tieringConfigurationName(String tieringConfigurationName) {
            this.tieringConfigurationName = tieringConfigurationName;
            return this;
        }

        public final TieringConfigurationInputForUpdate.Builder getTieringConfiguration() {
            return tieringConfiguration != null ? tieringConfiguration.toBuilder() : null;
        }

        public final void setTieringConfiguration(TieringConfigurationInputForUpdate.BuilderImpl tieringConfiguration) {
            this.tieringConfiguration = tieringConfiguration != null ? tieringConfiguration.build() : null;
        }

        @Override
        public final Builder tieringConfiguration(TieringConfigurationInputForUpdate tieringConfiguration) {
            this.tieringConfiguration = tieringConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTieringConfigurationRequest build() {
            return new UpdateTieringConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
