/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This contains metadata about a tiering configuration for create operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TieringConfigurationInputForCreate implements SdkPojo, Serializable,
        ToCopyableBuilder<TieringConfigurationInputForCreate.Builder, TieringConfigurationInputForCreate> {
    private static final SdkField<String> TIERING_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TieringConfigurationName").getter(getter(TieringConfigurationInputForCreate::tieringConfigurationName))
            .setter(setter(Builder::tieringConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringConfigurationName").build())
            .build();

    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(TieringConfigurationInputForCreate::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()).build();

    private static final SdkField<List<ResourceSelection>> RESOURCE_SELECTION_FIELD = SdkField
            .<List<ResourceSelection>> builder(MarshallingType.LIST)
            .memberName("ResourceSelection")
            .getter(getter(TieringConfigurationInputForCreate::resourceSelection))
            .setter(setter(Builder::resourceSelection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSelection").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceSelection> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceSelection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TIERING_CONFIGURATION_NAME_FIELD, BACKUP_VAULT_NAME_FIELD, RESOURCE_SELECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tieringConfigurationName;

    private final String backupVaultName;

    private final List<ResourceSelection> resourceSelection;

    private TieringConfigurationInputForCreate(BuilderImpl builder) {
        this.tieringConfigurationName = builder.tieringConfigurationName;
        this.backupVaultName = builder.backupVaultName;
        this.resourceSelection = builder.resourceSelection;
    }

    /**
     * <p>
     * The unique name of the tiering configuration. This cannot be changed after creation, and it must consist of only
     * alphanumeric characters and underscores.
     * </p>
     * 
     * @return The unique name of the tiering configuration. This cannot be changed after creation, and it must consist
     *         of only alphanumeric characters and underscores.
     */
    public final String tieringConfigurationName() {
        return tieringConfigurationName;
    }

    /**
     * <p>
     * The name of the backup vault where the tiering configuration applies. Use <code>*</code> to apply to all backup
     * vaults.
     * </p>
     * 
     * @return The name of the backup vault where the tiering configuration applies. Use <code>*</code> to apply to all
     *         backup vaults.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceSelection property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceSelection() {
        return resourceSelection != null && !(resourceSelection instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of resource selection objects that specify which resources are included in the tiering configuration and
     * their tiering settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceSelection} method.
     * </p>
     * 
     * @return An array of resource selection objects that specify which resources are included in the tiering
     *         configuration and their tiering settings.
     */
    public final List<ResourceSelection> resourceSelection() {
        return resourceSelection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tieringConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceSelection() ? resourceSelection() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TieringConfigurationInputForCreate)) {
            return false;
        }
        TieringConfigurationInputForCreate other = (TieringConfigurationInputForCreate) obj;
        return Objects.equals(tieringConfigurationName(), other.tieringConfigurationName())
                && Objects.equals(backupVaultName(), other.backupVaultName())
                && hasResourceSelection() == other.hasResourceSelection()
                && Objects.equals(resourceSelection(), other.resourceSelection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TieringConfigurationInputForCreate").add("TieringConfigurationName", tieringConfigurationName())
                .add("BackupVaultName", backupVaultName())
                .add("ResourceSelection", hasResourceSelection() ? resourceSelection() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TieringConfigurationName":
            return Optional.ofNullable(clazz.cast(tieringConfigurationName()));
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "ResourceSelection":
            return Optional.ofNullable(clazz.cast(resourceSelection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TieringConfigurationName", TIERING_CONFIGURATION_NAME_FIELD);
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("ResourceSelection", RESOURCE_SELECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TieringConfigurationInputForCreate, T> g) {
        return obj -> g.apply((TieringConfigurationInputForCreate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TieringConfigurationInputForCreate> {
        /**
         * <p>
         * The unique name of the tiering configuration. This cannot be changed after creation, and it must consist of
         * only alphanumeric characters and underscores.
         * </p>
         * 
         * @param tieringConfigurationName
         *        The unique name of the tiering configuration. This cannot be changed after creation, and it must
         *        consist of only alphanumeric characters and underscores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieringConfigurationName(String tieringConfigurationName);

        /**
         * <p>
         * The name of the backup vault where the tiering configuration applies. Use <code>*</code> to apply to all
         * backup vaults.
         * </p>
         * 
         * @param backupVaultName
         *        The name of the backup vault where the tiering configuration applies. Use <code>*</code> to apply to
         *        all backup vaults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * An array of resource selection objects that specify which resources are included in the tiering configuration
         * and their tiering settings.
         * </p>
         * 
         * @param resourceSelection
         *        An array of resource selection objects that specify which resources are included in the tiering
         *        configuration and their tiering settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSelection(Collection<ResourceSelection> resourceSelection);

        /**
         * <p>
         * An array of resource selection objects that specify which resources are included in the tiering configuration
         * and their tiering settings.
         * </p>
         * 
         * @param resourceSelection
         *        An array of resource selection objects that specify which resources are included in the tiering
         *        configuration and their tiering settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSelection(ResourceSelection... resourceSelection);

        /**
         * <p>
         * An array of resource selection objects that specify which resources are included in the tiering configuration
         * and their tiering settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.ResourceSelection.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.backup.model.ResourceSelection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.ResourceSelection.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceSelection(List<ResourceSelection>)}.
         * 
         * @param resourceSelection
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.ResourceSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSelection(java.util.Collection<ResourceSelection>)
         */
        Builder resourceSelection(Consumer<ResourceSelection.Builder>... resourceSelection);
    }

    static final class BuilderImpl implements Builder {
        private String tieringConfigurationName;

        private String backupVaultName;

        private List<ResourceSelection> resourceSelection = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TieringConfigurationInputForCreate model) {
            tieringConfigurationName(model.tieringConfigurationName);
            backupVaultName(model.backupVaultName);
            resourceSelection(model.resourceSelection);
        }

        public final String getTieringConfigurationName() {
            return tieringConfigurationName;
        }

        public final void setTieringConfigurationName(String tieringConfigurationName) {
            this.tieringConfigurationName = tieringConfigurationName;
        }

        @Override
        public final Builder tieringConfigurationName(String tieringConfigurationName) {
            this.tieringConfigurationName = tieringConfigurationName;
            return this;
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final List<ResourceSelection.Builder> getResourceSelection() {
            List<ResourceSelection.Builder> result = ResourceSelectionsCopier.copyToBuilder(this.resourceSelection);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceSelection(Collection<ResourceSelection.BuilderImpl> resourceSelection) {
            this.resourceSelection = ResourceSelectionsCopier.copyFromBuilder(resourceSelection);
        }

        @Override
        public final Builder resourceSelection(Collection<ResourceSelection> resourceSelection) {
            this.resourceSelection = ResourceSelectionsCopier.copy(resourceSelection);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSelection(ResourceSelection... resourceSelection) {
            resourceSelection(Arrays.asList(resourceSelection));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSelection(Consumer<ResourceSelection.Builder>... resourceSelection) {
            resourceSelection(Stream.of(resourceSelection).map(c -> ResourceSelection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TieringConfigurationInputForCreate build() {
            return new TieringConfigurationInputForCreate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
