/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ScanResultsCopier {
    static List<ScanResult> copy(Collection<? extends ScanResult> scanResultsParam) {
        List<ScanResult> list;
        if (scanResultsParam == null || scanResultsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ScanResult> modifiableList = new ArrayList<>(scanResultsParam.size());
            scanResultsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ScanResult> copyFromBuilder(Collection<? extends ScanResult.Builder> scanResultsParam) {
        List<ScanResult> list;
        if (scanResultsParam == null || scanResultsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ScanResult> modifiableList = new ArrayList<>(scanResultsParam.size());
            scanResultsParam.forEach(entry -> {
                ScanResult member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ScanResult.Builder> copyToBuilder(Collection<? extends ScanResult> scanResultsParam) {
        List<ScanResult.Builder> list;
        if (scanResultsParam == null || scanResultsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ScanResult.Builder> modifiableList = new ArrayList<>(scanResultsParam.size());
            scanResultsParam.forEach(entry -> {
                ScanResult.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
