/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListScanJobsResponse extends BackupResponse implements
        ToCopyableBuilder<ListScanJobsResponse.Builder, ListScanJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListScanJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ScanJob>> SCAN_JOBS_FIELD = SdkField
            .<List<ScanJob>> builder(MarshallingType.LIST)
            .memberName("ScanJobs")
            .getter(getter(ListScanJobsResponse::scanJobs))
            .setter(setter(Builder::scanJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScanJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScanJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SCAN_JOBS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ScanJob> scanJobs;

    private ListScanJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.scanJobs = builder.scanJobs;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanJobs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScanJobs() {
        return scanJobs != null && !(scanJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures containing metadata about your scan jobs returned in JSON format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanJobs} method.
     * </p>
     * 
     * @return An array of structures containing metadata about your scan jobs returned in JSON format.
     */
    public final List<ScanJob> scanJobs() {
        return scanJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasScanJobs() ? scanJobs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScanJobsResponse)) {
            return false;
        }
        ListScanJobsResponse other = (ListScanJobsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasScanJobs() == other.hasScanJobs()
                && Objects.equals(scanJobs(), other.scanJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListScanJobsResponse").add("NextToken", nextToken())
                .add("ScanJobs", hasScanJobs() ? scanJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ScanJobs":
            return Optional.ofNullable(clazz.cast(scanJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ScanJobs", SCAN_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListScanJobsResponse, T> g) {
        return obj -> g.apply((ListScanJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListScanJobsResponse> {
        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of structures containing metadata about your scan jobs returned in JSON format.
         * </p>
         * 
         * @param scanJobs
         *        An array of structures containing metadata about your scan jobs returned in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanJobs(Collection<ScanJob> scanJobs);

        /**
         * <p>
         * An array of structures containing metadata about your scan jobs returned in JSON format.
         * </p>
         * 
         * @param scanJobs
         *        An array of structures containing metadata about your scan jobs returned in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanJobs(ScanJob... scanJobs);

        /**
         * <p>
         * An array of structures containing metadata about your scan jobs returned in JSON format.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.ScanJob.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.backup.model.ScanJob#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.ScanJob.Builder#build()} is called immediately and its
         * result is passed to {@link #scanJobs(List<ScanJob>)}.
         * 
         * @param scanJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.ScanJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanJobs(java.util.Collection<ScanJob>)
         */
        Builder scanJobs(Consumer<ScanJob.Builder>... scanJobs);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ScanJob> scanJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListScanJobsResponse model) {
            super(model);
            nextToken(model.nextToken);
            scanJobs(model.scanJobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ScanJob.Builder> getScanJobs() {
            List<ScanJob.Builder> result = ScanJobsCopier.copyToBuilder(this.scanJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanJobs(Collection<ScanJob.BuilderImpl> scanJobs) {
            this.scanJobs = ScanJobsCopier.copyFromBuilder(scanJobs);
        }

        @Override
        public final Builder scanJobs(Collection<ScanJob> scanJobs) {
            this.scanJobs = ScanJobsCopier.copy(scanJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanJobs(ScanJob... scanJobs) {
            scanJobs(Arrays.asList(scanJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanJobs(Consumer<ScanJob.Builder>... scanJobs) {
            scanJobs(Stream.of(scanJobs).map(c -> ScanJob.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListScanJobsResponse build() {
            return new ListScanJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
