/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an optional backup plan display name and an array of <code>BackupRule</code> objects, each of which
 * specifies a backup rule. Each rule in a backup plan is a separate scheduled task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackupPlanInput implements SdkPojo, Serializable, ToCopyableBuilder<BackupPlanInput.Builder, BackupPlanInput> {
    private static final SdkField<String> BACKUP_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanName").getter(getter(BackupPlanInput::backupPlanName)).setter(setter(Builder::backupPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanName").build()).build();

    private static final SdkField<List<BackupRuleInput>> RULES_FIELD = SdkField
            .<List<BackupRuleInput>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(BackupPlanInput::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BackupRuleInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(BackupRuleInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AdvancedBackupSetting>> ADVANCED_BACKUP_SETTINGS_FIELD = SdkField
            .<List<AdvancedBackupSetting>> builder(MarshallingType.LIST)
            .memberName("AdvancedBackupSettings")
            .getter(getter(BackupPlanInput::advancedBackupSettings))
            .setter(setter(Builder::advancedBackupSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedBackupSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdvancedBackupSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdvancedBackupSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ScanSetting>> SCAN_SETTINGS_FIELD = SdkField
            .<List<ScanSetting>> builder(MarshallingType.LIST)
            .memberName("ScanSettings")
            .getter(getter(BackupPlanInput::scanSettings))
            .setter(setter(Builder::scanSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScanSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScanSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_NAME_FIELD,
            RULES_FIELD, ADVANCED_BACKUP_SETTINGS_FIELD, SCAN_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String backupPlanName;

    private final List<BackupRuleInput> rules;

    private final List<AdvancedBackupSetting> advancedBackupSettings;

    private final List<ScanSetting> scanSettings;

    private BackupPlanInput(BuilderImpl builder) {
        this.backupPlanName = builder.backupPlanName;
        this.rules = builder.rules;
        this.advancedBackupSettings = builder.advancedBackupSettings;
        this.scanSettings = builder.scanSettings;
    }

    /**
     * <p>
     * The display name of a backup plan. Must contain 1 to 50 alphanumeric or '-_.' characters.
     * </p>
     * 
     * @return The display name of a backup plan. Must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public final String backupPlanName() {
        return backupPlanName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up a
     * selection of resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to
     *         back up a selection of resources.
     */
    public final List<BackupRuleInput> rules() {
        return rules;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdvancedBackupSettings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdvancedBackupSettings() {
        return advancedBackupSettings != null && !(advancedBackupSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a list of <code>BackupOptions</code> for each resource type. These settings are only available for
     * Windows Volume Shadow Copy Service (VSS) backup jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdvancedBackupSettings} method.
     * </p>
     * 
     * @return Specifies a list of <code>BackupOptions</code> for each resource type. These settings are only available
     *         for Windows Volume Shadow Copy Service (VSS) backup jobs.
     */
    public final List<AdvancedBackupSetting> advancedBackupSettings() {
        return advancedBackupSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanSettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScanSettings() {
        return scanSettings != null && !(scanSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains your scanning configuration for the backup rule and includes the malware scanner, and scan mode of
     * either full or incremental.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanSettings} method.
     * </p>
     * 
     * @return Contains your scanning configuration for the backup rule and includes the malware scanner, and scan mode
     *         of either full or incremental.
     */
    public final List<ScanSetting> scanSettings() {
        return scanSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAdvancedBackupSettings() ? advancedBackupSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasScanSettings() ? scanSettings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupPlanInput)) {
            return false;
        }
        BackupPlanInput other = (BackupPlanInput) obj;
        return Objects.equals(backupPlanName(), other.backupPlanName()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules()) && hasAdvancedBackupSettings() == other.hasAdvancedBackupSettings()
                && Objects.equals(advancedBackupSettings(), other.advancedBackupSettings())
                && hasScanSettings() == other.hasScanSettings() && Objects.equals(scanSettings(), other.scanSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BackupPlanInput").add("BackupPlanName", backupPlanName())
                .add("Rules", hasRules() ? rules() : null)
                .add("AdvancedBackupSettings", hasAdvancedBackupSettings() ? advancedBackupSettings() : null)
                .add("ScanSettings", hasScanSettings() ? scanSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlanName":
            return Optional.ofNullable(clazz.cast(backupPlanName()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "AdvancedBackupSettings":
            return Optional.ofNullable(clazz.cast(advancedBackupSettings()));
        case "ScanSettings":
            return Optional.ofNullable(clazz.cast(scanSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackupPlanName", BACKUP_PLAN_NAME_FIELD);
        map.put("Rules", RULES_FIELD);
        map.put("AdvancedBackupSettings", ADVANCED_BACKUP_SETTINGS_FIELD);
        map.put("ScanSettings", SCAN_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BackupPlanInput, T> g) {
        return obj -> g.apply((BackupPlanInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackupPlanInput> {
        /**
         * <p>
         * The display name of a backup plan. Must contain 1 to 50 alphanumeric or '-_.' characters.
         * </p>
         * 
         * @param backupPlanName
         *        The display name of a backup plan. Must contain 1 to 50 alphanumeric or '-_.' characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanName(String backupPlanName);

        /**
         * <p>
         * An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up
         * a selection of resources.
         * </p>
         * 
         * @param rules
         *        An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to
         *        back up a selection of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<BackupRuleInput> rules);

        /**
         * <p>
         * An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up
         * a selection of resources.
         * </p>
         * 
         * @param rules
         *        An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to
         *        back up a selection of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(BackupRuleInput... rules);

        /**
         * <p>
         * An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up
         * a selection of resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.BackupRuleInput.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.backup.model.BackupRuleInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.BackupRuleInput.Builder#build()} is called immediately
         * and its result is passed to {@link #rules(List<BackupRuleInput>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.BackupRuleInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<BackupRuleInput>)
         */
        Builder rules(Consumer<BackupRuleInput.Builder>... rules);

        /**
         * <p>
         * Specifies a list of <code>BackupOptions</code> for each resource type. These settings are only available for
         * Windows Volume Shadow Copy Service (VSS) backup jobs.
         * </p>
         * 
         * @param advancedBackupSettings
         *        Specifies a list of <code>BackupOptions</code> for each resource type. These settings are only
         *        available for Windows Volume Shadow Copy Service (VSS) backup jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedBackupSettings(Collection<AdvancedBackupSetting> advancedBackupSettings);

        /**
         * <p>
         * Specifies a list of <code>BackupOptions</code> for each resource type. These settings are only available for
         * Windows Volume Shadow Copy Service (VSS) backup jobs.
         * </p>
         * 
         * @param advancedBackupSettings
         *        Specifies a list of <code>BackupOptions</code> for each resource type. These settings are only
         *        available for Windows Volume Shadow Copy Service (VSS) backup jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedBackupSettings(AdvancedBackupSetting... advancedBackupSettings);

        /**
         * <p>
         * Specifies a list of <code>BackupOptions</code> for each resource type. These settings are only available for
         * Windows Volume Shadow Copy Service (VSS) backup jobs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.AdvancedBackupSetting.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.backup.model.AdvancedBackupSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.AdvancedBackupSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #advancedBackupSettings(List<AdvancedBackupSetting>)}.
         * 
         * @param advancedBackupSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.AdvancedBackupSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedBackupSettings(java.util.Collection<AdvancedBackupSetting>)
         */
        Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder>... advancedBackupSettings);

        /**
         * <p>
         * Contains your scanning configuration for the backup rule and includes the malware scanner, and scan mode of
         * either full or incremental.
         * </p>
         * 
         * @param scanSettings
         *        Contains your scanning configuration for the backup rule and includes the malware scanner, and scan
         *        mode of either full or incremental.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanSettings(Collection<ScanSetting> scanSettings);

        /**
         * <p>
         * Contains your scanning configuration for the backup rule and includes the malware scanner, and scan mode of
         * either full or incremental.
         * </p>
         * 
         * @param scanSettings
         *        Contains your scanning configuration for the backup rule and includes the malware scanner, and scan
         *        mode of either full or incremental.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanSettings(ScanSetting... scanSettings);

        /**
         * <p>
         * Contains your scanning configuration for the backup rule and includes the malware scanner, and scan mode of
         * either full or incremental.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.ScanSetting.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.backup.model.ScanSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.ScanSetting.Builder#build()} is called immediately and
         * its result is passed to {@link #scanSettings(List<ScanSetting>)}.
         * 
         * @param scanSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.ScanSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanSettings(java.util.Collection<ScanSetting>)
         */
        Builder scanSettings(Consumer<ScanSetting.Builder>... scanSettings);
    }

    static final class BuilderImpl implements Builder {
        private String backupPlanName;

        private List<BackupRuleInput> rules = DefaultSdkAutoConstructList.getInstance();

        private List<AdvancedBackupSetting> advancedBackupSettings = DefaultSdkAutoConstructList.getInstance();

        private List<ScanSetting> scanSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BackupPlanInput model) {
            backupPlanName(model.backupPlanName);
            rules(model.rules);
            advancedBackupSettings(model.advancedBackupSettings);
            scanSettings(model.scanSettings);
        }

        public final String getBackupPlanName() {
            return backupPlanName;
        }

        public final void setBackupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
        }

        @Override
        public final Builder backupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
            return this;
        }

        public final List<BackupRuleInput.Builder> getRules() {
            List<BackupRuleInput.Builder> result = BackupRulesInputCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<BackupRuleInput.BuilderImpl> rules) {
            this.rules = BackupRulesInputCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<BackupRuleInput> rules) {
            this.rules = BackupRulesInputCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(BackupRuleInput... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<BackupRuleInput.Builder>... rules) {
            rules(Stream.of(rules).map(c -> BackupRuleInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AdvancedBackupSetting.Builder> getAdvancedBackupSettings() {
            List<AdvancedBackupSetting.Builder> result = AdvancedBackupSettingsCopier.copyToBuilder(this.advancedBackupSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdvancedBackupSettings(Collection<AdvancedBackupSetting.BuilderImpl> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copyFromBuilder(advancedBackupSettings);
        }

        @Override
        public final Builder advancedBackupSettings(Collection<AdvancedBackupSetting> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copy(advancedBackupSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(AdvancedBackupSetting... advancedBackupSettings) {
            advancedBackupSettings(Arrays.asList(advancedBackupSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder>... advancedBackupSettings) {
            advancedBackupSettings(Stream.of(advancedBackupSettings)
                    .map(c -> AdvancedBackupSetting.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ScanSetting.Builder> getScanSettings() {
            List<ScanSetting.Builder> result = ScanSettingsCopier.copyToBuilder(this.scanSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanSettings(Collection<ScanSetting.BuilderImpl> scanSettings) {
            this.scanSettings = ScanSettingsCopier.copyFromBuilder(scanSettings);
        }

        @Override
        public final Builder scanSettings(Collection<ScanSetting> scanSettings) {
            this.scanSettings = ScanSettingsCopier.copy(scanSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanSettings(ScanSetting... scanSettings) {
            scanSettings(Arrays.asList(scanSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanSettings(Consumer<ScanSetting.Builder>... scanSettings) {
            scanSettings(Stream.of(scanSettings).map(c -> ScanSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BackupPlanInput build() {
            return new BackupPlanInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
