/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.IndexedRecoveryPoint;
import software.amazon.awssdk.services.backup.model.IndexedRecoveryPointListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIndexedRecoveryPointsResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListIndexedRecoveryPointsResponse> {
    private static final SdkField<List<IndexedRecoveryPoint>> INDEXED_RECOVERY_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IndexedRecoveryPoints").getter(ListIndexedRecoveryPointsResponse.getter(ListIndexedRecoveryPointsResponse::indexedRecoveryPoints)).setter(ListIndexedRecoveryPointsResponse.setter(Builder::indexedRecoveryPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexedRecoveryPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IndexedRecoveryPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIndexedRecoveryPointsResponse.getter(ListIndexedRecoveryPointsResponse::nextToken)).setter(ListIndexedRecoveryPointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEXED_RECOVERY_POINTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIndexedRecoveryPointsResponse.memberNameToFieldInitializer();
    private final List<IndexedRecoveryPoint> indexedRecoveryPoints;
    private final String nextToken;

    private ListIndexedRecoveryPointsResponse(BuilderImpl builder) {
        super(builder);
        this.indexedRecoveryPoints = builder.indexedRecoveryPoints;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIndexedRecoveryPoints() {
        return this.indexedRecoveryPoints != null && !(this.indexedRecoveryPoints instanceof SdkAutoConstructList);
    }

    public final List<IndexedRecoveryPoint> indexedRecoveryPoints() {
        return this.indexedRecoveryPoints;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIndexedRecoveryPoints() ? this.indexedRecoveryPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndexedRecoveryPointsResponse)) {
            return false;
        }
        ListIndexedRecoveryPointsResponse other = (ListIndexedRecoveryPointsResponse)((Object)obj);
        return this.hasIndexedRecoveryPoints() == other.hasIndexedRecoveryPoints() && Objects.equals(this.indexedRecoveryPoints(), other.indexedRecoveryPoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListIndexedRecoveryPointsResponse").add("IndexedRecoveryPoints", this.hasIndexedRecoveryPoints() ? this.indexedRecoveryPoints() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexedRecoveryPoints": {
                return Optional.ofNullable(clazz.cast(this.indexedRecoveryPoints()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IndexedRecoveryPoints", INDEXED_RECOVERY_POINTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIndexedRecoveryPointsResponse, T> g) {
        return obj -> g.apply((ListIndexedRecoveryPointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private List<IndexedRecoveryPoint> indexedRecoveryPoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndexedRecoveryPointsResponse model) {
            super(model);
            this.indexedRecoveryPoints(model.indexedRecoveryPoints);
            this.nextToken(model.nextToken);
        }

        public final List<IndexedRecoveryPoint.Builder> getIndexedRecoveryPoints() {
            List<IndexedRecoveryPoint.Builder> result = IndexedRecoveryPointListCopier.copyToBuilder(this.indexedRecoveryPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndexedRecoveryPoints(Collection<IndexedRecoveryPoint.BuilderImpl> indexedRecoveryPoints) {
            this.indexedRecoveryPoints = IndexedRecoveryPointListCopier.copyFromBuilder(indexedRecoveryPoints);
        }

        @Override
        public final Builder indexedRecoveryPoints(Collection<IndexedRecoveryPoint> indexedRecoveryPoints) {
            this.indexedRecoveryPoints = IndexedRecoveryPointListCopier.copy(indexedRecoveryPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexedRecoveryPoints(IndexedRecoveryPoint ... indexedRecoveryPoints) {
            this.indexedRecoveryPoints(Arrays.asList(indexedRecoveryPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexedRecoveryPoints(Consumer<IndexedRecoveryPoint.Builder> ... indexedRecoveryPoints) {
            this.indexedRecoveryPoints(Stream.of(indexedRecoveryPoints).map(c -> (IndexedRecoveryPoint)((IndexedRecoveryPoint.Builder)IndexedRecoveryPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIndexedRecoveryPointsResponse build() {
            return new ListIndexedRecoveryPointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIndexedRecoveryPointsResponse> {
        public Builder indexedRecoveryPoints(Collection<IndexedRecoveryPoint> var1);

        public Builder indexedRecoveryPoints(IndexedRecoveryPoint ... var1);

        public Builder indexedRecoveryPoints(Consumer<IndexedRecoveryPoint.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

