/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.RestoreTestingSelectionForCreate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRestoreTestingSelectionRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, CreateRestoreTestingSelectionRequest> {
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(CreateRestoreTestingSelectionRequest.getter(CreateRestoreTestingSelectionRequest::creatorRequestId)).setter(CreateRestoreTestingSelectionRequest.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<String> RESTORE_TESTING_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestoreTestingPlanName").getter(CreateRestoreTestingSelectionRequest.getter(CreateRestoreTestingSelectionRequest::restoreTestingPlanName)).setter(CreateRestoreTestingSelectionRequest.setter(Builder::restoreTestingPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("RestoreTestingPlanName").build()}).build();
    private static final SdkField<RestoreTestingSelectionForCreate> RESTORE_TESTING_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RestoreTestingSelection").getter(CreateRestoreTestingSelectionRequest.getter(CreateRestoreTestingSelectionRequest::restoreTestingSelection)).setter(CreateRestoreTestingSelectionRequest.setter(Builder::restoreTestingSelection)).constructor(RestoreTestingSelectionForCreate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingSelection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATOR_REQUEST_ID_FIELD, RESTORE_TESTING_PLAN_NAME_FIELD, RESTORE_TESTING_SELECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRestoreTestingSelectionRequest.memberNameToFieldInitializer();
    private final String creatorRequestId;
    private final String restoreTestingPlanName;
    private final RestoreTestingSelectionForCreate restoreTestingSelection;

    private CreateRestoreTestingSelectionRequest(BuilderImpl builder) {
        super(builder);
        this.creatorRequestId = builder.creatorRequestId;
        this.restoreTestingPlanName = builder.restoreTestingPlanName;
        this.restoreTestingSelection = builder.restoreTestingSelection;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final String restoreTestingPlanName() {
        return this.restoreTestingPlanName;
    }

    public final RestoreTestingSelectionForCreate restoreTestingSelection() {
        return this.restoreTestingSelection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreTestingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreTestingSelection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRestoreTestingSelectionRequest)) {
            return false;
        }
        CreateRestoreTestingSelectionRequest other = (CreateRestoreTestingSelectionRequest)((Object)obj);
        return Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.restoreTestingPlanName(), other.restoreTestingPlanName()) && Objects.equals(this.restoreTestingSelection(), other.restoreTestingSelection());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRestoreTestingSelectionRequest").add("CreatorRequestId", (Object)this.creatorRequestId()).add("RestoreTestingPlanName", (Object)this.restoreTestingPlanName()).add("RestoreTestingSelection", (Object)this.restoreTestingSelection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "RestoreTestingPlanName": {
                return Optional.ofNullable(clazz.cast(this.restoreTestingPlanName()));
            }
            case "RestoreTestingSelection": {
                return Optional.ofNullable(clazz.cast(this.restoreTestingSelection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        map.put("RestoreTestingPlanName", RESTORE_TESTING_PLAN_NAME_FIELD);
        map.put("RestoreTestingSelection", RESTORE_TESTING_SELECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRestoreTestingSelectionRequest, T> g) {
        return obj -> g.apply((CreateRestoreTestingSelectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String creatorRequestId;
        private String restoreTestingPlanName;
        private RestoreTestingSelectionForCreate restoreTestingSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRestoreTestingSelectionRequest model) {
            super(model);
            this.creatorRequestId(model.creatorRequestId);
            this.restoreTestingPlanName(model.restoreTestingPlanName);
            this.restoreTestingSelection(model.restoreTestingSelection);
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getRestoreTestingPlanName() {
            return this.restoreTestingPlanName;
        }

        public final void setRestoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
        }

        @Override
        public final Builder restoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        public final RestoreTestingSelectionForCreate.Builder getRestoreTestingSelection() {
            return this.restoreTestingSelection != null ? this.restoreTestingSelection.toBuilder() : null;
        }

        public final void setRestoreTestingSelection(RestoreTestingSelectionForCreate.BuilderImpl restoreTestingSelection) {
            this.restoreTestingSelection = restoreTestingSelection != null ? restoreTestingSelection.build() : null;
        }

        @Override
        public final Builder restoreTestingSelection(RestoreTestingSelectionForCreate restoreTestingSelection) {
            this.restoreTestingSelection = restoreTestingSelection;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRestoreTestingSelectionRequest build() {
            return new CreateRestoreTestingSelectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRestoreTestingSelectionRequest> {
        public Builder creatorRequestId(String var1);

        public Builder restoreTestingPlanName(String var1);

        public Builder restoreTestingSelection(RestoreTestingSelectionForCreate var1);

        default public Builder restoreTestingSelection(Consumer<RestoreTestingSelectionForCreate.Builder> restoreTestingSelection) {
            return this.restoreTestingSelection((RestoreTestingSelectionForCreate)((RestoreTestingSelectionForCreate.Builder)RestoreTestingSelectionForCreate.builder().applyMutation(restoreTestingSelection)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

