/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.BackupSelectionsListMember;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse;

public class ListBackupSelectionsIterable
implements SdkIterable<ListBackupSelectionsResponse> {
    private final BackupClient client;
    private final ListBackupSelectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBackupSelectionsIterable(BackupClient client, ListBackupSelectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBackupSelectionsResponseFetcher();
    }

    public Iterator<ListBackupSelectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BackupSelectionsListMember> backupSelectionsList() {
        Function<ListBackupSelectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.backupSelectionsList() != null) {
                return response.backupSelectionsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBackupSelectionsResponseFetcher
    implements SyncPageFetcher<ListBackupSelectionsResponse> {
        private ListBackupSelectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListBackupSelectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBackupSelectionsResponse nextPage(ListBackupSelectionsResponse previousPage) {
            if (previousPage == null) {
                return ListBackupSelectionsIterable.this.client.listBackupSelections(ListBackupSelectionsIterable.this.firstRequest);
            }
            return ListBackupSelectionsIterable.this.client.listBackupSelections((ListBackupSelectionsRequest)((Object)ListBackupSelectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

