/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListReportJobsRequest;
import software.amazon.awssdk.services.backup.model.ListReportJobsResponse;

public class ListReportJobsPublisher
implements SdkPublisher<ListReportJobsResponse> {
    private final BackupAsyncClient client;
    private final ListReportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReportJobsPublisher(BackupAsyncClient client, ListReportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReportJobsPublisher(BackupAsyncClient client, ListReportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListReportJobsResponseFetcher
    implements AsyncPageFetcher<ListReportJobsResponse> {
        private ListReportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListReportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReportJobsResponse> nextPage(ListReportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListReportJobsPublisher.this.client.listReportJobs(ListReportJobsPublisher.this.firstRequest);
            }
            return ListReportJobsPublisher.this.client.listReportJobs((ListReportJobsRequest)((Object)ListReportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

