/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.RestoreTestingRecoveryPointSelectionAlgorithm;
import software.amazon.awssdk.services.backup.model.RestoreTestingRecoveryPointType;
import software.amazon.awssdk.services.backup.model.RestoreTestingRecoveryPointTypeListCopier;
import software.amazon.awssdk.services.backup.model._stringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreTestingRecoveryPointSelection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RestoreTestingRecoveryPointSelection> {
    private static final SdkField<String> ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Algorithm").getter(RestoreTestingRecoveryPointSelection.getter(RestoreTestingRecoveryPointSelection::algorithmAsString)).setter(RestoreTestingRecoveryPointSelection.setter(Builder::algorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Algorithm").build()}).build();
    private static final SdkField<List<String>> EXCLUDE_VAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeVaults").getter(RestoreTestingRecoveryPointSelection.getter(RestoreTestingRecoveryPointSelection::excludeVaults)).setter(RestoreTestingRecoveryPointSelection.setter(Builder::excludeVaults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeVaults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUDE_VAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludeVaults").getter(RestoreTestingRecoveryPointSelection.getter(RestoreTestingRecoveryPointSelection::includeVaults)).setter(RestoreTestingRecoveryPointSelection.setter(Builder::includeVaults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeVaults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RECOVERY_POINT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecoveryPointTypes").getter(RestoreTestingRecoveryPointSelection.getter(RestoreTestingRecoveryPointSelection::recoveryPointTypesAsStrings)).setter(RestoreTestingRecoveryPointSelection.setter(Builder::recoveryPointTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> SELECTION_WINDOW_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SelectionWindowDays").getter(RestoreTestingRecoveryPointSelection.getter(RestoreTestingRecoveryPointSelection::selectionWindowDays)).setter(RestoreTestingRecoveryPointSelection.setter(Builder::selectionWindowDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionWindowDays").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD, EXCLUDE_VAULTS_FIELD, INCLUDE_VAULTS_FIELD, RECOVERY_POINT_TYPES_FIELD, SELECTION_WINDOW_DAYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RestoreTestingRecoveryPointSelection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String algorithm;
    private final List<String> excludeVaults;
    private final List<String> includeVaults;
    private final List<String> recoveryPointTypes;
    private final Integer selectionWindowDays;

    private RestoreTestingRecoveryPointSelection(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.excludeVaults = builder.excludeVaults;
        this.includeVaults = builder.includeVaults;
        this.recoveryPointTypes = builder.recoveryPointTypes;
        this.selectionWindowDays = builder.selectionWindowDays;
    }

    public final RestoreTestingRecoveryPointSelectionAlgorithm algorithm() {
        return RestoreTestingRecoveryPointSelectionAlgorithm.fromValue(this.algorithm);
    }

    public final String algorithmAsString() {
        return this.algorithm;
    }

    public final boolean hasExcludeVaults() {
        return this.excludeVaults != null && !(this.excludeVaults instanceof SdkAutoConstructList);
    }

    public final List<String> excludeVaults() {
        return this.excludeVaults;
    }

    public final boolean hasIncludeVaults() {
        return this.includeVaults != null && !(this.includeVaults instanceof SdkAutoConstructList);
    }

    public final List<String> includeVaults() {
        return this.includeVaults;
    }

    public final List<RestoreTestingRecoveryPointType> recoveryPointTypes() {
        return RestoreTestingRecoveryPointTypeListCopier.copyStringToEnum(this.recoveryPointTypes);
    }

    public final boolean hasRecoveryPointTypes() {
        return this.recoveryPointTypes != null && !(this.recoveryPointTypes instanceof SdkAutoConstructList);
    }

    public final List<String> recoveryPointTypesAsStrings() {
        return this.recoveryPointTypes;
    }

    public final Integer selectionWindowDays() {
        return this.selectionWindowDays;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeVaults() ? this.excludeVaults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeVaults() ? this.includeVaults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecoveryPointTypes() ? this.recoveryPointTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionWindowDays());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTestingRecoveryPointSelection)) {
            return false;
        }
        RestoreTestingRecoveryPointSelection other = (RestoreTestingRecoveryPointSelection)obj;
        return Objects.equals(this.algorithmAsString(), other.algorithmAsString()) && this.hasExcludeVaults() == other.hasExcludeVaults() && Objects.equals(this.excludeVaults(), other.excludeVaults()) && this.hasIncludeVaults() == other.hasIncludeVaults() && Objects.equals(this.includeVaults(), other.includeVaults()) && this.hasRecoveryPointTypes() == other.hasRecoveryPointTypes() && Objects.equals(this.recoveryPointTypesAsStrings(), other.recoveryPointTypesAsStrings()) && Objects.equals(this.selectionWindowDays(), other.selectionWindowDays());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreTestingRecoveryPointSelection").add("Algorithm", (Object)this.algorithmAsString()).add("ExcludeVaults", this.hasExcludeVaults() ? this.excludeVaults() : null).add("IncludeVaults", this.hasIncludeVaults() ? this.includeVaults() : null).add("RecoveryPointTypes", this.hasRecoveryPointTypes() ? this.recoveryPointTypesAsStrings() : null).add("SelectionWindowDays", (Object)this.selectionWindowDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Algorithm": {
                return Optional.ofNullable(clazz.cast(this.algorithmAsString()));
            }
            case "ExcludeVaults": {
                return Optional.ofNullable(clazz.cast(this.excludeVaults()));
            }
            case "IncludeVaults": {
                return Optional.ofNullable(clazz.cast(this.includeVaults()));
            }
            case "RecoveryPointTypes": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointTypesAsStrings()));
            }
            case "SelectionWindowDays": {
                return Optional.ofNullable(clazz.cast(this.selectionWindowDays()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Algorithm", ALGORITHM_FIELD);
        map.put("ExcludeVaults", EXCLUDE_VAULTS_FIELD);
        map.put("IncludeVaults", INCLUDE_VAULTS_FIELD);
        map.put("RecoveryPointTypes", RECOVERY_POINT_TYPES_FIELD);
        map.put("SelectionWindowDays", SELECTION_WINDOW_DAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreTestingRecoveryPointSelection, T> g) {
        return obj -> g.apply((RestoreTestingRecoveryPointSelection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithm;
        private List<String> excludeVaults = DefaultSdkAutoConstructList.getInstance();
        private List<String> includeVaults = DefaultSdkAutoConstructList.getInstance();
        private List<String> recoveryPointTypes = DefaultSdkAutoConstructList.getInstance();
        private Integer selectionWindowDays;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTestingRecoveryPointSelection model) {
            this.algorithm(model.algorithm);
            this.excludeVaults(model.excludeVaults);
            this.includeVaults(model.includeVaults);
            this.recoveryPointTypesWithStrings(model.recoveryPointTypes);
            this.selectionWindowDays(model.selectionWindowDays);
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(RestoreTestingRecoveryPointSelectionAlgorithm algorithm) {
            this.algorithm(algorithm == null ? null : algorithm.toString());
            return this;
        }

        public final Collection<String> getExcludeVaults() {
            if (this.excludeVaults instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeVaults;
        }

        public final void setExcludeVaults(Collection<String> excludeVaults) {
            this.excludeVaults = _stringListCopier.copy(excludeVaults);
        }

        @Override
        public final Builder excludeVaults(Collection<String> excludeVaults) {
            this.excludeVaults = _stringListCopier.copy(excludeVaults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeVaults(String ... excludeVaults) {
            this.excludeVaults(Arrays.asList(excludeVaults));
            return this;
        }

        public final Collection<String> getIncludeVaults() {
            if (this.includeVaults instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includeVaults;
        }

        public final void setIncludeVaults(Collection<String> includeVaults) {
            this.includeVaults = _stringListCopier.copy(includeVaults);
        }

        @Override
        public final Builder includeVaults(Collection<String> includeVaults) {
            this.includeVaults = _stringListCopier.copy(includeVaults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeVaults(String ... includeVaults) {
            this.includeVaults(Arrays.asList(includeVaults));
            return this;
        }

        public final Collection<String> getRecoveryPointTypes() {
            if (this.recoveryPointTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recoveryPointTypes;
        }

        public final void setRecoveryPointTypes(Collection<String> recoveryPointTypes) {
            this.recoveryPointTypes = RestoreTestingRecoveryPointTypeListCopier.copy(recoveryPointTypes);
        }

        @Override
        public final Builder recoveryPointTypesWithStrings(Collection<String> recoveryPointTypes) {
            this.recoveryPointTypes = RestoreTestingRecoveryPointTypeListCopier.copy(recoveryPointTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recoveryPointTypesWithStrings(String ... recoveryPointTypes) {
            this.recoveryPointTypesWithStrings(Arrays.asList(recoveryPointTypes));
            return this;
        }

        @Override
        public final Builder recoveryPointTypes(Collection<RestoreTestingRecoveryPointType> recoveryPointTypes) {
            this.recoveryPointTypes = RestoreTestingRecoveryPointTypeListCopier.copyEnumToString(recoveryPointTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recoveryPointTypes(RestoreTestingRecoveryPointType ... recoveryPointTypes) {
            this.recoveryPointTypes(Arrays.asList(recoveryPointTypes));
            return this;
        }

        public final Integer getSelectionWindowDays() {
            return this.selectionWindowDays;
        }

        public final void setSelectionWindowDays(Integer selectionWindowDays) {
            this.selectionWindowDays = selectionWindowDays;
        }

        @Override
        public final Builder selectionWindowDays(Integer selectionWindowDays) {
            this.selectionWindowDays = selectionWindowDays;
            return this;
        }

        public RestoreTestingRecoveryPointSelection build() {
            return new RestoreTestingRecoveryPointSelection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RestoreTestingRecoveryPointSelection> {
        public Builder algorithm(String var1);

        public Builder algorithm(RestoreTestingRecoveryPointSelectionAlgorithm var1);

        public Builder excludeVaults(Collection<String> var1);

        public Builder excludeVaults(String ... var1);

        public Builder includeVaults(Collection<String> var1);

        public Builder includeVaults(String ... var1);

        public Builder recoveryPointTypesWithStrings(Collection<String> var1);

        public Builder recoveryPointTypesWithStrings(String ... var1);

        public Builder recoveryPointTypes(Collection<RestoreTestingRecoveryPointType> var1);

        public Builder recoveryPointTypes(RestoreTestingRecoveryPointType ... var1);

        public Builder selectionWindowDays(Integer var1);
    }
}

