/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.CopyJobSummary;
import software.amazon.awssdk.services.backup.model.CopyJobSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCopyJobSummariesResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListCopyJobSummariesResponse> {
    private static final SdkField<List<CopyJobSummary>> COPY_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CopyJobSummaries").getter(ListCopyJobSummariesResponse.getter(ListCopyJobSummariesResponse::copyJobSummaries)).setter(ListCopyJobSummariesResponse.setter(Builder::copyJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CopyJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AGGREGATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggregationPeriod").getter(ListCopyJobSummariesResponse.getter(ListCopyJobSummariesResponse::aggregationPeriod)).setter(ListCopyJobSummariesResponse.setter(Builder::aggregationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationPeriod").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCopyJobSummariesResponse.getter(ListCopyJobSummariesResponse::nextToken)).setter(ListCopyJobSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_JOB_SUMMARIES_FIELD, AGGREGATION_PERIOD_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CopyJobSummaries", COPY_JOB_SUMMARIES_FIELD);
            this.put("AggregationPeriod", AGGREGATION_PERIOD_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<CopyJobSummary> copyJobSummaries;
    private final String aggregationPeriod;
    private final String nextToken;

    private ListCopyJobSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.copyJobSummaries = builder.copyJobSummaries;
        this.aggregationPeriod = builder.aggregationPeriod;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCopyJobSummaries() {
        return this.copyJobSummaries != null && !(this.copyJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<CopyJobSummary> copyJobSummaries() {
        return this.copyJobSummaries;
    }

    public final String aggregationPeriod() {
        return this.aggregationPeriod;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCopyJobSummaries() ? this.copyJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCopyJobSummariesResponse)) {
            return false;
        }
        ListCopyJobSummariesResponse other = (ListCopyJobSummariesResponse)((Object)obj);
        return this.hasCopyJobSummaries() == other.hasCopyJobSummaries() && Objects.equals(this.copyJobSummaries(), other.copyJobSummaries()) && Objects.equals(this.aggregationPeriod(), other.aggregationPeriod()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCopyJobSummariesResponse").add("CopyJobSummaries", this.hasCopyJobSummaries() ? this.copyJobSummaries() : null).add("AggregationPeriod", (Object)this.aggregationPeriod()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CopyJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.copyJobSummaries()));
            }
            case "AggregationPeriod": {
                return Optional.ofNullable(clazz.cast(this.aggregationPeriod()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCopyJobSummariesResponse, T> g) {
        return obj -> g.apply((ListCopyJobSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private List<CopyJobSummary> copyJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String aggregationPeriod;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCopyJobSummariesResponse model) {
            super(model);
            this.copyJobSummaries(model.copyJobSummaries);
            this.aggregationPeriod(model.aggregationPeriod);
            this.nextToken(model.nextToken);
        }

        public final List<CopyJobSummary.Builder> getCopyJobSummaries() {
            List<CopyJobSummary.Builder> result = CopyJobSummaryListCopier.copyToBuilder(this.copyJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCopyJobSummaries(Collection<CopyJobSummary.BuilderImpl> copyJobSummaries) {
            this.copyJobSummaries = CopyJobSummaryListCopier.copyFromBuilder(copyJobSummaries);
        }

        @Override
        public final Builder copyJobSummaries(Collection<CopyJobSummary> copyJobSummaries) {
            this.copyJobSummaries = CopyJobSummaryListCopier.copy(copyJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder copyJobSummaries(CopyJobSummary ... copyJobSummaries) {
            this.copyJobSummaries(Arrays.asList(copyJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder copyJobSummaries(Consumer<CopyJobSummary.Builder> ... copyJobSummaries) {
            this.copyJobSummaries(Stream.of(copyJobSummaries).map(c -> (CopyJobSummary)((CopyJobSummary.Builder)CopyJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAggregationPeriod() {
            return this.aggregationPeriod;
        }

        public final void setAggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
        }

        @Override
        public final Builder aggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCopyJobSummariesResponse build() {
            return new ListCopyJobSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCopyJobSummariesResponse> {
        public Builder copyJobSummaries(Collection<CopyJobSummary> var1);

        public Builder copyJobSummaries(CopyJobSummary ... var1);

        public Builder copyJobSummaries(Consumer<CopyJobSummary.Builder> ... var1);

        public Builder aggregationPeriod(String var1);

        public Builder nextToken(String var1);
    }
}

