/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.LegalHoldStatus;
import software.amazon.awssdk.services.backup.model.RecoveryPointSelection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLegalHoldResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, GetLegalHoldResponse> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(GetLegalHoldResponse.getter(GetLegalHoldResponse::title)).setter(GetLegalHoldResponse.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetLegalHoldResponse.getter(GetLegalHoldResponse::statusAsString)).setter(GetLegalHoldResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetLegalHoldResponse.getter(GetLegalHoldResponse::description)).setter(GetLegalHoldResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CANCEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CancelDescription").getter(GetLegalHoldResponse.getter(GetLegalHoldResponse::cancelDescription)).setter(GetLegalHoldResponse.setter(Builder::cancelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancelDescription").build()}).build();
    private static final SdkField<String> LEGAL_HOLD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LegalHoldId").getter(GetLegalHoldResponse.getter(GetLegalHoldResponse::legalHoldId)).setter(GetLegalHoldResponse.setter(Builder::legalHoldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegalHoldId").build()}).build();
    private static final SdkField<String> LEGAL_HOLD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LegalHoldArn").getter(GetLegalHoldResponse.getter(GetLegalHoldResponse::legalHoldArn)).setter(GetLegalHoldResponse.setter(Builder::legalHoldArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegalHoldArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(GetLegalHoldResponse.getter(GetLegalHoldResponse::creationDate)).setter(GetLegalHoldResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> CANCELLATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CancellationDate").getter(GetLegalHoldResponse.getter(GetLegalHoldResponse::cancellationDate)).setter(GetLegalHoldResponse.setter(Builder::cancellationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancellationDate").build()}).build();
    private static final SdkField<Instant> RETAIN_RECORD_UNTIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RetainRecordUntil").getter(GetLegalHoldResponse.getter(GetLegalHoldResponse::retainRecordUntil)).setter(GetLegalHoldResponse.setter(Builder::retainRecordUntil)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainRecordUntil").build()}).build();
    private static final SdkField<RecoveryPointSelection> RECOVERY_POINT_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecoveryPointSelection").getter(GetLegalHoldResponse.getter(GetLegalHoldResponse::recoveryPointSelection)).setter(GetLegalHoldResponse.setter(Builder::recoveryPointSelection)).constructor(RecoveryPointSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointSelection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, CANCEL_DESCRIPTION_FIELD, LEGAL_HOLD_ID_FIELD, LEGAL_HOLD_ARN_FIELD, CREATION_DATE_FIELD, CANCELLATION_DATE_FIELD, RETAIN_RECORD_UNTIL_FIELD, RECOVERY_POINT_SELECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Title", TITLE_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("CancelDescription", CANCEL_DESCRIPTION_FIELD);
            this.put("LegalHoldId", LEGAL_HOLD_ID_FIELD);
            this.put("LegalHoldArn", LEGAL_HOLD_ARN_FIELD);
            this.put("CreationDate", CREATION_DATE_FIELD);
            this.put("CancellationDate", CANCELLATION_DATE_FIELD);
            this.put("RetainRecordUntil", RETAIN_RECORD_UNTIL_FIELD);
            this.put("RecoveryPointSelection", RECOVERY_POINT_SELECTION_FIELD);
        }
    });
    private final String title;
    private final String status;
    private final String description;
    private final String cancelDescription;
    private final String legalHoldId;
    private final String legalHoldArn;
    private final Instant creationDate;
    private final Instant cancellationDate;
    private final Instant retainRecordUntil;
    private final RecoveryPointSelection recoveryPointSelection;

    private GetLegalHoldResponse(BuilderImpl builder) {
        super(builder);
        this.title = builder.title;
        this.status = builder.status;
        this.description = builder.description;
        this.cancelDescription = builder.cancelDescription;
        this.legalHoldId = builder.legalHoldId;
        this.legalHoldArn = builder.legalHoldArn;
        this.creationDate = builder.creationDate;
        this.cancellationDate = builder.cancellationDate;
        this.retainRecordUntil = builder.retainRecordUntil;
        this.recoveryPointSelection = builder.recoveryPointSelection;
    }

    public final String title() {
        return this.title;
    }

    public final LegalHoldStatus status() {
        return LegalHoldStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String description() {
        return this.description;
    }

    public final String cancelDescription() {
        return this.cancelDescription;
    }

    public final String legalHoldId() {
        return this.legalHoldId;
    }

    public final String legalHoldArn() {
        return this.legalHoldArn;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant cancellationDate() {
        return this.cancellationDate;
    }

    public final Instant retainRecordUntil() {
        return this.retainRecordUntil;
    }

    public final RecoveryPointSelection recoveryPointSelection() {
        return this.recoveryPointSelection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.cancelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.legalHoldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.legalHoldArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.cancellationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainRecordUntil());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointSelection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLegalHoldResponse)) {
            return false;
        }
        GetLegalHoldResponse other = (GetLegalHoldResponse)((Object)obj);
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.cancelDescription(), other.cancelDescription()) && Objects.equals(this.legalHoldId(), other.legalHoldId()) && Objects.equals(this.legalHoldArn(), other.legalHoldArn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.cancellationDate(), other.cancellationDate()) && Objects.equals(this.retainRecordUntil(), other.retainRecordUntil()) && Objects.equals(this.recoveryPointSelection(), other.recoveryPointSelection());
    }

    public final String toString() {
        return ToString.builder((String)"GetLegalHoldResponse").add("Title", (Object)this.title()).add("Status", (Object)this.statusAsString()).add("Description", (Object)this.description()).add("CancelDescription", (Object)this.cancelDescription()).add("LegalHoldId", (Object)this.legalHoldId()).add("LegalHoldArn", (Object)this.legalHoldArn()).add("CreationDate", (Object)this.creationDate()).add("CancellationDate", (Object)this.cancellationDate()).add("RetainRecordUntil", (Object)this.retainRecordUntil()).add("RecoveryPointSelection", (Object)this.recoveryPointSelection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CancelDescription": {
                return Optional.ofNullable(clazz.cast(this.cancelDescription()));
            }
            case "LegalHoldId": {
                return Optional.ofNullable(clazz.cast(this.legalHoldId()));
            }
            case "LegalHoldArn": {
                return Optional.ofNullable(clazz.cast(this.legalHoldArn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "CancellationDate": {
                return Optional.ofNullable(clazz.cast(this.cancellationDate()));
            }
            case "RetainRecordUntil": {
                return Optional.ofNullable(clazz.cast(this.retainRecordUntil()));
            }
            case "RecoveryPointSelection": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointSelection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetLegalHoldResponse, T> g) {
        return obj -> g.apply((GetLegalHoldResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String title;
        private String status;
        private String description;
        private String cancelDescription;
        private String legalHoldId;
        private String legalHoldArn;
        private Instant creationDate;
        private Instant cancellationDate;
        private Instant retainRecordUntil;
        private RecoveryPointSelection recoveryPointSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLegalHoldResponse model) {
            super(model);
            this.title(model.title);
            this.status(model.status);
            this.description(model.description);
            this.cancelDescription(model.cancelDescription);
            this.legalHoldId(model.legalHoldId);
            this.legalHoldArn(model.legalHoldArn);
            this.creationDate(model.creationDate);
            this.cancellationDate(model.cancellationDate);
            this.retainRecordUntil(model.retainRecordUntil);
            this.recoveryPointSelection(model.recoveryPointSelection);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LegalHoldStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCancelDescription() {
            return this.cancelDescription;
        }

        public final void setCancelDescription(String cancelDescription) {
            this.cancelDescription = cancelDescription;
        }

        @Override
        public final Builder cancelDescription(String cancelDescription) {
            this.cancelDescription = cancelDescription;
            return this;
        }

        public final String getLegalHoldId() {
            return this.legalHoldId;
        }

        public final void setLegalHoldId(String legalHoldId) {
            this.legalHoldId = legalHoldId;
        }

        @Override
        public final Builder legalHoldId(String legalHoldId) {
            this.legalHoldId = legalHoldId;
            return this;
        }

        public final String getLegalHoldArn() {
            return this.legalHoldArn;
        }

        public final void setLegalHoldArn(String legalHoldArn) {
            this.legalHoldArn = legalHoldArn;
        }

        @Override
        public final Builder legalHoldArn(String legalHoldArn) {
            this.legalHoldArn = legalHoldArn;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getCancellationDate() {
            return this.cancellationDate;
        }

        public final void setCancellationDate(Instant cancellationDate) {
            this.cancellationDate = cancellationDate;
        }

        @Override
        public final Builder cancellationDate(Instant cancellationDate) {
            this.cancellationDate = cancellationDate;
            return this;
        }

        public final Instant getRetainRecordUntil() {
            return this.retainRecordUntil;
        }

        public final void setRetainRecordUntil(Instant retainRecordUntil) {
            this.retainRecordUntil = retainRecordUntil;
        }

        @Override
        public final Builder retainRecordUntil(Instant retainRecordUntil) {
            this.retainRecordUntil = retainRecordUntil;
            return this;
        }

        public final RecoveryPointSelection.Builder getRecoveryPointSelection() {
            return this.recoveryPointSelection != null ? this.recoveryPointSelection.toBuilder() : null;
        }

        public final void setRecoveryPointSelection(RecoveryPointSelection.BuilderImpl recoveryPointSelection) {
            this.recoveryPointSelection = recoveryPointSelection != null ? recoveryPointSelection.build() : null;
        }

        @Override
        public final Builder recoveryPointSelection(RecoveryPointSelection recoveryPointSelection) {
            this.recoveryPointSelection = recoveryPointSelection;
            return this;
        }

        @Override
        public GetLegalHoldResponse build() {
            return new GetLegalHoldResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLegalHoldResponse> {
        public Builder title(String var1);

        public Builder status(String var1);

        public Builder status(LegalHoldStatus var1);

        public Builder description(String var1);

        public Builder cancelDescription(String var1);

        public Builder legalHoldId(String var1);

        public Builder legalHoldArn(String var1);

        public Builder creationDate(Instant var1);

        public Builder cancellationDate(Instant var1);

        public Builder retainRecordUntil(Instant var1);

        public Builder recoveryPointSelection(RecoveryPointSelection var1);

        default public Builder recoveryPointSelection(Consumer<RecoveryPointSelection.Builder> recoveryPointSelection) {
            return this.recoveryPointSelection((RecoveryPointSelection)((RecoveryPointSelection.Builder)RecoveryPointSelection.builder().applyMutation(recoveryPointSelection)).build());
        }
    }
}

