/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.BackupSelection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBackupSelectionResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, GetBackupSelectionResponse> {
    private static final SdkField<BackupSelection> BACKUP_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BackupSelection").getter(GetBackupSelectionResponse.getter(GetBackupSelectionResponse::backupSelection)).setter(GetBackupSelectionResponse.setter(Builder::backupSelection)).constructor(BackupSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSelection").build()}).build();
    private static final SdkField<String> SELECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectionId").getter(GetBackupSelectionResponse.getter(GetBackupSelectionResponse::selectionId)).setter(GetBackupSelectionResponse.setter(Builder::selectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionId").build()}).build();
    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupPlanId").getter(GetBackupSelectionResponse.getter(GetBackupSelectionResponse::backupPlanId)).setter(GetBackupSelectionResponse.setter(Builder::backupPlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanId").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(GetBackupSelectionResponse.getter(GetBackupSelectionResponse::creationDate)).setter(GetBackupSelectionResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(GetBackupSelectionResponse.getter(GetBackupSelectionResponse::creatorRequestId)).setter(GetBackupSelectionResponse.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_SELECTION_FIELD, SELECTION_ID_FIELD, BACKUP_PLAN_ID_FIELD, CREATION_DATE_FIELD, CREATOR_REQUEST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BackupSelection", BACKUP_SELECTION_FIELD);
            this.put("SelectionId", SELECTION_ID_FIELD);
            this.put("BackupPlanId", BACKUP_PLAN_ID_FIELD);
            this.put("CreationDate", CREATION_DATE_FIELD);
            this.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        }
    });
    private final BackupSelection backupSelection;
    private final String selectionId;
    private final String backupPlanId;
    private final Instant creationDate;
    private final String creatorRequestId;

    private GetBackupSelectionResponse(BuilderImpl builder) {
        super(builder);
        this.backupSelection = builder.backupSelection;
        this.selectionId = builder.selectionId;
        this.backupPlanId = builder.backupPlanId;
        this.creationDate = builder.creationDate;
        this.creatorRequestId = builder.creatorRequestId;
    }

    public final BackupSelection backupSelection() {
        return this.backupSelection;
    }

    public final String selectionId() {
        return this.selectionId;
    }

    public final String backupPlanId() {
        return this.backupPlanId;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSelection());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackupSelectionResponse)) {
            return false;
        }
        GetBackupSelectionResponse other = (GetBackupSelectionResponse)((Object)obj);
        return Objects.equals(this.backupSelection(), other.backupSelection()) && Objects.equals(this.selectionId(), other.selectionId()) && Objects.equals(this.backupPlanId(), other.backupPlanId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId());
    }

    public final String toString() {
        return ToString.builder((String)"GetBackupSelectionResponse").add("BackupSelection", (Object)this.backupSelection()).add("SelectionId", (Object)this.selectionId()).add("BackupPlanId", (Object)this.backupPlanId()).add("CreationDate", (Object)this.creationDate()).add("CreatorRequestId", (Object)this.creatorRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupSelection": {
                return Optional.ofNullable(clazz.cast(this.backupSelection()));
            }
            case "SelectionId": {
                return Optional.ofNullable(clazz.cast(this.selectionId()));
            }
            case "BackupPlanId": {
                return Optional.ofNullable(clazz.cast(this.backupPlanId()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetBackupSelectionResponse, T> g) {
        return obj -> g.apply((GetBackupSelectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private BackupSelection backupSelection;
        private String selectionId;
        private String backupPlanId;
        private Instant creationDate;
        private String creatorRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackupSelectionResponse model) {
            super(model);
            this.backupSelection(model.backupSelection);
            this.selectionId(model.selectionId);
            this.backupPlanId(model.backupPlanId);
            this.creationDate(model.creationDate);
            this.creatorRequestId(model.creatorRequestId);
        }

        public final BackupSelection.Builder getBackupSelection() {
            return this.backupSelection != null ? this.backupSelection.toBuilder() : null;
        }

        public final void setBackupSelection(BackupSelection.BuilderImpl backupSelection) {
            this.backupSelection = backupSelection != null ? backupSelection.build() : null;
        }

        @Override
        public final Builder backupSelection(BackupSelection backupSelection) {
            this.backupSelection = backupSelection;
            return this;
        }

        public final String getSelectionId() {
            return this.selectionId;
        }

        public final void setSelectionId(String selectionId) {
            this.selectionId = selectionId;
        }

        @Override
        public final Builder selectionId(String selectionId) {
            this.selectionId = selectionId;
            return this;
        }

        public final String getBackupPlanId() {
            return this.backupPlanId;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        @Override
        public GetBackupSelectionResponse build() {
            return new GetBackupSelectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBackupSelectionResponse> {
        public Builder backupSelection(BackupSelection var1);

        default public Builder backupSelection(Consumer<BackupSelection.Builder> backupSelection) {
            return this.backupSelection((BackupSelection)((BackupSelection.Builder)BackupSelection.builder().applyMutation(backupSelection)).build());
        }

        public Builder selectionId(String var1);

        public Builder backupPlanId(String var1);

        public Builder creationDate(Instant var1);

        public Builder creatorRequestId(String var1);
    }
}

