/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.GlobalSettingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGlobalSettingsRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, UpdateGlobalSettingsRequest> {
    private static final SdkField<Map<String, String>> GLOBAL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("GlobalSettings").getter(UpdateGlobalSettingsRequest.getter(UpdateGlobalSettingsRequest::globalSettings)).setter(UpdateGlobalSettingsRequest.setter(Builder::globalSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSettings").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_SETTINGS_FIELD));
    private final Map<String, String> globalSettings;

    private UpdateGlobalSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.globalSettings = builder.globalSettings;
    }

    public final boolean hasGlobalSettings() {
        return this.globalSettings != null && !(this.globalSettings instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> globalSettings() {
        return this.globalSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalSettings() ? this.globalSettings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalSettingsRequest)) {
            return false;
        }
        UpdateGlobalSettingsRequest other = (UpdateGlobalSettingsRequest)((Object)obj);
        return this.hasGlobalSettings() == other.hasGlobalSettings() && Objects.equals(this.globalSettings(), other.globalSettings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateGlobalSettingsRequest").add("GlobalSettings", this.hasGlobalSettings() ? this.globalSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalSettings": {
                return Optional.ofNullable(clazz.cast(this.globalSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGlobalSettingsRequest, T> g) {
        return obj -> g.apply((UpdateGlobalSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private Map<String, String> globalSettings = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalSettingsRequest model) {
            super(model);
            this.globalSettings(model.globalSettings);
        }

        public final Map<String, String> getGlobalSettings() {
            if (this.globalSettings instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.globalSettings;
        }

        public final void setGlobalSettings(Map<String, String> globalSettings) {
            this.globalSettings = GlobalSettingsCopier.copy(globalSettings);
        }

        @Override
        public final Builder globalSettings(Map<String, String> globalSettings) {
            this.globalSettings = GlobalSettingsCopier.copy(globalSettings);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGlobalSettingsRequest build() {
            return new UpdateGlobalSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGlobalSettingsRequest> {
        public Builder globalSettings(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

