/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsResponse;
import software.amazon.awssdk.services.backup.model.RestoreTestingSelectionForList;

public class ListRestoreTestingSelectionsIterable
implements SdkIterable<ListRestoreTestingSelectionsResponse> {
    private final BackupClient client;
    private final ListRestoreTestingSelectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRestoreTestingSelectionsIterable(BackupClient client, ListRestoreTestingSelectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRestoreTestingSelectionsResponseFetcher();
    }

    public Iterator<ListRestoreTestingSelectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RestoreTestingSelectionForList> restoreTestingSelections() {
        Function<ListRestoreTestingSelectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.restoreTestingSelections() != null) {
                return response.restoreTestingSelections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRestoreTestingSelectionsResponseFetcher
    implements SyncPageFetcher<ListRestoreTestingSelectionsResponse> {
        private ListRestoreTestingSelectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListRestoreTestingSelectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRestoreTestingSelectionsResponse nextPage(ListRestoreTestingSelectionsResponse previousPage) {
            if (previousPage == null) {
                return ListRestoreTestingSelectionsIterable.this.client.listRestoreTestingSelections(ListRestoreTestingSelectionsIterable.this.firstRequest);
            }
            return ListRestoreTestingSelectionsIterable.this.client.listRestoreTestingSelections((ListRestoreTestingSelectionsRequest)((Object)ListRestoreTestingSelectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

