/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.BackupPlansListMember;
import software.amazon.awssdk.services.backup.model.ListBackupPlansRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlansResponse;

public class ListBackupPlansIterable
implements SdkIterable<ListBackupPlansResponse> {
    private final BackupClient client;
    private final ListBackupPlansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBackupPlansIterable(BackupClient client, ListBackupPlansRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBackupPlansResponseFetcher();
    }

    public Iterator<ListBackupPlansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BackupPlansListMember> backupPlansList() {
        Function<ListBackupPlansResponse, Iterator> getIterator = response -> {
            if (response != null && response.backupPlansList() != null) {
                return response.backupPlansList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBackupPlansResponseFetcher
    implements SyncPageFetcher<ListBackupPlansResponse> {
        private ListBackupPlansResponseFetcher() {
        }

        public boolean hasNextPage(ListBackupPlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBackupPlansResponse nextPage(ListBackupPlansResponse previousPage) {
            if (previousPage == null) {
                return ListBackupPlansIterable.this.client.listBackupPlans(ListBackupPlansIterable.this.firstRequest);
            }
            return ListBackupPlansIterable.this.client.listBackupPlans((ListBackupPlansRequest)((Object)ListBackupPlansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

