/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.BackupClientBuilder;
import software.amazon.awssdk.services.backup.BackupServiceClientConfiguration;
import software.amazon.awssdk.services.backup.DefaultBackupBaseClientBuilder;
import software.amazon.awssdk.services.backup.DefaultBackupClient;
import software.amazon.awssdk.services.backup.endpoints.BackupEndpointProvider;

@SdkInternalApi
final class DefaultBackupClientBuilder
extends DefaultBackupBaseClientBuilder<BackupClientBuilder, BackupClient>
implements BackupClientBuilder {
    DefaultBackupClientBuilder() {
    }

    @Override
    public DefaultBackupClientBuilder endpointProvider(BackupEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BackupClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultBackupClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        BackupServiceClientConfiguration serviceClientConfiguration = BackupServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultBackupClient(serviceClientConfiguration, clientConfiguration);
    }
}

