/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.AdvancedBackupSetting;
import software.amazon.awssdk.services.backup.model.AdvancedBackupSettingsCopier;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBackupPlanResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, CreateBackupPlanResponse> {
    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupPlanId").getter(CreateBackupPlanResponse.getter(CreateBackupPlanResponse::backupPlanId)).setter(CreateBackupPlanResponse.setter(Builder::backupPlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanId").build()}).build();
    private static final SdkField<String> BACKUP_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupPlanArn").getter(CreateBackupPlanResponse.getter(CreateBackupPlanResponse::backupPlanArn)).setter(CreateBackupPlanResponse.setter(Builder::backupPlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(CreateBackupPlanResponse.getter(CreateBackupPlanResponse::creationDate)).setter(CreateBackupPlanResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionId").getter(CreateBackupPlanResponse.getter(CreateBackupPlanResponse::versionId)).setter(CreateBackupPlanResponse.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final SdkField<List<AdvancedBackupSetting>> ADVANCED_BACKUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdvancedBackupSettings").getter(CreateBackupPlanResponse.getter(CreateBackupPlanResponse::advancedBackupSettings)).setter(CreateBackupPlanResponse.setter(Builder::advancedBackupSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedBackupSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdvancedBackupSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_ID_FIELD, BACKUP_PLAN_ARN_FIELD, CREATION_DATE_FIELD, VERSION_ID_FIELD, ADVANCED_BACKUP_SETTINGS_FIELD));
    private final String backupPlanId;
    private final String backupPlanArn;
    private final Instant creationDate;
    private final String versionId;
    private final List<AdvancedBackupSetting> advancedBackupSettings;

    private CreateBackupPlanResponse(BuilderImpl builder) {
        super(builder);
        this.backupPlanId = builder.backupPlanId;
        this.backupPlanArn = builder.backupPlanArn;
        this.creationDate = builder.creationDate;
        this.versionId = builder.versionId;
        this.advancedBackupSettings = builder.advancedBackupSettings;
    }

    public final String backupPlanId() {
        return this.backupPlanId;
    }

    public final String backupPlanArn() {
        return this.backupPlanArn;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String versionId() {
        return this.versionId;
    }

    public final boolean hasAdvancedBackupSettings() {
        return this.advancedBackupSettings != null && !(this.advancedBackupSettings instanceof SdkAutoConstructList);
    }

    public final List<AdvancedBackupSetting> advancedBackupSettings() {
        return this.advancedBackupSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdvancedBackupSettings() ? this.advancedBackupSettings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackupPlanResponse)) {
            return false;
        }
        CreateBackupPlanResponse other = (CreateBackupPlanResponse)((Object)obj);
        return Objects.equals(this.backupPlanId(), other.backupPlanId()) && Objects.equals(this.backupPlanArn(), other.backupPlanArn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.versionId(), other.versionId()) && this.hasAdvancedBackupSettings() == other.hasAdvancedBackupSettings() && Objects.equals(this.advancedBackupSettings(), other.advancedBackupSettings());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBackupPlanResponse").add("BackupPlanId", (Object)this.backupPlanId()).add("BackupPlanArn", (Object)this.backupPlanArn()).add("CreationDate", (Object)this.creationDate()).add("VersionId", (Object)this.versionId()).add("AdvancedBackupSettings", this.hasAdvancedBackupSettings() ? this.advancedBackupSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupPlanId": {
                return Optional.ofNullable(clazz.cast(this.backupPlanId()));
            }
            case "BackupPlanArn": {
                return Optional.ofNullable(clazz.cast(this.backupPlanArn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "AdvancedBackupSettings": {
                return Optional.ofNullable(clazz.cast(this.advancedBackupSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackupPlanResponse, T> g) {
        return obj -> g.apply((CreateBackupPlanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String backupPlanId;
        private String backupPlanArn;
        private Instant creationDate;
        private String versionId;
        private List<AdvancedBackupSetting> advancedBackupSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackupPlanResponse model) {
            super(model);
            this.backupPlanId(model.backupPlanId);
            this.backupPlanArn(model.backupPlanArn);
            this.creationDate(model.creationDate);
            this.versionId(model.versionId);
            this.advancedBackupSettings(model.advancedBackupSettings);
        }

        public final String getBackupPlanId() {
            return this.backupPlanId;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final String getBackupPlanArn() {
            return this.backupPlanArn;
        }

        public final void setBackupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
        }

        @Override
        public final Builder backupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final List<AdvancedBackupSetting.Builder> getAdvancedBackupSettings() {
            List<AdvancedBackupSetting.Builder> result = AdvancedBackupSettingsCopier.copyToBuilder(this.advancedBackupSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdvancedBackupSettings(Collection<AdvancedBackupSetting.BuilderImpl> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copyFromBuilder(advancedBackupSettings);
        }

        @Override
        public final Builder advancedBackupSettings(Collection<AdvancedBackupSetting> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copy(advancedBackupSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(AdvancedBackupSetting ... advancedBackupSettings) {
            this.advancedBackupSettings(Arrays.asList(advancedBackupSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder> ... advancedBackupSettings) {
            this.advancedBackupSettings(Stream.of(advancedBackupSettings).map(c -> (AdvancedBackupSetting)((AdvancedBackupSetting.Builder)AdvancedBackupSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateBackupPlanResponse build() {
            return new CreateBackupPlanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBackupPlanResponse> {
        public Builder backupPlanId(String var1);

        public Builder backupPlanArn(String var1);

        public Builder creationDate(Instant var1);

        public Builder versionId(String var1);

        public Builder advancedBackupSettings(Collection<AdvancedBackupSetting> var1);

        public Builder advancedBackupSettings(AdvancedBackupSetting ... var1);

        public Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder> ... var1);
    }
}

