/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.Lifecycle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartCopyJobRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, StartCopyJobRequest> {
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryPointArn").getter(StartCopyJobRequest.getter(StartCopyJobRequest::recoveryPointArn)).setter(StartCopyJobRequest.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<String> SOURCE_BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceBackupVaultName").getter(StartCopyJobRequest.getter(StartCopyJobRequest::sourceBackupVaultName)).setter(StartCopyJobRequest.setter(Builder::sourceBackupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackupVaultName").build()}).build();
    private static final SdkField<String> DESTINATION_BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationBackupVaultArn").getter(StartCopyJobRequest.getter(StartCopyJobRequest::destinationBackupVaultArn)).setter(StartCopyJobRequest.setter(Builder::destinationBackupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationBackupVaultArn").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(StartCopyJobRequest.getter(StartCopyJobRequest::iamRoleArn)).setter(StartCopyJobRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(StartCopyJobRequest.getter(StartCopyJobRequest::idempotencyToken)).setter(StartCopyJobRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()}).build();
    private static final SdkField<Lifecycle> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Lifecycle").getter(StartCopyJobRequest.getter(StartCopyJobRequest::lifecycle)).setter(StartCopyJobRequest.setter(Builder::lifecycle)).constructor(Lifecycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_ARN_FIELD, SOURCE_BACKUP_VAULT_NAME_FIELD, DESTINATION_BACKUP_VAULT_ARN_FIELD, IAM_ROLE_ARN_FIELD, IDEMPOTENCY_TOKEN_FIELD, LIFECYCLE_FIELD));
    private final String recoveryPointArn;
    private final String sourceBackupVaultName;
    private final String destinationBackupVaultArn;
    private final String iamRoleArn;
    private final String idempotencyToken;
    private final Lifecycle lifecycle;

    private StartCopyJobRequest(BuilderImpl builder) {
        super(builder);
        this.recoveryPointArn = builder.recoveryPointArn;
        this.sourceBackupVaultName = builder.sourceBackupVaultName;
        this.destinationBackupVaultArn = builder.destinationBackupVaultArn;
        this.iamRoleArn = builder.iamRoleArn;
        this.idempotencyToken = builder.idempotencyToken;
        this.lifecycle = builder.lifecycle;
    }

    public final String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public final String sourceBackupVaultName() {
        return this.sourceBackupVaultName;
    }

    public final String destinationBackupVaultArn() {
        return this.destinationBackupVaultArn;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    public final Lifecycle lifecycle() {
        return this.lifecycle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBackupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycle());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCopyJobRequest)) {
            return false;
        }
        StartCopyJobRequest other = (StartCopyJobRequest)((Object)obj);
        return Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.sourceBackupVaultName(), other.sourceBackupVaultName()) && Objects.equals(this.destinationBackupVaultArn(), other.destinationBackupVaultArn()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && Objects.equals(this.lifecycle(), other.lifecycle());
    }

    public final String toString() {
        return ToString.builder((String)"StartCopyJobRequest").add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("SourceBackupVaultName", (Object)this.sourceBackupVaultName()).add("DestinationBackupVaultArn", (Object)this.destinationBackupVaultArn()).add("IamRoleArn", (Object)this.iamRoleArn()).add("IdempotencyToken", (Object)this.idempotencyToken()).add("Lifecycle", (Object)this.lifecycle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "SourceBackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.sourceBackupVaultName()));
            }
            case "DestinationBackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.destinationBackupVaultArn()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycle()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartCopyJobRequest, T> g) {
        return obj -> g.apply((StartCopyJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String recoveryPointArn;
        private String sourceBackupVaultName;
        private String destinationBackupVaultArn;
        private String iamRoleArn;
        private String idempotencyToken;
        private Lifecycle lifecycle;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCopyJobRequest model) {
            super(model);
            this.recoveryPointArn(model.recoveryPointArn);
            this.sourceBackupVaultName(model.sourceBackupVaultName);
            this.destinationBackupVaultArn(model.destinationBackupVaultArn);
            this.iamRoleArn(model.iamRoleArn);
            this.idempotencyToken(model.idempotencyToken);
            this.lifecycle(model.lifecycle);
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        public final String getSourceBackupVaultName() {
            return this.sourceBackupVaultName;
        }

        @Override
        public final Builder sourceBackupVaultName(String sourceBackupVaultName) {
            this.sourceBackupVaultName = sourceBackupVaultName;
            return this;
        }

        public final void setSourceBackupVaultName(String sourceBackupVaultName) {
            this.sourceBackupVaultName = sourceBackupVaultName;
        }

        public final String getDestinationBackupVaultArn() {
            return this.destinationBackupVaultArn;
        }

        @Override
        public final Builder destinationBackupVaultArn(String destinationBackupVaultArn) {
            this.destinationBackupVaultArn = destinationBackupVaultArn;
            return this;
        }

        public final void setDestinationBackupVaultArn(String destinationBackupVaultArn) {
            this.destinationBackupVaultArn = destinationBackupVaultArn;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public final Lifecycle.Builder getLifecycle() {
            return this.lifecycle != null ? this.lifecycle.toBuilder() : null;
        }

        @Override
        public final Builder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final void setLifecycle(Lifecycle.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCopyJobRequest build() {
            return new StartCopyJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartCopyJobRequest> {
        public Builder recoveryPointArn(String var1);

        public Builder sourceBackupVaultName(String var1);

        public Builder destinationBackupVaultArn(String var1);

        public Builder iamRoleArn(String var1);

        public Builder idempotencyToken(String var1);

        public Builder lifecycle(Lifecycle var1);

        default public Builder lifecycle(Consumer<Lifecycle.Builder> lifecycle) {
            return this.lifecycle((Lifecycle)((Lifecycle.Builder)Lifecycle.builder().applyMutation(lifecycle)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

