/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.AdvancedBackupSetting;
import software.amazon.awssdk.services.backup.model.AdvancedBackupSettingsCopier;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBackupPlanResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, UpdateBackupPlanResponse> {
    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupPlanId").getter(UpdateBackupPlanResponse.getter(UpdateBackupPlanResponse::backupPlanId)).setter(UpdateBackupPlanResponse.setter(Builder::backupPlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanId").build()}).build();
    private static final SdkField<String> BACKUP_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupPlanArn").getter(UpdateBackupPlanResponse.getter(UpdateBackupPlanResponse::backupPlanArn)).setter(UpdateBackupPlanResponse.setter(Builder::backupPlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(UpdateBackupPlanResponse.getter(UpdateBackupPlanResponse::creationDate)).setter(UpdateBackupPlanResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionId").getter(UpdateBackupPlanResponse.getter(UpdateBackupPlanResponse::versionId)).setter(UpdateBackupPlanResponse.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final SdkField<List<AdvancedBackupSetting>> ADVANCED_BACKUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdvancedBackupSettings").getter(UpdateBackupPlanResponse.getter(UpdateBackupPlanResponse::advancedBackupSettings)).setter(UpdateBackupPlanResponse.setter(Builder::advancedBackupSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedBackupSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdvancedBackupSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_ID_FIELD, BACKUP_PLAN_ARN_FIELD, CREATION_DATE_FIELD, VERSION_ID_FIELD, ADVANCED_BACKUP_SETTINGS_FIELD));
    private final String backupPlanId;
    private final String backupPlanArn;
    private final Instant creationDate;
    private final String versionId;
    private final List<AdvancedBackupSetting> advancedBackupSettings;

    private UpdateBackupPlanResponse(BuilderImpl builder) {
        super(builder);
        this.backupPlanId = builder.backupPlanId;
        this.backupPlanArn = builder.backupPlanArn;
        this.creationDate = builder.creationDate;
        this.versionId = builder.versionId;
        this.advancedBackupSettings = builder.advancedBackupSettings;
    }

    public String backupPlanId() {
        return this.backupPlanId;
    }

    public String backupPlanArn() {
        return this.backupPlanArn;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public String versionId() {
        return this.versionId;
    }

    public boolean hasAdvancedBackupSettings() {
        return this.advancedBackupSettings != null && !(this.advancedBackupSettings instanceof SdkAutoConstructList);
    }

    public List<AdvancedBackupSetting> advancedBackupSettings() {
        return this.advancedBackupSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedBackupSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBackupPlanResponse)) {
            return false;
        }
        UpdateBackupPlanResponse other = (UpdateBackupPlanResponse)((Object)obj);
        return Objects.equals(this.backupPlanId(), other.backupPlanId()) && Objects.equals(this.backupPlanArn(), other.backupPlanArn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.advancedBackupSettings(), other.advancedBackupSettings());
    }

    public String toString() {
        return ToString.builder((String)"UpdateBackupPlanResponse").add("BackupPlanId", (Object)this.backupPlanId()).add("BackupPlanArn", (Object)this.backupPlanArn()).add("CreationDate", (Object)this.creationDate()).add("VersionId", (Object)this.versionId()).add("AdvancedBackupSettings", this.advancedBackupSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupPlanId": {
                return Optional.ofNullable(clazz.cast(this.backupPlanId()));
            }
            case "BackupPlanArn": {
                return Optional.ofNullable(clazz.cast(this.backupPlanArn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "AdvancedBackupSettings": {
                return Optional.ofNullable(clazz.cast(this.advancedBackupSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBackupPlanResponse, T> g) {
        return obj -> g.apply((UpdateBackupPlanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String backupPlanId;
        private String backupPlanArn;
        private Instant creationDate;
        private String versionId;
        private List<AdvancedBackupSetting> advancedBackupSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBackupPlanResponse model) {
            super(model);
            this.backupPlanId(model.backupPlanId);
            this.backupPlanArn(model.backupPlanArn);
            this.creationDate(model.creationDate);
            this.versionId(model.versionId);
            this.advancedBackupSettings(model.advancedBackupSettings);
        }

        public final String getBackupPlanId() {
            return this.backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        public final String getBackupPlanArn() {
            return this.backupPlanArn;
        }

        @Override
        public final Builder backupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
            return this;
        }

        public final void setBackupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Collection<AdvancedBackupSetting.Builder> getAdvancedBackupSettings() {
            return this.advancedBackupSettings != null ? (Collection)this.advancedBackupSettings.stream().map(AdvancedBackupSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder advancedBackupSettings(Collection<AdvancedBackupSetting> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copy(advancedBackupSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(AdvancedBackupSetting ... advancedBackupSettings) {
            this.advancedBackupSettings(Arrays.asList(advancedBackupSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder> ... advancedBackupSettings) {
            this.advancedBackupSettings(Stream.of(advancedBackupSettings).map(c -> (AdvancedBackupSetting)((AdvancedBackupSetting.Builder)AdvancedBackupSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdvancedBackupSettings(Collection<AdvancedBackupSetting.BuilderImpl> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copyFromBuilder(advancedBackupSettings);
        }

        @Override
        public UpdateBackupPlanResponse build() {
            return new UpdateBackupPlanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBackupPlanResponse> {
        public Builder backupPlanId(String var1);

        public Builder backupPlanArn(String var1);

        public Builder creationDate(Instant var1);

        public Builder versionId(String var1);

        public Builder advancedBackupSettings(Collection<AdvancedBackupSetting> var1);

        public Builder advancedBackupSettings(AdvancedBackupSetting ... var1);

        public Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder> ... var1);
    }
}

