/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.RestoreJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreJobsListMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RestoreJobsListMember> {
    private static final SdkField<String> RESTORE_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RestoreJobsListMember.getter(RestoreJobsListMember::restoreJobId)).setter(RestoreJobsListMember.setter(Builder::restoreJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreJobId").build()}).build();
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RestoreJobsListMember.getter(RestoreJobsListMember::recoveryPointArn)).setter(RestoreJobsListMember.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RestoreJobsListMember.getter(RestoreJobsListMember::creationDate)).setter(RestoreJobsListMember.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RestoreJobsListMember.getter(RestoreJobsListMember::completionDate)).setter(RestoreJobsListMember.setter(Builder::completionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RestoreJobsListMember.getter(RestoreJobsListMember::statusAsString)).setter(RestoreJobsListMember.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RestoreJobsListMember.getter(RestoreJobsListMember::statusMessage)).setter(RestoreJobsListMember.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> PERCENT_DONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RestoreJobsListMember.getter(RestoreJobsListMember::percentDone)).setter(RestoreJobsListMember.setter(Builder::percentDone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentDone").build()}).build();
    private static final SdkField<Long> BACKUP_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(RestoreJobsListMember.getter(RestoreJobsListMember::backupSizeInBytes)).setter(RestoreJobsListMember.setter(Builder::backupSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeInBytes").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RestoreJobsListMember.getter(RestoreJobsListMember::iamRoleArn)).setter(RestoreJobsListMember.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<Long> EXPECTED_COMPLETION_TIME_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(RestoreJobsListMember.getter(RestoreJobsListMember::expectedCompletionTimeMinutes)).setter(RestoreJobsListMember.setter(Builder::expectedCompletionTimeMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedCompletionTimeMinutes").build()}).build();
    private static final SdkField<String> CREATED_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RestoreJobsListMember.getter(RestoreJobsListMember::createdResourceArn)).setter(RestoreJobsListMember.setter(Builder::createdResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedResourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTORE_JOB_ID_FIELD, RECOVERY_POINT_ARN_FIELD, CREATION_DATE_FIELD, COMPLETION_DATE_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, PERCENT_DONE_FIELD, BACKUP_SIZE_IN_BYTES_FIELD, IAM_ROLE_ARN_FIELD, EXPECTED_COMPLETION_TIME_MINUTES_FIELD, CREATED_RESOURCE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String restoreJobId;
    private final String recoveryPointArn;
    private final Instant creationDate;
    private final Instant completionDate;
    private final String status;
    private final String statusMessage;
    private final String percentDone;
    private final Long backupSizeInBytes;
    private final String iamRoleArn;
    private final Long expectedCompletionTimeMinutes;
    private final String createdResourceArn;

    private RestoreJobsListMember(BuilderImpl builder) {
        this.restoreJobId = builder.restoreJobId;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.creationDate = builder.creationDate;
        this.completionDate = builder.completionDate;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.percentDone = builder.percentDone;
        this.backupSizeInBytes = builder.backupSizeInBytes;
        this.iamRoleArn = builder.iamRoleArn;
        this.expectedCompletionTimeMinutes = builder.expectedCompletionTimeMinutes;
        this.createdResourceArn = builder.createdResourceArn;
    }

    public String restoreJobId() {
        return this.restoreJobId;
    }

    public String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant completionDate() {
        return this.completionDate;
    }

    public RestoreJobStatus status() {
        return RestoreJobStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String percentDone() {
        return this.percentDone;
    }

    public Long backupSizeInBytes() {
        return this.backupSizeInBytes;
    }

    public String iamRoleArn() {
        return this.iamRoleArn;
    }

    public Long expectedCompletionTimeMinutes() {
        return this.expectedCompletionTimeMinutes;
    }

    public String createdResourceArn() {
        return this.createdResourceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentDone());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedCompletionTimeMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdResourceArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreJobsListMember)) {
            return false;
        }
        RestoreJobsListMember other = (RestoreJobsListMember)obj;
        return Objects.equals(this.restoreJobId(), other.restoreJobId()) && Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.completionDate(), other.completionDate()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.percentDone(), other.percentDone()) && Objects.equals(this.backupSizeInBytes(), other.backupSizeInBytes()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.expectedCompletionTimeMinutes(), other.expectedCompletionTimeMinutes()) && Objects.equals(this.createdResourceArn(), other.createdResourceArn());
    }

    public String toString() {
        return ToString.builder((String)"RestoreJobsListMember").add("RestoreJobId", (Object)this.restoreJobId()).add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("CreationDate", (Object)this.creationDate()).add("CompletionDate", (Object)this.completionDate()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("PercentDone", (Object)this.percentDone()).add("BackupSizeInBytes", (Object)this.backupSizeInBytes()).add("IamRoleArn", (Object)this.iamRoleArn()).add("ExpectedCompletionTimeMinutes", (Object)this.expectedCompletionTimeMinutes()).add("CreatedResourceArn", (Object)this.createdResourceArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RestoreJobId": {
                return Optional.ofNullable(clazz.cast(this.restoreJobId()));
            }
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "CompletionDate": {
                return Optional.ofNullable(clazz.cast(this.completionDate()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "PercentDone": {
                return Optional.ofNullable(clazz.cast(this.percentDone()));
            }
            case "BackupSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.backupSizeInBytes()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "ExpectedCompletionTimeMinutes": {
                return Optional.ofNullable(clazz.cast(this.expectedCompletionTimeMinutes()));
            }
            case "CreatedResourceArn": {
                return Optional.ofNullable(clazz.cast(this.createdResourceArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreJobsListMember, T> g) {
        return obj -> g.apply((RestoreJobsListMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String restoreJobId;
        private String recoveryPointArn;
        private Instant creationDate;
        private Instant completionDate;
        private String status;
        private String statusMessage;
        private String percentDone;
        private Long backupSizeInBytes;
        private String iamRoleArn;
        private Long expectedCompletionTimeMinutes;
        private String createdResourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreJobsListMember model) {
            this.restoreJobId(model.restoreJobId);
            this.recoveryPointArn(model.recoveryPointArn);
            this.creationDate(model.creationDate);
            this.completionDate(model.completionDate);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.percentDone(model.percentDone);
            this.backupSizeInBytes(model.backupSizeInBytes);
            this.iamRoleArn(model.iamRoleArn);
            this.expectedCompletionTimeMinutes(model.expectedCompletionTimeMinutes);
            this.createdResourceArn(model.createdResourceArn);
        }

        public final String getRestoreJobId() {
            return this.restoreJobId;
        }

        @Override
        public final Builder restoreJobId(String restoreJobId) {
            this.restoreJobId = restoreJobId;
            return this;
        }

        public final void setRestoreJobId(String restoreJobId) {
            this.restoreJobId = restoreJobId;
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getCompletionDate() {
            return this.completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RestoreJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getPercentDone() {
            return this.percentDone;
        }

        @Override
        public final Builder percentDone(String percentDone) {
            this.percentDone = percentDone;
            return this;
        }

        public final void setPercentDone(String percentDone) {
            this.percentDone = percentDone;
        }

        public final Long getBackupSizeInBytes() {
            return this.backupSizeInBytes;
        }

        @Override
        public final Builder backupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
            return this;
        }

        public final void setBackupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final Long getExpectedCompletionTimeMinutes() {
            return this.expectedCompletionTimeMinutes;
        }

        @Override
        public final Builder expectedCompletionTimeMinutes(Long expectedCompletionTimeMinutes) {
            this.expectedCompletionTimeMinutes = expectedCompletionTimeMinutes;
            return this;
        }

        public final void setExpectedCompletionTimeMinutes(Long expectedCompletionTimeMinutes) {
            this.expectedCompletionTimeMinutes = expectedCompletionTimeMinutes;
        }

        public final String getCreatedResourceArn() {
            return this.createdResourceArn;
        }

        @Override
        public final Builder createdResourceArn(String createdResourceArn) {
            this.createdResourceArn = createdResourceArn;
            return this;
        }

        public final void setCreatedResourceArn(String createdResourceArn) {
            this.createdResourceArn = createdResourceArn;
        }

        public RestoreJobsListMember build() {
            return new RestoreJobsListMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RestoreJobsListMember> {
        public Builder restoreJobId(String var1);

        public Builder recoveryPointArn(String var1);

        public Builder creationDate(Instant var1);

        public Builder completionDate(Instant var1);

        public Builder status(String var1);

        public Builder status(RestoreJobStatus var1);

        public Builder statusMessage(String var1);

        public Builder percentDone(String var1);

        public Builder backupSizeInBytes(Long var1);

        public Builder iamRoleArn(String var1);

        public Builder expectedCompletionTimeMinutes(Long var1);

        public Builder createdResourceArn(String var1);
    }
}

