/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBackupPlanVersionsResponse extends BackupResponse implements
        ToCopyableBuilder<ListBackupPlanVersionsResponse.Builder, ListBackupPlanVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListBackupPlanVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<BackupPlansListMember>> BACKUP_PLAN_VERSIONS_LIST_FIELD = SdkField
            .<List<BackupPlansListMember>> builder(MarshallingType.LIST)
            .getter(getter(ListBackupPlanVersionsResponse::backupPlanVersionsList))
            .setter(setter(Builder::backupPlanVersionsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanVersionsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BackupPlansListMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(BackupPlansListMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            BACKUP_PLAN_VERSIONS_LIST_FIELD));

    private final String nextToken;

    private final List<BackupPlansListMember> backupPlanVersionsList;

    private ListBackupPlanVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.backupPlanVersionsList = builder.backupPlanVersionsList;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the BackupPlanVersionsList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasBackupPlanVersionsList() {
        return backupPlanVersionsList != null && !(backupPlanVersionsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of version list items containing metadata about your backup plans.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBackupPlanVersionsList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of version list items containing metadata about your backup plans.
     */
    public List<BackupPlansListMember> backupPlanVersionsList() {
        return backupPlanVersionsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanVersionsList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupPlanVersionsResponse)) {
            return false;
        }
        ListBackupPlanVersionsResponse other = (ListBackupPlanVersionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(backupPlanVersionsList(), other.backupPlanVersionsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListBackupPlanVersionsResponse").add("NextToken", nextToken())
                .add("BackupPlanVersionsList", backupPlanVersionsList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "BackupPlanVersionsList":
            return Optional.ofNullable(clazz.cast(backupPlanVersionsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBackupPlanVersionsResponse, T> g) {
        return obj -> g.apply((ListBackupPlanVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBackupPlanVersionsResponse> {
        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of version list items containing metadata about your backup plans.
         * </p>
         * 
         * @param backupPlanVersionsList
         *        An array of version list items containing metadata about your backup plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanVersionsList(Collection<BackupPlansListMember> backupPlanVersionsList);

        /**
         * <p>
         * An array of version list items containing metadata about your backup plans.
         * </p>
         * 
         * @param backupPlanVersionsList
         *        An array of version list items containing metadata about your backup plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanVersionsList(BackupPlansListMember... backupPlanVersionsList);

        /**
         * <p>
         * An array of version list items containing metadata about your backup plans.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BackupPlansListMember>.Builder} avoiding
         * the need to create one manually via {@link List<BackupPlansListMember>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BackupPlansListMember>.Builder#build()} is called
         * immediately and its result is passed to {@link #backupPlanVersionsList(List<BackupPlansListMember>)}.
         * 
         * @param backupPlanVersionsList
         *        a consumer that will call methods on {@link List<BackupPlansListMember>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupPlanVersionsList(List<BackupPlansListMember>)
         */
        Builder backupPlanVersionsList(Consumer<BackupPlansListMember.Builder>... backupPlanVersionsList);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<BackupPlansListMember> backupPlanVersionsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupPlanVersionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            backupPlanVersionsList(model.backupPlanVersionsList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<BackupPlansListMember.Builder> getBackupPlanVersionsList() {
            return backupPlanVersionsList != null ? backupPlanVersionsList.stream().map(BackupPlansListMember::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder backupPlanVersionsList(Collection<BackupPlansListMember> backupPlanVersionsList) {
            this.backupPlanVersionsList = BackupPlanVersionsListCopier.copy(backupPlanVersionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupPlanVersionsList(BackupPlansListMember... backupPlanVersionsList) {
            backupPlanVersionsList(Arrays.asList(backupPlanVersionsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupPlanVersionsList(Consumer<BackupPlansListMember.Builder>... backupPlanVersionsList) {
            backupPlanVersionsList(Stream.of(backupPlanVersionsList)
                    .map(c -> BackupPlansListMember.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBackupPlanVersionsList(Collection<BackupPlansListMember.BuilderImpl> backupPlanVersionsList) {
            this.backupPlanVersionsList = BackupPlanVersionsListCopier.copyFromBuilder(backupPlanVersionsList);
        }

        @Override
        public ListBackupPlanVersionsResponse build() {
            return new ListBackupPlanVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
