/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains options for splitting X12 EDI files into smaller units. This is useful for processing large EDI files more
 * efficiently.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class X12SplitOptions implements SdkPojo, Serializable, ToCopyableBuilder<X12SplitOptions.Builder, X12SplitOptions> {
    private static final SdkField<String> SPLIT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("splitBy").getter(getter(X12SplitOptions::splitByAsString)).setter(setter(Builder::splitBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("splitBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPLIT_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String splitBy;

    private X12SplitOptions(BuilderImpl builder) {
        this.splitBy = builder.splitBy;
    }

    /**
     * <p>
     * Specifies the method used to split X12 EDI files. Valid values include <code>TRANSACTION</code> (split by
     * individual transaction sets), or <code>NONE</code> (no splitting).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #splitBy} will
     * return {@link X12SplitBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #splitByAsString}.
     * </p>
     * 
     * @return Specifies the method used to split X12 EDI files. Valid values include <code>TRANSACTION</code> (split by
     *         individual transaction sets), or <code>NONE</code> (no splitting).
     * @see X12SplitBy
     */
    public final X12SplitBy splitBy() {
        return X12SplitBy.fromValue(splitBy);
    }

    /**
     * <p>
     * Specifies the method used to split X12 EDI files. Valid values include <code>TRANSACTION</code> (split by
     * individual transaction sets), or <code>NONE</code> (no splitting).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #splitBy} will
     * return {@link X12SplitBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #splitByAsString}.
     * </p>
     * 
     * @return Specifies the method used to split X12 EDI files. Valid values include <code>TRANSACTION</code> (split by
     *         individual transaction sets), or <code>NONE</code> (no splitting).
     * @see X12SplitBy
     */
    public final String splitByAsString() {
        return splitBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(splitByAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12SplitOptions)) {
            return false;
        }
        X12SplitOptions other = (X12SplitOptions) obj;
        return Objects.equals(splitByAsString(), other.splitByAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("X12SplitOptions").add("SplitBy", splitByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "splitBy":
            return Optional.ofNullable(clazz.cast(splitByAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("splitBy", SPLIT_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12SplitOptions, T> g) {
        return obj -> g.apply((X12SplitOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, X12SplitOptions> {
        /**
         * <p>
         * Specifies the method used to split X12 EDI files. Valid values include <code>TRANSACTION</code> (split by
         * individual transaction sets), or <code>NONE</code> (no splitting).
         * </p>
         * 
         * @param splitBy
         *        Specifies the method used to split X12 EDI files. Valid values include <code>TRANSACTION</code> (split
         *        by individual transaction sets), or <code>NONE</code> (no splitting).
         * @see X12SplitBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see X12SplitBy
         */
        Builder splitBy(String splitBy);

        /**
         * <p>
         * Specifies the method used to split X12 EDI files. Valid values include <code>TRANSACTION</code> (split by
         * individual transaction sets), or <code>NONE</code> (no splitting).
         * </p>
         * 
         * @param splitBy
         *        Specifies the method used to split X12 EDI files. Valid values include <code>TRANSACTION</code> (split
         *        by individual transaction sets), or <code>NONE</code> (no splitting).
         * @see X12SplitBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see X12SplitBy
         */
        Builder splitBy(X12SplitBy splitBy);
    }

    static final class BuilderImpl implements Builder {
        private String splitBy;

        private BuilderImpl() {
        }

        private BuilderImpl(X12SplitOptions model) {
            splitBy(model.splitBy);
        }

        public final String getSplitBy() {
            return splitBy;
        }

        public final void setSplitBy(String splitBy) {
            this.splitBy = splitBy;
        }

        @Override
        public final Builder splitBy(String splitBy) {
            this.splitBy = splitBy;
            return this;
        }

        @Override
        public final Builder splitBy(X12SplitBy splitBy) {
            this.splitBy(splitBy == null ? null : splitBy.toString());
            return this;
        }

        @Override
        public X12SplitOptions build() {
            return new X12SplitOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
