/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * Specifies the time format in the GS05 element (time) of the functional group header. The following formats use
 * 24-hour clock time:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>HHMM</code> - Hours and minutes
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>HHMMSS</code> - Hours, minutes, and seconds
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>HHMMSSDD</code> - Hours, minutes, seconds, and decimal seconds
 * </p>
 * </li>
 * </ul>
 * <p>
 * Where:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>HH</code> - Hours (00-23)
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>MM</code> - Minutes (00-59)
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>SS</code> - Seconds (00-59)
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DD</code> - Hundredths of seconds (00-99)
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public enum X12GS05TimeFormat {
    HHMM("HHMM"),

    HHMMSS("HHMMSS"),

    HHMMSSDD("HHMMSSDD"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, X12GS05TimeFormat> VALUE_MAP = EnumUtils.uniqueIndex(X12GS05TimeFormat.class,
            X12GS05TimeFormat::toString);

    private final String value;

    private X12GS05TimeFormat(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return X12GS05TimeFormat corresponding to the value
     */
    public static X12GS05TimeFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link X12GS05TimeFormat}s
     */
    public static Set<X12GS05TimeFormat> knownValues() {
        Set<X12GS05TimeFormat> knownValues = EnumSet.allOf(X12GS05TimeFormat.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
