/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a validation rule that specifies custom length constraints for a specific X12 element. This rule allows you
 * to override the standard minimum and maximum length requirements for an element, enabling validation of trading
 * partner-specific length requirements that may differ from the X12 specification. Both minimum and maximum length
 * values must be specified and must be between 1 and 200 characters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class X12ElementLengthValidationRule implements SdkPojo, Serializable,
        ToCopyableBuilder<X12ElementLengthValidationRule.Builder, X12ElementLengthValidationRule> {
    private static final SdkField<String> ELEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("elementId").getter(getter(X12ElementLengthValidationRule::elementId)).setter(setter(Builder::elementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elementId").build()).build();

    private static final SdkField<Integer> MAX_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxLength").getter(getter(X12ElementLengthValidationRule::maxLength)).setter(setter(Builder::maxLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLength").build()).build();

    private static final SdkField<Integer> MIN_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minLength").getter(getter(X12ElementLengthValidationRule::minLength)).setter(setter(Builder::minLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minLength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEMENT_ID_FIELD,
            MAX_LENGTH_FIELD, MIN_LENGTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String elementId;

    private final Integer maxLength;

    private final Integer minLength;

    private X12ElementLengthValidationRule(BuilderImpl builder) {
        this.elementId = builder.elementId;
        this.maxLength = builder.maxLength;
        this.minLength = builder.minLength;
    }

    /**
     * <p>
     * Specifies the four-digit element ID to which the length constraints will be applied. This identifies which X12
     * element will have its length requirements modified.
     * </p>
     * 
     * @return Specifies the four-digit element ID to which the length constraints will be applied. This identifies
     *         which X12 element will have its length requirements modified.
     */
    public final String elementId() {
        return elementId;
    }

    /**
     * <p>
     * Specifies the maximum allowed length for the identified element. This value must be between 1 and 200 characters
     * and defines the upper limit for the element's content length.
     * </p>
     * 
     * @return Specifies the maximum allowed length for the identified element. This value must be between 1 and 200
     *         characters and defines the upper limit for the element's content length.
     */
    public final Integer maxLength() {
        return maxLength;
    }

    /**
     * <p>
     * Specifies the minimum required length for the identified element. This value must be between 1 and 200 characters
     * and defines the lower limit for the element's content length.
     * </p>
     * 
     * @return Specifies the minimum required length for the identified element. This value must be between 1 and 200
     *         characters and defines the lower limit for the element's content length.
     */
    public final Integer minLength() {
        return minLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elementId());
        hashCode = 31 * hashCode + Objects.hashCode(maxLength());
        hashCode = 31 * hashCode + Objects.hashCode(minLength());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12ElementLengthValidationRule)) {
            return false;
        }
        X12ElementLengthValidationRule other = (X12ElementLengthValidationRule) obj;
        return Objects.equals(elementId(), other.elementId()) && Objects.equals(maxLength(), other.maxLength())
                && Objects.equals(minLength(), other.minLength());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("X12ElementLengthValidationRule").add("ElementId", elementId()).add("MaxLength", maxLength())
                .add("MinLength", minLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "elementId":
            return Optional.ofNullable(clazz.cast(elementId()));
        case "maxLength":
            return Optional.ofNullable(clazz.cast(maxLength()));
        case "minLength":
            return Optional.ofNullable(clazz.cast(minLength()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("elementId", ELEMENT_ID_FIELD);
        map.put("maxLength", MAX_LENGTH_FIELD);
        map.put("minLength", MIN_LENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12ElementLengthValidationRule, T> g) {
        return obj -> g.apply((X12ElementLengthValidationRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, X12ElementLengthValidationRule> {
        /**
         * <p>
         * Specifies the four-digit element ID to which the length constraints will be applied. This identifies which
         * X12 element will have its length requirements modified.
         * </p>
         * 
         * @param elementId
         *        Specifies the four-digit element ID to which the length constraints will be applied. This identifies
         *        which X12 element will have its length requirements modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elementId(String elementId);

        /**
         * <p>
         * Specifies the maximum allowed length for the identified element. This value must be between 1 and 200
         * characters and defines the upper limit for the element's content length.
         * </p>
         * 
         * @param maxLength
         *        Specifies the maximum allowed length for the identified element. This value must be between 1 and 200
         *        characters and defines the upper limit for the element's content length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLength(Integer maxLength);

        /**
         * <p>
         * Specifies the minimum required length for the identified element. This value must be between 1 and 200
         * characters and defines the lower limit for the element's content length.
         * </p>
         * 
         * @param minLength
         *        Specifies the minimum required length for the identified element. This value must be between 1 and 200
         *        characters and defines the lower limit for the element's content length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minLength(Integer minLength);
    }

    static final class BuilderImpl implements Builder {
        private String elementId;

        private Integer maxLength;

        private Integer minLength;

        private BuilderImpl() {
        }

        private BuilderImpl(X12ElementLengthValidationRule model) {
            elementId(model.elementId);
            maxLength(model.maxLength);
            minLength(model.minLength);
        }

        public final String getElementId() {
            return elementId;
        }

        public final void setElementId(String elementId) {
            this.elementId = elementId;
        }

        @Override
        public final Builder elementId(String elementId) {
            this.elementId = elementId;
            return this;
        }

        public final Integer getMaxLength() {
            return maxLength;
        }

        public final void setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public final Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public final Integer getMinLength() {
            return minLength;
        }

        public final void setMinLength(Integer minLength) {
            this.minLength = minLength;
        }

        @Override
        public final Builder minLength(Integer minLength) {
            this.minLength = minLength;
            return this;
        }

        @Override
        public X12ElementLengthValidationRule build() {
            return new X12ElementLengthValidationRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
