/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTransformerJobRequest extends B2BiRequest implements
        ToCopyableBuilder<StartTransformerJobRequest.Builder, StartTransformerJobRequest> {
    private static final SdkField<S3Location> INPUT_FILE_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("inputFile").getter(getter(StartTransformerJobRequest::inputFile)).setter(setter(Builder::inputFile))
            .constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFile").build()).build();

    private static final SdkField<S3Location> OUTPUT_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("outputLocation").getter(getter(StartTransformerJobRequest::outputLocation))
            .setter(setter(Builder::outputLocation)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()).build();

    private static final SdkField<String> TRANSFORMER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transformerId").getter(getter(StartTransformerJobRequest::transformerId))
            .setter(setter(Builder::transformerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(StartTransformerJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FILE_FIELD,
            OUTPUT_LOCATION_FIELD, TRANSFORMER_ID_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final S3Location inputFile;

    private final S3Location outputLocation;

    private final String transformerId;

    private final String clientToken;

    private StartTransformerJobRequest(BuilderImpl builder) {
        super(builder);
        this.inputFile = builder.inputFile;
        this.outputLocation = builder.outputLocation;
        this.transformerId = builder.transformerId;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Specifies the location of the input file for the transformation. The location consists of an Amazon S3 bucket and
     * prefix.
     * </p>
     * 
     * @return Specifies the location of the input file for the transformation. The location consists of an Amazon S3
     *         bucket and prefix.
     */
    public final S3Location inputFile() {
        return inputFile;
    }

    /**
     * <p>
     * Specifies the location of the output file for the transformation. The location consists of an Amazon S3 bucket
     * and prefix.
     * </p>
     * 
     * @return Specifies the location of the output file for the transformation. The location consists of an Amazon S3
     *         bucket and prefix.
     */
    public final S3Location outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * Specifies the system-assigned unique identifier for the transformer.
     * </p>
     * 
     * @return Specifies the system-assigned unique identifier for the transformer.
     */
    public final String transformerId() {
        return transformerId;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inputFile());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(transformerId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTransformerJobRequest)) {
            return false;
        }
        StartTransformerJobRequest other = (StartTransformerJobRequest) obj;
        return Objects.equals(inputFile(), other.inputFile()) && Objects.equals(outputLocation(), other.outputLocation())
                && Objects.equals(transformerId(), other.transformerId()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTransformerJobRequest").add("InputFile", inputFile())
                .add("OutputLocation", outputLocation()).add("TransformerId", transformerId()).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputFile":
            return Optional.ofNullable(clazz.cast(inputFile()));
        case "outputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "transformerId":
            return Optional.ofNullable(clazz.cast(transformerId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputFile", INPUT_FILE_FIELD);
        map.put("outputLocation", OUTPUT_LOCATION_FIELD);
        map.put("transformerId", TRANSFORMER_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTransformerJobRequest, T> g) {
        return obj -> g.apply((StartTransformerJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends B2BiRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartTransformerJobRequest> {
        /**
         * <p>
         * Specifies the location of the input file for the transformation. The location consists of an Amazon S3 bucket
         * and prefix.
         * </p>
         * 
         * @param inputFile
         *        Specifies the location of the input file for the transformation. The location consists of an Amazon S3
         *        bucket and prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputFile(S3Location inputFile);

        /**
         * <p>
         * Specifies the location of the input file for the transformation. The location consists of an Amazon S3 bucket
         * and prefix.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #inputFile(S3Location)}.
         * 
         * @param inputFile
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputFile(S3Location)
         */
        default Builder inputFile(Consumer<S3Location.Builder> inputFile) {
            return inputFile(S3Location.builder().applyMutation(inputFile).build());
        }

        /**
         * <p>
         * Specifies the location of the output file for the transformation. The location consists of an Amazon S3
         * bucket and prefix.
         * </p>
         * 
         * @param outputLocation
         *        Specifies the location of the output file for the transformation. The location consists of an Amazon
         *        S3 bucket and prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(S3Location outputLocation);

        /**
         * <p>
         * Specifies the location of the output file for the transformation. The location consists of an Amazon S3
         * bucket and prefix.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #outputLocation(S3Location)}.
         * 
         * @param outputLocation
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputLocation(S3Location)
         */
        default Builder outputLocation(Consumer<S3Location.Builder> outputLocation) {
            return outputLocation(S3Location.builder().applyMutation(outputLocation).build());
        }

        /**
         * <p>
         * Specifies the system-assigned unique identifier for the transformer.
         * </p>
         * 
         * @param transformerId
         *        Specifies the system-assigned unique identifier for the transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformerId(String transformerId);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param clientToken
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends B2BiRequest.BuilderImpl implements Builder {
        private S3Location inputFile;

        private S3Location outputLocation;

        private String transformerId;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTransformerJobRequest model) {
            super(model);
            inputFile(model.inputFile);
            outputLocation(model.outputLocation);
            transformerId(model.transformerId);
            clientToken(model.clientToken);
        }

        public final S3Location.Builder getInputFile() {
            return inputFile != null ? inputFile.toBuilder() : null;
        }

        public final void setInputFile(S3Location.BuilderImpl inputFile) {
            this.inputFile = inputFile != null ? inputFile.build() : null;
        }

        @Override
        public final Builder inputFile(S3Location inputFile) {
            this.inputFile = inputFile;
            return this;
        }

        public final S3Location.Builder getOutputLocation() {
            return outputLocation != null ? outputLocation.toBuilder() : null;
        }

        public final void setOutputLocation(S3Location.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        public final Builder outputLocation(S3Location outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final String getTransformerId() {
            return transformerId;
        }

        public final void setTransformerId(String transformerId) {
            this.transformerId = transformerId;
        }

        @Override
        public final Builder transformerId(String transformerId) {
            this.transformerId = transformerId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTransformerJobRequest build() {
            return new StartTransformerJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
