/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for outbound EDI options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutboundEdiOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<OutboundEdiOptions.Builder, OutboundEdiOptions> {
    private static final SdkField<X12Envelope> X12_FIELD = SdkField.<X12Envelope> builder(MarshallingType.SDK_POJO)
            .memberName("x12").getter(getter(OutboundEdiOptions::x12)).setter(setter(Builder::x12))
            .constructor(X12Envelope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("x12").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(X12_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final X12Envelope x12;

    private final Type type;

    private OutboundEdiOptions(BuilderImpl builder) {
        this.x12 = builder.x12;
        this.type = builder.type;
    }

    /**
     * <p>
     * A structure that contains an X12 envelope structure.
     * </p>
     * 
     * @return A structure that contains an X12 envelope structure.
     */
    public final X12Envelope x12() {
        return x12;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(x12());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutboundEdiOptions)) {
            return false;
        }
        OutboundEdiOptions other = (OutboundEdiOptions) obj;
        return Objects.equals(x12(), other.x12());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutboundEdiOptions").add("X12", x12()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "x12":
            return Optional.ofNullable(clazz.cast(x12()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #x12()} initialized to the given value.
     *
     * <p>
     * A structure that contains an X12 envelope structure.
     * </p>
     * 
     * @param x12
     *        A structure that contains an X12 envelope structure.
     */
    public static OutboundEdiOptions fromX12(X12Envelope x12) {
        return builder().x12(x12).build();
    }

    /**
     * Create an instance of this class with {@link #x12()} initialized to the given value.
     *
     * <p>
     * A structure that contains an X12 envelope structure.
     * </p>
     * 
     * @param x12
     *        A structure that contains an X12 envelope structure.
     */
    public static OutboundEdiOptions fromX12(Consumer<X12Envelope.Builder> x12) {
        X12Envelope.Builder builder = X12Envelope.builder();
        x12.accept(builder);
        return fromX12(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x12", X12_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutboundEdiOptions, T> g) {
        return obj -> g.apply((OutboundEdiOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutboundEdiOptions> {
        /**
         * <p>
         * A structure that contains an X12 envelope structure.
         * </p>
         * 
         * @param x12
         *        A structure that contains an X12 envelope structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder x12(X12Envelope x12);

        /**
         * <p>
         * A structure that contains an X12 envelope structure.
         * </p>
         * This is a convenience method that creates an instance of the {@link X12Envelope.Builder} avoiding the need to
         * create one manually via {@link X12Envelope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link X12Envelope.Builder#build()} is called immediately and its result
         * is passed to {@link #x12(X12Envelope)}.
         * 
         * @param x12
         *        a consumer that will call methods on {@link X12Envelope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #x12(X12Envelope)
         */
        default Builder x12(Consumer<X12Envelope.Builder> x12) {
            return x12(X12Envelope.builder().applyMutation(x12).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private X12Envelope x12;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OutboundEdiOptions model) {
            x12(model.x12);
        }

        public final X12Envelope.Builder getX12() {
            return x12 != null ? x12.toBuilder() : null;
        }

        public final void setX12(X12Envelope.BuilderImpl x12) {
            Object oldValue = this.x12;
            this.x12 = x12 != null ? x12.build() : null;
            handleUnionValueChange(Type.X12, oldValue, this.x12);
        }

        @Override
        public final Builder x12(X12Envelope x12) {
            Object oldValue = this.x12;
            this.x12 = x12;
            handleUnionValueChange(Type.X12, oldValue, this.x12);
            return this;
        }

        @Override
        public OutboundEdiOptions build() {
            return new OutboundEdiOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see OutboundEdiOptions#type()
     */
    public enum Type {
        X12,

        UNKNOWN_TO_SDK_VERSION
    }
}
