/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the mapping template for the transformer. This template is used to map the parsed EDI file using JSONata or
 * XSLT.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Mapping implements SdkPojo, Serializable, ToCopyableBuilder<Mapping.Builder, Mapping> {
    private static final SdkField<String> TEMPLATE_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateLanguage").getter(getter(Mapping::templateLanguageAsString))
            .setter(setter(Builder::templateLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateLanguage").build()).build();

    private static final SdkField<String> TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("template").getter(getter(Mapping::template)).setter(setter(Builder::template))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_LANGUAGE_FIELD,
            TEMPLATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String templateLanguage;

    private final String template;

    private Mapping(BuilderImpl builder) {
        this.templateLanguage = builder.templateLanguage;
        this.template = builder.template;
    }

    /**
     * <p>
     * The transformation language for the template, either XSLT or JSONATA.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateLanguage}
     * will return {@link MappingTemplateLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #templateLanguageAsString}.
     * </p>
     * 
     * @return The transformation language for the template, either XSLT or JSONATA.
     * @see MappingTemplateLanguage
     */
    public final MappingTemplateLanguage templateLanguage() {
        return MappingTemplateLanguage.fromValue(templateLanguage);
    }

    /**
     * <p>
     * The transformation language for the template, either XSLT or JSONATA.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateLanguage}
     * will return {@link MappingTemplateLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #templateLanguageAsString}.
     * </p>
     * 
     * @return The transformation language for the template, either XSLT or JSONATA.
     * @see MappingTemplateLanguage
     */
    public final String templateLanguageAsString() {
        return templateLanguage;
    }

    /**
     * <p>
     * A string that represents the mapping template, in the transformation language specified in
     * <code>templateLanguage</code>.
     * </p>
     * 
     * @return A string that represents the mapping template, in the transformation language specified in
     *         <code>templateLanguage</code>.
     */
    public final String template() {
        return template;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(template());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mapping)) {
            return false;
        }
        Mapping other = (Mapping) obj;
        return Objects.equals(templateLanguageAsString(), other.templateLanguageAsString())
                && Objects.equals(template(), other.template());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Mapping").add("TemplateLanguage", templateLanguageAsString()).add("Template", template())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templateLanguage":
            return Optional.ofNullable(clazz.cast(templateLanguageAsString()));
        case "template":
            return Optional.ofNullable(clazz.cast(template()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("templateLanguage", TEMPLATE_LANGUAGE_FIELD);
        map.put("template", TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Mapping, T> g) {
        return obj -> g.apply((Mapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Mapping> {
        /**
         * <p>
         * The transformation language for the template, either XSLT or JSONATA.
         * </p>
         * 
         * @param templateLanguage
         *        The transformation language for the template, either XSLT or JSONATA.
         * @see MappingTemplateLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MappingTemplateLanguage
         */
        Builder templateLanguage(String templateLanguage);

        /**
         * <p>
         * The transformation language for the template, either XSLT or JSONATA.
         * </p>
         * 
         * @param templateLanguage
         *        The transformation language for the template, either XSLT or JSONATA.
         * @see MappingTemplateLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MappingTemplateLanguage
         */
        Builder templateLanguage(MappingTemplateLanguage templateLanguage);

        /**
         * <p>
         * A string that represents the mapping template, in the transformation language specified in
         * <code>templateLanguage</code>.
         * </p>
         * 
         * @param template
         *        A string that represents the mapping template, in the transformation language specified in
         *        <code>templateLanguage</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder template(String template);
    }

    static final class BuilderImpl implements Builder {
        private String templateLanguage;

        private String template;

        private BuilderImpl() {
        }

        private BuilderImpl(Mapping model) {
            templateLanguage(model.templateLanguage);
            template(model.template);
        }

        public final String getTemplateLanguage() {
            return templateLanguage;
        }

        public final void setTemplateLanguage(String templateLanguage) {
            this.templateLanguage = templateLanguage;
        }

        @Override
        public final Builder templateLanguage(String templateLanguage) {
            this.templateLanguage = templateLanguage;
            return this;
        }

        @Override
        public final Builder templateLanguage(MappingTemplateLanguage templateLanguage) {
            this.templateLanguage(templateLanguage == null ? null : templateLanguage.toString());
            return this;
        }

        public final String getTemplate() {
            return template;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        @Override
        public Mapping build() {
            return new Mapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
