/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTransformerJobResponse extends B2BiResponse implements
        ToCopyableBuilder<GetTransformerJobResponse.Builder, GetTransformerJobResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetTransformerJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<S3Location>> OUTPUT_FILES_FIELD = SdkField
            .<List<S3Location>> builder(MarshallingType.LIST)
            .memberName("outputFiles")
            .getter(getter(GetTransformerJobResponse::outputFiles))
            .setter(setter(Builder::outputFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputFiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3Location::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(GetTransformerJobResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            OUTPUT_FILES_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private final List<S3Location> outputFiles;

    private final String message;

    private GetTransformerJobResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.outputFiles = builder.outputFiles;
        this.message = builder.message;
    }

    /**
     * <p>
     * Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>, or
     * <code>failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TransformerJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>, or
     *         <code>failed</code>.
     * @see TransformerJobStatus
     */
    public final TransformerJobStatus status() {
        return TransformerJobStatus.fromValue(status);
    }

    /**
     * <p>
     * Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>, or
     * <code>failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TransformerJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>, or
     *         <code>failed</code>.
     * @see TransformerJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputFiles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputFiles() {
        return outputFiles != null && !(outputFiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the location for the output files. If the caller specified a directory for the output, then this contains
     * the full path to the output file, including the file name generated by the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputFiles} method.
     * </p>
     * 
     * @return Returns the location for the output files. If the caller specified a directory for the output, then this
     *         contains the full path to the output file, including the file name generated by the service.
     */
    public final List<S3Location> outputFiles() {
        return outputFiles;
    }

    /**
     * <p>
     * Returns an optional error message, which gets populated when the job is not run successfully.
     * </p>
     * 
     * @return Returns an optional error message, which gets populated when the job is not run successfully.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputFiles() ? outputFiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransformerJobResponse)) {
            return false;
        }
        GetTransformerJobResponse other = (GetTransformerJobResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && hasOutputFiles() == other.hasOutputFiles()
                && Objects.equals(outputFiles(), other.outputFiles()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTransformerJobResponse").add("Status", statusAsString())
                .add("OutputFiles", hasOutputFiles() ? outputFiles() : null).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "outputFiles":
            return Optional.ofNullable(clazz.cast(outputFiles()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("outputFiles", OUTPUT_FILES_FIELD);
        map.put("message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTransformerJobResponse, T> g) {
        return obj -> g.apply((GetTransformerJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends B2BiResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTransformerJobResponse> {
        /**
         * <p>
         * Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>, or
         * <code>failed</code>.
         * </p>
         * 
         * @param status
         *        Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>,
         *        or <code>failed</code>.
         * @see TransformerJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformerJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>, or
         * <code>failed</code>.
         * </p>
         * 
         * @param status
         *        Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>,
         *        or <code>failed</code>.
         * @see TransformerJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformerJobStatus
         */
        Builder status(TransformerJobStatus status);

        /**
         * <p>
         * Returns the location for the output files. If the caller specified a directory for the output, then this
         * contains the full path to the output file, including the file name generated by the service.
         * </p>
         * 
         * @param outputFiles
         *        Returns the location for the output files. If the caller specified a directory for the output, then
         *        this contains the full path to the output file, including the file name generated by the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputFiles(Collection<S3Location> outputFiles);

        /**
         * <p>
         * Returns the location for the output files. If the caller specified a directory for the output, then this
         * contains the full path to the output file, including the file name generated by the service.
         * </p>
         * 
         * @param outputFiles
         *        Returns the location for the output files. If the caller specified a directory for the output, then
         *        this contains the full path to the output file, including the file name generated by the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputFiles(S3Location... outputFiles);

        /**
         * <p>
         * Returns the location for the output files. If the caller specified a directory for the output, then this
         * contains the full path to the output file, including the file name generated by the service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.b2bi.model.S3Location.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.b2bi.model.S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.b2bi.model.S3Location.Builder#build()} is called immediately and its
         * result is passed to {@link #outputFiles(List<S3Location>)}.
         * 
         * @param outputFiles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.b2bi.model.S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputFiles(java.util.Collection<S3Location>)
         */
        Builder outputFiles(Consumer<S3Location.Builder>... outputFiles);

        /**
         * <p>
         * Returns an optional error message, which gets populated when the job is not run successfully.
         * </p>
         * 
         * @param message
         *        Returns an optional error message, which gets populated when the job is not run successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl extends B2BiResponse.BuilderImpl implements Builder {
        private String status;

        private List<S3Location> outputFiles = DefaultSdkAutoConstructList.getInstance();

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransformerJobResponse model) {
            super(model);
            status(model.status);
            outputFiles(model.outputFiles);
            message(model.message);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TransformerJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<S3Location.Builder> getOutputFiles() {
            List<S3Location.Builder> result = S3LocationListCopier.copyToBuilder(this.outputFiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputFiles(Collection<S3Location.BuilderImpl> outputFiles) {
            this.outputFiles = S3LocationListCopier.copyFromBuilder(outputFiles);
        }

        @Override
        public final Builder outputFiles(Collection<S3Location> outputFiles) {
            this.outputFiles = S3LocationListCopier.copy(outputFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputFiles(S3Location... outputFiles) {
            outputFiles(Arrays.asList(outputFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputFiles(Consumer<S3Location.Builder>... outputFiles) {
            outputFiles(Stream.of(outputFiles).map(c -> S3Location.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public GetTransformerJobResponse build() {
            return new GetTransformerJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
