/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.X12Delimiters;
import software.amazon.awssdk.services.b2bi.model.X12FunctionalGroupHeaders;
import software.amazon.awssdk.services.b2bi.model.X12InterchangeControlHeaders;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class X12OutboundEdiHeaders
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, X12OutboundEdiHeaders> {
    private static final SdkField<X12InterchangeControlHeaders> INTERCHANGE_CONTROL_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("interchangeControlHeaders").getter(X12OutboundEdiHeaders.getter(X12OutboundEdiHeaders::interchangeControlHeaders)).setter(X12OutboundEdiHeaders.setter(Builder::interchangeControlHeaders)).constructor(X12InterchangeControlHeaders::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interchangeControlHeaders").build()}).build();
    private static final SdkField<X12FunctionalGroupHeaders> FUNCTIONAL_GROUP_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("functionalGroupHeaders").getter(X12OutboundEdiHeaders.getter(X12OutboundEdiHeaders::functionalGroupHeaders)).setter(X12OutboundEdiHeaders.setter(Builder::functionalGroupHeaders)).constructor(X12FunctionalGroupHeaders::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionalGroupHeaders").build()}).build();
    private static final SdkField<X12Delimiters> DELIMITERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("delimiters").getter(X12OutboundEdiHeaders.getter(X12OutboundEdiHeaders::delimiters)).setter(X12OutboundEdiHeaders.setter(Builder::delimiters)).constructor(X12Delimiters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delimiters").build()}).build();
    private static final SdkField<Boolean> VALIDATE_EDI_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("validateEdi").getter(X12OutboundEdiHeaders.getter(X12OutboundEdiHeaders::validateEdi)).setter(X12OutboundEdiHeaders.setter(Builder::validateEdi)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validateEdi").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERCHANGE_CONTROL_HEADERS_FIELD, FUNCTIONAL_GROUP_HEADERS_FIELD, DELIMITERS_FIELD, VALIDATE_EDI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("interchangeControlHeaders", INTERCHANGE_CONTROL_HEADERS_FIELD);
            this.put("functionalGroupHeaders", FUNCTIONAL_GROUP_HEADERS_FIELD);
            this.put("delimiters", DELIMITERS_FIELD);
            this.put("validateEdi", VALIDATE_EDI_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final X12InterchangeControlHeaders interchangeControlHeaders;
    private final X12FunctionalGroupHeaders functionalGroupHeaders;
    private final X12Delimiters delimiters;
    private final Boolean validateEdi;

    private X12OutboundEdiHeaders(BuilderImpl builder) {
        this.interchangeControlHeaders = builder.interchangeControlHeaders;
        this.functionalGroupHeaders = builder.functionalGroupHeaders;
        this.delimiters = builder.delimiters;
        this.validateEdi = builder.validateEdi;
    }

    public final X12InterchangeControlHeaders interchangeControlHeaders() {
        return this.interchangeControlHeaders;
    }

    public final X12FunctionalGroupHeaders functionalGroupHeaders() {
        return this.functionalGroupHeaders;
    }

    public final X12Delimiters delimiters() {
        return this.delimiters;
    }

    public final Boolean validateEdi() {
        return this.validateEdi;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.interchangeControlHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionalGroupHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(this.delimiters());
        hashCode = 31 * hashCode + Objects.hashCode(this.validateEdi());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12OutboundEdiHeaders)) {
            return false;
        }
        X12OutboundEdiHeaders other = (X12OutboundEdiHeaders)obj;
        return Objects.equals(this.interchangeControlHeaders(), other.interchangeControlHeaders()) && Objects.equals(this.functionalGroupHeaders(), other.functionalGroupHeaders()) && Objects.equals(this.delimiters(), other.delimiters()) && Objects.equals(this.validateEdi(), other.validateEdi());
    }

    public final String toString() {
        return ToString.builder((String)"X12OutboundEdiHeaders").add("InterchangeControlHeaders", (Object)this.interchangeControlHeaders()).add("FunctionalGroupHeaders", (Object)this.functionalGroupHeaders()).add("Delimiters", (Object)this.delimiters()).add("ValidateEdi", (Object)this.validateEdi()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "interchangeControlHeaders": {
                return Optional.ofNullable(clazz.cast(this.interchangeControlHeaders()));
            }
            case "functionalGroupHeaders": {
                return Optional.ofNullable(clazz.cast(this.functionalGroupHeaders()));
            }
            case "delimiters": {
                return Optional.ofNullable(clazz.cast(this.delimiters()));
            }
            case "validateEdi": {
                return Optional.ofNullable(clazz.cast(this.validateEdi()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<X12OutboundEdiHeaders, T> g) {
        return obj -> g.apply((X12OutboundEdiHeaders)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private X12InterchangeControlHeaders interchangeControlHeaders;
        private X12FunctionalGroupHeaders functionalGroupHeaders;
        private X12Delimiters delimiters;
        private Boolean validateEdi;

        private BuilderImpl() {
        }

        private BuilderImpl(X12OutboundEdiHeaders model) {
            this.interchangeControlHeaders(model.interchangeControlHeaders);
            this.functionalGroupHeaders(model.functionalGroupHeaders);
            this.delimiters(model.delimiters);
            this.validateEdi(model.validateEdi);
        }

        public final X12InterchangeControlHeaders.Builder getInterchangeControlHeaders() {
            return this.interchangeControlHeaders != null ? this.interchangeControlHeaders.toBuilder() : null;
        }

        public final void setInterchangeControlHeaders(X12InterchangeControlHeaders.BuilderImpl interchangeControlHeaders) {
            this.interchangeControlHeaders = interchangeControlHeaders != null ? interchangeControlHeaders.build() : null;
        }

        @Override
        public final Builder interchangeControlHeaders(X12InterchangeControlHeaders interchangeControlHeaders) {
            this.interchangeControlHeaders = interchangeControlHeaders;
            return this;
        }

        public final X12FunctionalGroupHeaders.Builder getFunctionalGroupHeaders() {
            return this.functionalGroupHeaders != null ? this.functionalGroupHeaders.toBuilder() : null;
        }

        public final void setFunctionalGroupHeaders(X12FunctionalGroupHeaders.BuilderImpl functionalGroupHeaders) {
            this.functionalGroupHeaders = functionalGroupHeaders != null ? functionalGroupHeaders.build() : null;
        }

        @Override
        public final Builder functionalGroupHeaders(X12FunctionalGroupHeaders functionalGroupHeaders) {
            this.functionalGroupHeaders = functionalGroupHeaders;
            return this;
        }

        public final X12Delimiters.Builder getDelimiters() {
            return this.delimiters != null ? this.delimiters.toBuilder() : null;
        }

        public final void setDelimiters(X12Delimiters.BuilderImpl delimiters) {
            this.delimiters = delimiters != null ? delimiters.build() : null;
        }

        @Override
        public final Builder delimiters(X12Delimiters delimiters) {
            this.delimiters = delimiters;
            return this;
        }

        public final Boolean getValidateEdi() {
            return this.validateEdi;
        }

        public final void setValidateEdi(Boolean validateEdi) {
            this.validateEdi = validateEdi;
        }

        @Override
        public final Builder validateEdi(Boolean validateEdi) {
            this.validateEdi = validateEdi;
            return this;
        }

        public X12OutboundEdiHeaders build() {
            return new X12OutboundEdiHeaders(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, X12OutboundEdiHeaders> {
        public Builder interchangeControlHeaders(X12InterchangeControlHeaders var1);

        default public Builder interchangeControlHeaders(Consumer<X12InterchangeControlHeaders.Builder> interchangeControlHeaders) {
            return this.interchangeControlHeaders((X12InterchangeControlHeaders)((X12InterchangeControlHeaders.Builder)X12InterchangeControlHeaders.builder().applyMutation(interchangeControlHeaders)).build());
        }

        public Builder functionalGroupHeaders(X12FunctionalGroupHeaders var1);

        default public Builder functionalGroupHeaders(Consumer<X12FunctionalGroupHeaders.Builder> functionalGroupHeaders) {
            return this.functionalGroupHeaders((X12FunctionalGroupHeaders)((X12FunctionalGroupHeaders.Builder)X12FunctionalGroupHeaders.builder().applyMutation(functionalGroupHeaders)).build());
        }

        public Builder delimiters(X12Delimiters var1);

        default public Builder delimiters(Consumer<X12Delimiters.Builder> delimiters) {
            return this.delimiters((X12Delimiters)((X12Delimiters.Builder)X12Delimiters.builder().applyMutation(delimiters)).build());
        }

        public Builder validateEdi(Boolean var1);
    }
}

