/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.B2BiRequest;
import software.amazon.awssdk.services.b2bi.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTransformerJobRequest
extends B2BiRequest
implements ToCopyableBuilder<Builder, StartTransformerJobRequest> {
    private static final SdkField<S3Location> INPUT_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputFile").getter(StartTransformerJobRequest.getter(StartTransformerJobRequest::inputFile)).setter(StartTransformerJobRequest.setter(Builder::inputFile)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFile").build()}).build();
    private static final SdkField<S3Location> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputLocation").getter(StartTransformerJobRequest.getter(StartTransformerJobRequest::outputLocation)).setter(StartTransformerJobRequest.setter(Builder::outputLocation)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()}).build();
    private static final SdkField<String> TRANSFORMER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transformerId").getter(StartTransformerJobRequest.getter(StartTransformerJobRequest::transformerId)).setter(StartTransformerJobRequest.setter(Builder::transformerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartTransformerJobRequest.getter(StartTransformerJobRequest::clientToken)).setter(StartTransformerJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FILE_FIELD, OUTPUT_LOCATION_FIELD, TRANSFORMER_ID_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("inputFile", INPUT_FILE_FIELD);
            this.put("outputLocation", OUTPUT_LOCATION_FIELD);
            this.put("transformerId", TRANSFORMER_ID_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final S3Location inputFile;
    private final S3Location outputLocation;
    private final String transformerId;
    private final String clientToken;

    private StartTransformerJobRequest(BuilderImpl builder) {
        super(builder);
        this.inputFile = builder.inputFile;
        this.outputLocation = builder.outputLocation;
        this.transformerId = builder.transformerId;
        this.clientToken = builder.clientToken;
    }

    public final S3Location inputFile() {
        return this.inputFile;
    }

    public final S3Location outputLocation() {
        return this.outputLocation;
    }

    public final String transformerId() {
        return this.transformerId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTransformerJobRequest)) {
            return false;
        }
        StartTransformerJobRequest other = (StartTransformerJobRequest)((Object)obj);
        return Objects.equals(this.inputFile(), other.inputFile()) && Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.transformerId(), other.transformerId()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartTransformerJobRequest").add("InputFile", (Object)this.inputFile()).add("OutputLocation", (Object)this.outputLocation()).add("TransformerId", (Object)this.transformerId()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputFile": {
                return Optional.ofNullable(clazz.cast(this.inputFile()));
            }
            case "outputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "transformerId": {
                return Optional.ofNullable(clazz.cast(this.transformerId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartTransformerJobRequest, T> g) {
        return obj -> g.apply((StartTransformerJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiRequest.BuilderImpl
    implements Builder {
        private S3Location inputFile;
        private S3Location outputLocation;
        private String transformerId;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTransformerJobRequest model) {
            super(model);
            this.inputFile(model.inputFile);
            this.outputLocation(model.outputLocation);
            this.transformerId(model.transformerId);
            this.clientToken(model.clientToken);
        }

        public final S3Location.Builder getInputFile() {
            return this.inputFile != null ? this.inputFile.toBuilder() : null;
        }

        public final void setInputFile(S3Location.BuilderImpl inputFile) {
            this.inputFile = inputFile != null ? inputFile.build() : null;
        }

        @Override
        public final Builder inputFile(S3Location inputFile) {
            this.inputFile = inputFile;
            return this;
        }

        public final S3Location.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        public final void setOutputLocation(S3Location.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        public final Builder outputLocation(S3Location outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final String getTransformerId() {
            return this.transformerId;
        }

        public final void setTransformerId(String transformerId) {
            this.transformerId = transformerId;
        }

        @Override
        public final Builder transformerId(String transformerId) {
            this.transformerId = transformerId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTransformerJobRequest build() {
            return new StartTransformerJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends B2BiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartTransformerJobRequest> {
        public Builder inputFile(S3Location var1);

        default public Builder inputFile(Consumer<S3Location.Builder> inputFile) {
            return this.inputFile((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(inputFile)).build());
        }

        public Builder outputLocation(S3Location var1);

        default public Builder outputLocation(Consumer<S3Location.Builder> outputLocation) {
            return this.outputLocation((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(outputLocation)).build());
        }

        public Builder transformerId(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

