/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal.response;

import java.util.concurrent.atomic.AtomicBoolean;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.http.HttpClientConnection;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpHeaderBlock;
import software.amazon.awssdk.crt.http.HttpStream;
import software.amazon.awssdk.http.HttpStatusFamily;
import software.amazon.awssdk.http.SdkHttpResponse;

@SdkInternalApi
public class ResponseHandlerHelper {
    private final SdkHttpResponse.Builder responseBuilder;
    private final HttpClientConnection connection;
    private AtomicBoolean connectionClosed = new AtomicBoolean(false);

    public ResponseHandlerHelper(SdkHttpResponse.Builder responseBuilder, HttpClientConnection connection) {
        this.responseBuilder = responseBuilder;
        this.connection = connection;
    }

    public void onResponseHeaders(HttpStream stream, int responseStatusCode, int headerType, HttpHeader[] nextHeaders) {
        if (headerType == HttpHeaderBlock.MAIN.getValue()) {
            for (HttpHeader h : nextHeaders) {
                this.responseBuilder.appendHeader(h.getName(), h.getValue());
            }
            this.responseBuilder.statusCode(responseStatusCode);
        }
    }

    public void releaseConnection(HttpStream stream) {
        if (this.connectionClosed.compareAndSet(false, true)) {
            this.connection.close();
            stream.close();
        }
    }

    public void closeConnection(HttpStream stream) {
        if (this.connectionClosed.compareAndSet(false, true)) {
            this.connection.shutdown();
            this.connection.close();
            stream.close();
        }
    }

    public void cleanUpConnectionBasedOnStatusCode(HttpStream stream) {
        if (HttpStatusFamily.of((int)this.responseBuilder.statusCode()) == HttpStatusFamily.SERVER_ERROR) {
            this.closeConnection(stream);
        } else {
            this.releaseConnection(stream);
        }
    }

    public AtomicBoolean connectionClosed() {
        return this.connectionClosed;
    }
}

