/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.crt.http.HttpClientConnectionManager;
import software.amazon.awssdk.crt.http.HttpException;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.HttpMetric;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.crt.AwsCrtHttpClientBase;
import software.amazon.awssdk.http.crt.ConnectionHealthConfiguration;
import software.amazon.awssdk.http.crt.ProxyConfiguration;
import software.amazon.awssdk.http.crt.TcpKeepAliveConfiguration;
import software.amazon.awssdk.http.crt.internal.AwsCrtClientBuilderBase;
import software.amazon.awssdk.http.crt.internal.CrtRequestContext;
import software.amazon.awssdk.http.crt.internal.CrtRequestExecutor;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkPublicApi
public final class AwsCrtHttpClient
extends AwsCrtHttpClientBase
implements SdkHttpClient {
    private AwsCrtHttpClient(DefaultBuilder builder, AttributeMap config) {
        super(builder, config);
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static SdkHttpClient create() {
        return new DefaultBuilder().build();
    }

    @Override
    public String clientName() {
        return super.clientName();
    }

    public ExecutableHttpRequest prepareRequest(HttpExecuteRequest request) {
        request.metricCollector().ifPresent(metricCollector -> metricCollector.reportMetric(HttpMetric.HTTP_CLIENT_NAME, (Object)this.clientName()));
        try (HttpClientConnectionManager crtConnPool = this.getOrCreateConnectionPool(this.poolKey(request.httpRequest()));){
            CrtRequestContext context = CrtRequestContext.builder().crtConnPool(crtConnPool).readBufferSize(this.readBufferSize).request(request).build();
            CrtHttpRequest crtHttpRequest = new CrtHttpRequest(context);
            return crtHttpRequest;
        }
    }

    private static final class DefaultBuilder
    extends AwsCrtClientBuilderBase<Builder>
    implements Builder {
        private DefaultBuilder() {
        }

        public AwsCrtHttpClient build() {
            return new AwsCrtHttpClient(this, this.getAttributeMap().build().merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS));
        }

        public AwsCrtHttpClient buildWithDefaults(AttributeMap serviceDefaults) {
            return new AwsCrtHttpClient(this, this.getAttributeMap().build().merge(serviceDefaults).merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS));
        }
    }

    public static interface Builder
    extends SdkHttpClient.Builder<Builder> {
        public Builder maxConcurrency(Integer var1);

        public Builder readBufferSizeInBytes(Long var1);

        public Builder proxyConfiguration(ProxyConfiguration var1);

        public Builder proxyConfiguration(Consumer<ProxyConfiguration.Builder> var1);

        public Builder connectionHealthConfiguration(ConnectionHealthConfiguration var1);

        public Builder connectionHealthConfiguration(Consumer<ConnectionHealthConfiguration.Builder> var1);

        public Builder connectionMaxIdleTime(Duration var1);

        public Builder connectionTimeout(Duration var1);

        public Builder tcpKeepAliveConfiguration(TcpKeepAliveConfiguration var1);

        public Builder tcpKeepAliveConfiguration(Consumer<TcpKeepAliveConfiguration.Builder> var1);

        public Builder postQuantumTlsEnabled(Boolean var1);
    }

    private static final class CrtHttpRequest
    implements ExecutableHttpRequest {
        private final CrtRequestContext context;
        private volatile CompletableFuture<SdkHttpFullResponse> responseFuture;

        private CrtHttpRequest(CrtRequestContext context) {
            this.context = context;
        }

        public HttpExecuteResponse call() throws IOException {
            HttpExecuteResponse.Builder builder = HttpExecuteResponse.builder();
            try {
                this.responseFuture = new CrtRequestExecutor().execute(this.context);
                SdkHttpFullResponse response = (SdkHttpFullResponse)CompletableFutureUtils.joinInterruptibly(this.responseFuture);
                builder.response((SdkHttpResponse)response);
                builder.responseBody((AbortableInputStream)response.content().orElse(null));
                return builder.build();
            }
            catch (CompletionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof HttpException) {
                    throw (HttpException)cause;
                }
                throw new RuntimeException(e.getCause());
            }
        }

        public void abort() {
            if (this.responseFuture != null) {
                this.responseFuture.cancel(true);
            }
        }
    }
}

