/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLHandshakeException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.HttpClientConnection;
import software.amazon.awssdk.crt.http.HttpClientConnectionManager;
import software.amazon.awssdk.crt.http.HttpException;
import software.amazon.awssdk.crt.http.HttpManagerMetrics;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandler;
import software.amazon.awssdk.http.HttpMetric;
import software.amazon.awssdk.http.SdkCancellationException;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.crt.internal.CrtAsyncRequestContext;
import software.amazon.awssdk.http.crt.internal.CrtRequestContext;
import software.amazon.awssdk.http.crt.internal.CrtUtils;
import software.amazon.awssdk.http.crt.internal.request.CrtRequestAdapter;
import software.amazon.awssdk.http.crt.internal.response.CrtResponseAdapter;
import software.amazon.awssdk.http.crt.internal.response.InputStreamAdaptingHttpStreamResponseHandler;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.NumericUtils;

@SdkInternalApi
public final class CrtRequestExecutor {
    public static final int CRT_TLS_NEGOTIATION_ERROR_CODE = 1029;
    private static final Logger log = Logger.loggerFor(CrtRequestExecutor.class);

    public CompletableFuture<SdkHttpFullResponse> execute(CrtRequestContext executionContext) {
        MetricCollector metricCollector = executionContext.metricCollector();
        boolean shouldPublishMetrics = metricCollector != null && !(metricCollector instanceof NoOpMetricCollector);
        long acquireStartTime = 0L;
        if (shouldPublishMetrics) {
            acquireStartTime = System.nanoTime();
        }
        CompletableFuture<SdkHttpFullResponse> requestFuture = new CompletableFuture<SdkHttpFullResponse>();
        CompletableFuture httpClientConnectionCompletableFuture = executionContext.crtConnPool().acquireConnection();
        long finalAcquireStartTime = acquireStartTime;
        httpClientConnectionCompletableFuture.whenComplete((crtConn, throwable) -> {
            if (shouldPublishMetrics) {
                CrtRequestExecutor.reportMetrics(executionContext.crtConnPool(), metricCollector, finalAcquireStartTime);
            }
            if (throwable != null) {
                HttpException httpException;
                IOException toThrow = throwable instanceof HttpException ? ((httpException = (HttpException)throwable).getErrorCode() == 1029 ? new SSLHandshakeException(httpException.getMessage()) : new IOException(httpException.getMessage(), httpException)) : new IOException("An exception occurred when acquiring a connection", (Throwable)throwable);
                requestFuture.completeExceptionally(toThrow);
                return;
            }
            this.executeRequest(executionContext, requestFuture, (HttpClientConnection)crtConn);
        });
        return requestFuture;
    }

    public CompletableFuture<Void> execute(CrtAsyncRequestContext executionContext) {
        MetricCollector metricCollector = executionContext.metricCollector();
        boolean shouldPublishMetrics = metricCollector != null && !(metricCollector instanceof NoOpMetricCollector);
        long acquireStartTime = 0L;
        if (shouldPublishMetrics) {
            acquireStartTime = System.nanoTime();
        }
        CompletableFuture<Void> requestFuture = this.createAsyncExecutionFuture(executionContext.sdkRequest());
        CompletableFuture httpClientConnectionCompletableFuture = executionContext.crtConnPool().acquireConnection();
        long finalAcquireStartTime = acquireStartTime;
        httpClientConnectionCompletableFuture.whenComplete((crtConn, throwable) -> {
            AsyncExecuteRequest asyncRequest = executionContext.sdkRequest();
            if (shouldPublishMetrics) {
                CrtRequestExecutor.reportMetrics(executionContext.crtConnPool(), metricCollector, finalAcquireStartTime);
            }
            if (throwable != null) {
                HttpException httpException;
                IOException toThrow = new IOException("An exception occurred when acquiring a connection", (Throwable)throwable);
                if (throwable instanceof HttpException && (httpException = (HttpException)throwable).getErrorCode() == 1029) {
                    toThrow = new SSLHandshakeException(httpException.getMessage());
                }
                this.reportAsyncFailure((HttpClientConnection)crtConn, toThrow, requestFuture, asyncRequest.responseHandler());
                return;
            }
            this.executeRequest(executionContext, requestFuture, (HttpClientConnection)crtConn, asyncRequest);
        });
        return requestFuture;
    }

    private static void reportMetrics(HttpClientConnectionManager connManager, MetricCollector metricCollector, long acquireStartTime) {
        long acquireCompletionTime = System.nanoTime();
        Duration acquireTimeTaken = Duration.ofNanos(acquireCompletionTime - acquireStartTime);
        metricCollector.reportMetric(HttpMetric.CONCURRENCY_ACQUIRE_DURATION, (Object)acquireTimeTaken);
        HttpManagerMetrics managerMetrics = connManager.getManagerMetrics();
        metricCollector.reportMetric(HttpMetric.MAX_CONCURRENCY, (Object)connManager.getMaxConnections());
        metricCollector.reportMetric(HttpMetric.AVAILABLE_CONCURRENCY, (Object)NumericUtils.saturatedCast((long)managerMetrics.getAvailableConcurrency()));
        metricCollector.reportMetric(HttpMetric.LEASED_CONCURRENCY, (Object)NumericUtils.saturatedCast((long)managerMetrics.getLeasedConcurrency()));
        metricCollector.reportMetric(HttpMetric.PENDING_CONCURRENCY_ACQUIRES, (Object)NumericUtils.saturatedCast((long)managerMetrics.getPendingConcurrencyAcquires()));
    }

    private void executeRequest(CrtAsyncRequestContext executionContext, CompletableFuture<Void> requestFuture, HttpClientConnection crtConn, AsyncExecuteRequest asyncRequest) {
        HttpRequest crtRequest = CrtRequestAdapter.toAsyncCrtRequest(executionContext);
        HttpStreamResponseHandler crtResponseHandler = CrtResponseAdapter.toCrtResponseHandler(crtConn, requestFuture, asyncRequest.responseHandler());
        try {
            crtConn.makeRequest(crtRequest, crtResponseHandler).activate();
        }
        catch (HttpException e) {
            Throwable toThrow = CrtUtils.wrapWithIoExceptionIfRetryable(e);
            this.reportAsyncFailure(crtConn, toThrow, requestFuture, asyncRequest.responseHandler());
        }
        catch (IllegalStateException | CrtRuntimeException e) {
            this.reportAsyncFailure(crtConn, new IOException("An exception occurred when making the request", e), requestFuture, asyncRequest.responseHandler());
        }
    }

    private void executeRequest(CrtRequestContext executionContext, CompletableFuture<SdkHttpFullResponse> requestFuture, HttpClientConnection crtConn) {
        HttpRequest crtRequest = CrtRequestAdapter.toCrtRequest(executionContext);
        try {
            InputStreamAdaptingHttpStreamResponseHandler crtResponseHandler = new InputStreamAdaptingHttpStreamResponseHandler(crtConn, requestFuture);
            crtConn.makeRequest(crtRequest, (HttpStreamResponseHandler)crtResponseHandler).activate();
        }
        catch (HttpException e) {
            crtConn.close();
            Throwable toThrow = CrtUtils.wrapWithIoExceptionIfRetryable(e);
            requestFuture.completeExceptionally(toThrow);
        }
        catch (IllegalStateException | CrtRuntimeException e) {
            crtConn.close();
            requestFuture.completeExceptionally(e);
        }
    }

    private CompletableFuture<Void> createAsyncExecutionFuture(AsyncExecuteRequest request) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        future.whenComplete((r, t) -> {
            if (t == null) {
                return;
            }
            if (future.isCancelled()) {
                request.responseHandler().onError((Throwable)new SdkCancellationException("The request was cancelled"));
            }
        });
        return future;
    }

    private void reportAsyncFailure(HttpClientConnection crtConn, Throwable cause, CompletableFuture<Void> executeFuture, SdkAsyncHttpResponseHandler responseHandler) {
        if (crtConn != null) {
            crtConn.close();
        }
        try {
            responseHandler.onError(cause);
        }
        catch (Exception e) {
            log.error(() -> "SdkAsyncHttpResponseHandler " + responseHandler + " threw an exception in onError. It will be ignored.", (Throwable)e);
        }
        executeFuture.completeExceptionally(cause);
    }
}

