/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandler;
import software.amazon.awssdk.http.SdkCancellationException;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.crt.internal.CrtRequestContext;
import software.amazon.awssdk.http.crt.internal.request.CrtRequestAdapter;
import software.amazon.awssdk.http.crt.internal.response.CrtResponseAdapter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class CrtRequestExecutor {
    private static final Logger log = Logger.loggerFor(CrtRequestExecutor.class);

    public CompletableFuture<Void> execute(CrtRequestContext executionContext) {
        CompletableFuture<Void> requestFuture = this.createExecutionFuture(executionContext.sdkRequest());
        CompletableFuture httpClientConnectionCompletableFuture = executionContext.crtConnPool().acquireConnection();
        httpClientConnectionCompletableFuture.whenComplete((crtConn, throwable) -> {
            AsyncExecuteRequest asyncRequest = executionContext.sdkRequest();
            if (throwable != null) {
                this.reportFailure(new IOException("An exception occurred when acquiring a connection", (Throwable)throwable), requestFuture, asyncRequest.responseHandler());
                return;
            }
            HttpRequest crtRequest = CrtRequestAdapter.toCrtRequest(executionContext);
            HttpStreamResponseHandler crtResponseHandler = CrtResponseAdapter.toCrtResponseHandler(crtConn, requestFuture, asyncRequest.responseHandler());
            try {
                crtConn.makeRequest(crtRequest, crtResponseHandler).activate();
            }
            catch (IllegalStateException | CrtRuntimeException e) {
                this.reportFailure(new IOException("An exception occurred when making the request", e), requestFuture, asyncRequest.responseHandler());
            }
        });
        return requestFuture;
    }

    private CompletableFuture<Void> createExecutionFuture(AsyncExecuteRequest request) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        future.whenComplete((r, t) -> {
            if (t == null) {
                return;
            }
            if (future.isCancelled()) {
                request.responseHandler().onError((Throwable)new SdkCancellationException("The request was cancelled"));
            }
        });
        return future;
    }

    private void reportFailure(Throwable cause, CompletableFuture<Void> executeFuture, SdkAsyncHttpResponseHandler responseHandler) {
        try {
            responseHandler.onError(cause);
        }
        catch (Exception e) {
            log.error(() -> "SdkAsyncHttpResponseHandler " + responseHandler + " threw an exception in onError. It will be ignored.", (Throwable)e);
        }
        executeFuture.completeExceptionally(cause);
    }
}

