/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.http.HttpClientConnectionManager;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.metrics.MetricCollector;

@SdkInternalApi
public final class CrtRequestContext {
    private final AsyncExecuteRequest request;
    private final int readBufferSize;
    private final HttpClientConnectionManager crtConnPool;
    private final MetricCollector metricCollector;

    private CrtRequestContext(Builder builder) {
        this.request = builder.request;
        this.readBufferSize = builder.readBufferSize;
        this.crtConnPool = builder.crtConnPool;
        this.metricCollector = this.request.metricCollector().orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public AsyncExecuteRequest sdkRequest() {
        return this.request;
    }

    public int readBufferSize() {
        return this.readBufferSize;
    }

    public HttpClientConnectionManager crtConnPool() {
        return this.crtConnPool;
    }

    public MetricCollector metricCollector() {
        return this.metricCollector;
    }

    public static class Builder {
        private AsyncExecuteRequest request;
        private int readBufferSize;
        private HttpClientConnectionManager crtConnPool;

        private Builder() {
        }

        public Builder request(AsyncExecuteRequest request) {
            this.request = request;
            return this;
        }

        public Builder readBufferSize(int readBufferSize) {
            this.readBufferSize = readBufferSize;
            return this;
        }

        public Builder crtConnPool(HttpClientConnectionManager crtConnPool) {
            this.crtConnPool = crtConnPool;
            return this;
        }

        public CrtRequestContext build() {
            return new CrtRequestContext(this);
        }
    }
}

