/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal.response;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.http.HttpClientConnection;
import software.amazon.awssdk.crt.http.HttpException;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpHeaderBlock;
import software.amazon.awssdk.crt.http.HttpStream;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandler;
import software.amazon.awssdk.http.HttpStatusFamily;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.crt.internal.CrtRequestContext;
import software.amazon.awssdk.http.crt.internal.response.CrtResponseBodyPublisher;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class CrtResponseAdapter
implements HttpStreamResponseHandler {
    private static final Logger log = Logger.loggerFor(CrtResponseAdapter.class);
    private final HttpClientConnection connection;
    private final CompletableFuture<Void> responseComplete;
    private final AsyncExecuteRequest sdkRequest;
    private final SdkHttpResponse.Builder respBuilder = SdkHttpResponse.builder();
    private final int windowSize;
    private CrtResponseBodyPublisher respBodyPublisher;

    private CrtResponseAdapter(HttpClientConnection connection, CompletableFuture<Void> responseComplete, AsyncExecuteRequest sdkRequest, int windowSize) {
        this.connection = (HttpClientConnection)Validate.notNull((Object)connection, (String)"HttpConnection is null", (Object[])new Object[0]);
        this.responseComplete = (CompletableFuture)Validate.notNull(responseComplete, (String)"reqComplete Future is null", (Object[])new Object[0]);
        this.sdkRequest = (AsyncExecuteRequest)Validate.notNull((Object)sdkRequest, (String)"AsyncExecuteRequest Future is null", (Object[])new Object[0]);
        this.windowSize = Validate.isPositive((int)windowSize, (String)"windowSize is <= 0");
    }

    public static HttpStreamResponseHandler toCrtResponseHandler(HttpClientConnection connection, CompletableFuture<Void> responseComplete, CrtRequestContext request) {
        return new CrtResponseAdapter(connection, responseComplete, request.sdkRequest(), request.readBufferSize());
    }

    private void initRespBodyPublisherIfNeeded(HttpStream stream) {
        if (this.respBodyPublisher == null) {
            this.respBodyPublisher = new CrtResponseBodyPublisher(this.connection, stream, this.responseComplete, this.windowSize);
        }
    }

    public void onResponseHeaders(HttpStream stream, int responseStatusCode, int blockType, HttpHeader[] nextHeaders) {
        this.initRespBodyPublisherIfNeeded(stream);
        for (HttpHeader h : nextHeaders) {
            this.respBuilder.appendHeader(h.getName(), h.getValue());
        }
    }

    public void onResponseHeadersDone(HttpStream stream, int headerType) {
        if (headerType == HttpHeaderBlock.MAIN.getValue()) {
            this.initRespBodyPublisherIfNeeded(stream);
            this.respBuilder.statusCode(stream.getResponseStatusCode());
            this.sdkRequest.responseHandler().onHeaders((SdkHttpResponse)this.respBuilder.build());
            this.sdkRequest.responseHandler().onStream((Publisher)this.respBodyPublisher);
        }
    }

    public int onResponseBody(HttpStream stream, byte[] bodyBytesIn) {
        this.initRespBodyPublisherIfNeeded(stream);
        this.respBodyPublisher.queueBuffer(bodyBytesIn);
        this.respBodyPublisher.publishToSubscribers();
        return 0;
    }

    public void onResponseComplete(HttpStream stream, int errorCode) {
        this.initRespBodyPublisherIfNeeded(stream);
        if (HttpStatusFamily.of((int)this.respBuilder.statusCode()) == HttpStatusFamily.SERVER_ERROR) {
            this.connection.shutdown();
        }
        if (errorCode == 0) {
            log.debug(() -> "Response Completed Successfully");
            this.respBodyPublisher.setQueueComplete();
            this.respBodyPublisher.publishToSubscribers();
        } else {
            HttpException error = new HttpException(errorCode);
            log.error(() -> "Response Encountered an Error.", (Throwable)error);
            try {
                this.sdkRequest.responseHandler().onError((Throwable)error);
            }
            catch (Exception e) {
                log.error(() -> String.format("SdkAsyncHttpResponseHandler %s threw an exception in onError: %s", this.sdkRequest.responseHandler(), e));
            }
            this.respBodyPublisher.setError((Throwable)error);
            this.respBodyPublisher.publishToSubscribers();
        }
    }
}

